/*
 * Decompiled with CFR 0.152.
 */
package dk.move;

import dk.Base;
import dk.Enemy;
import dk.Point;
import dk.Util;
import dk.move.Magnetic;
import dk.move.MagneticSourceController;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MagneticBulletDodger
extends MagneticSourceController {
    protected List bulletSources = new LinkedList();

    public BulletSource createSource(Point p, double strength, double size, long ttl) {
        return new BulletSource(p, strength, size, ttl);
    }

    public List getMagneticSources(Base robot) {
        long time = robot.getTime();
        Iterator iter = this.bulletSources.iterator();
        while (iter.hasNext()) {
            BulletSource s = (BulletSource)iter.next();
            if (s.isValid(time)) continue;
            iter.remove();
        }
        return this.bulletSources;
    }

    public void onEnemyBulletFired(Base robot, Enemy e, double power) {
        Point enemyPosition = e.getEstimatedPosition(robot.getTime());
        Point robotPosition = robot.getPosition();
        long now = robot.getTime() - 1L;
        long travelTime = Util.bulletTravelTime(Util.range(enemyPosition, robotPosition), power);
        this.bulletSources.add(this.createSource(robot.getPosition(), robot.config.MAGNETIC_BULLET_DODGE_STRENGTH, robot.config.MAGNETIC_BULLET_DODGE_RADIUS, now + travelTime));
        Point estimatedPosition = Util.applyHeading(robotPosition, robot.getHeadingRadians(), travelTime);
        long estimatedTravelTime = Util.bulletTravelTime(Util.range(enemyPosition, estimatedPosition), power);
        this.bulletSources.add(this.createSource(robot.getEstimatedPosition(now + 1L), robot.config.MAGNETIC_BULLET_DODGE_STRENGTH, robot.config.MAGNETIC_BULLET_DODGE_RADIUS, now + estimatedTravelTime));
        estimatedPosition = robotPosition;
        double heading = robot.getHeadingRadians();
        double velocity = robot.getVelocity();
        long timeInterval = travelTime;
        while (timeInterval > 0L) {
            if ((velocity += robot.getAcceleration()) > 8.0) {
                velocity = 8.0;
            } else if (velocity < -8.0) {
                velocity = -8.0;
            }
            heading += robot.getHeadingChange();
            heading = Util.normalizeHeading(heading);
            estimatedPosition = Util.applyHeading(estimatedPosition, heading, velocity);
            --timeInterval;
        }
        estimatedTravelTime = Util.bulletTravelTime(Util.range(enemyPosition, estimatedPosition), power);
        this.bulletSources.add(this.createSource(estimatedPosition, robot.config.MAGNETIC_BULLET_DODGE_STRENGTH, robot.config.MAGNETIC_BULLET_DODGE_RADIUS, now + estimatedTravelTime));
    }

    static class BulletSource
    extends Magnetic.LargeLinearSource {
        protected long ttl_;
        protected long extra_ = 5L;

        BulletSource(Point p, double strength, double size, long ttl) {
            super(p, strength, size);
            this.ttl_ = ttl;
        }

        public boolean isValid(long time) {
            return time <= this.ttl_ + this.extra_;
        }
    }
}

