/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.manager;

import de._4geeks.robots.utils.SUtils;
import java.io.Serializable;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class EnemyScan
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 7892368253L;
    public static int features = 8;
    private transient AdvancedRobot robot;
    private String name;
    private double heading;
    private double bearing;
    private long ctime;
    private double velocity;
    private double x;
    private double y;
    private double distance;
    private double absoluteBearing;
    private double acceleration;
    private double turning;
    private double angularVelocity;
    private double angularVelocityChange;
    private double advancingVelocity;
    private double orientation;
    private double forwardWallDistance;
    private double reverseWallDistance;
    private long timeSinceDirectionChange;
    private long timeSinceVelocityChange;
    private static final double HALF_PI = 1.5707963267948966;
    private static final double WALL_MARGIN = 18.0;
    private static final double S = 18.0;
    private static final double W = 18.0;
    private static final double N = 582.0;
    private static final double E = 782.0;

    public EnemyScan(AdvancedRobot robot, String name) {
        this.robot = robot;
        this.name = name;
    }

    public EnemyScan clone() throws CloneNotSupportedException {
        return (EnemyScan)super.clone();
    }

    public void update(ScannedRobotEvent e) {
        this.heading = e.getHeadingRadians();
        this.bearing = e.getBearingRadians();
        double abs = Utils.normalAbsoluteAngle((double)(this.robot.getHeadingRadians() + this.bearing));
        this.turning = this.absoluteBearing - abs;
        this.absoluteBearing = abs;
        this.acceleration = e.getVelocity() - this.velocity;
        if (this.velocity != e.getVelocity()) {
            this.timeSinceVelocityChange = e.getTime();
        }
        this.velocity = e.getVelocity();
        this.distance = e.getDistance();
        this.x = this.robot.getX() + Math.sin(abs) * this.distance;
        this.y = this.robot.getY() + Math.cos(abs) * this.distance;
        double lastDirection = SUtils.sign(this.angularVelocity);
        double lastAngularVelocity = this.angularVelocity;
        this.angularVelocity = this.velocity * Math.sin(this.getHeading() - this.getAbsoluteBearing());
        this.angularVelocityChange = lastAngularVelocity - this.angularVelocity;
        this.advancingVelocity = -this.velocity * Math.cos(this.getHeading() - this.getAbsoluteBearing());
        if (lastDirection * SUtils.sign(this.angularVelocity) < 0.0) {
            this.timeSinceDirectionChange = e.getTime();
        }
        this.orientation = SUtils.sign(Utils.normalRelativeAngle((double)(this.heading - this.absoluteBearing)));
        this.forwardWallDistance = this.wallDistance(this.distance, this.absoluteBearing, (int)SUtils.sign(this.angularVelocity));
        this.reverseWallDistance = this.wallDistance(this.distance, this.absoluteBearing, (int)(-SUtils.sign(this.angularVelocity)));
        this.ctime = e.getTime();
    }

    public double[] getFeatures() {
        double[] features = new double[EnemyScan.features];
        features[0] = this.indexRelativeAngle(this.heading - this.absoluteBearing);
        features[2] = this.indexTurning(this.turning);
        features[3] = this.indexTimeChange(this.timeSinceDirectionChange, 100.0);
        features[4] = this.indexWallDistance(this.getWallDistance(this.x, this.y));
        features[5] = this.indexAccleration(this.angularVelocityChange);
        features[6] = this.indexVelocity(this.advancingVelocity);
        features[7] = this.indexTimeChange(this.timeSinceVelocityChange, 50.0);
        return features;
    }

    public double getAbsoluteBearing() {
        return this.absoluteBearing;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getBearing() {
        return this.bearing;
    }

    public long getCtime() {
        return this.ctime;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getHeading() {
        return this.heading;
    }

    public String getName() {
        return this.name;
    }

    public double getTurning() {
        return this.turning;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double guessX(long when) {
        long diff = when - this.ctime;
        return this.x + Math.sin(this.heading) * this.velocity * (double)diff;
    }

    public double guessY(long when) {
        long diff = when - this.ctime;
        return this.y + Math.cos(this.heading) * this.velocity * (double)diff;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public double indexVelocity(double val) {
        return (val + 8.0) / 16.0;
    }

    public double indexAbsoluteAngle(double val) {
        return Utils.normalAbsoluteAngle((double)val) / (Math.PI * 2);
    }

    public double indexRelativeAngle(double val) {
        return (Utils.normalRelativeAngle((double)val) + Math.PI) / (Math.PI * 2);
    }

    public double indexAccleration(double val) {
        return (Math.max(Math.min(val, 2.0), -2.0) + 2.0) / 4.0;
    }

    public double indexTurning(double val) {
        double maxTurnRate = Math.toRadians(10.0);
        return Math.max(Math.min((val + maxTurnRate) / (2.0 * maxTurnRate), 1.0), 0.0);
    }

    public double indexDistance(double val, double max) {
        double distance = Math.min(val, max);
        return distance / max;
    }

    public double indexWallDistance(double val) {
        double size = Math.max(this.robot.getBattleFieldWidth(), this.robot.getBattleFieldWidth()) / 2.0;
        return val / size;
    }

    public double indexTimeChange(long val, double max) {
        return Math.min((double)(this.ctime - val), max) / max;
    }

    public double getWallDistance(double x, double y) {
        return Math.min(Math.min(x, this.robot.getBattleFieldWidth() - x), Math.min(y, this.robot.getBattleFieldWidth() - y));
    }

    public double getAngularVelocityChange() {
        return this.angularVelocityChange;
    }

    public long getTimeSinceDirectionChange() {
        return this.timeSinceDirectionChange;
    }

    public long getTimeSinceVelocityChange() {
        return this.timeSinceVelocityChange;
    }

    public double getAdvancingVelocity() {
        return this.advancingVelocity;
    }

    public double getForwardWallDistance() {
        if (this.forwardWallDistance > 0.0) {
            return this.forwardWallDistance;
        }
        return 0.0;
    }

    public double getReverseWallDistance() {
        if (this.reverseWallDistance > 0.0) {
            return this.reverseWallDistance;
        }
        return 0.0;
    }

    private double wallDistance(double eDist, double eAngle, int oDir) {
        return Math.min(Math.min(Math.min(this.distanceWest(582.0 - this.getY(), eDist, eAngle - 1.5707963267948966, oDir), this.distanceWest(782.0 - this.getX(), eDist, eAngle + Math.PI, oDir)), this.distanceWest(this.getY() - 18.0, eDist, eAngle + 1.5707963267948966, oDir)), this.distanceWest(this.getX() - 18.0, eDist, eAngle, oDir));
    }

    private double distanceWest(double toWall, double eDist, double eAngle, int oDir) {
        if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
        }
        double wallAngle = Math.acos((double)(-oDir) * toWall / eDist) + (double)oDir * 1.5707963267948966;
        return Utils.normalAbsoluteAngle((double)((double)oDir * (wallAngle - eAngle)));
    }

    public double getOrientation() {
        return this.orientation;
    }
}

