/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.connection;

import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdater;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.connection.LayerConnection;
import dmonner.xlbp.layer.WeightReceiverLayer;
import dmonner.xlbp.layer.WeightSenderLayer;

public class ImmutableDiagonalConnection
extends LayerConnection {
    private static final long serialVersionUID = 1L;
    private float w;

    public ImmutableDiagonalConnection(ImmutableDiagonalConnection that, NetworkCopier copier) {
        super(that, copier);
        this.w = that.w;
    }

    public ImmutableDiagonalConnection(String name, WeightReceiverLayer to, WeightSenderLayer from) {
        super(name, to, from);
        if (from.size() != to.size()) {
            throw new IllegalArgumentException("Sending and receiving layers of a DiagonalConnection must be the same size: " + from.size() + " != " + to.size());
        }
    }

    public ImmutableDiagonalConnection(WeightReceiverLayer to, WeightSenderLayer from) {
        this(from.getName() + "DiagonalTo" + to.getName(), to, from);
    }

    @Override
    public void activateTest() {
        int toSize = this.to.size();
        float[] y = this.to.getActivations();
        float[] x = this.from.getActivations();
        for (int j = 0; j < toSize; ++j) {
            y[j] = this.w * x[j];
        }
    }

    @Override
    public void activateTrain() {
        this.activateTest();
    }

    @Override
    public void clear() {
    }

    @Override
    public ImmutableDiagonalConnection copy(NetworkCopier copier) {
        return new ImmutableDiagonalConnection(this, copier);
    }

    @Override
    public float[] getCachedInput() {
        return null;
    }

    @Override
    public float getWeight(int j, int i) {
        return this.w;
    }

    @Override
    public void initializeAlphas(WeightUpdater lrs) {
    }

    @Override
    public void initializeWeights(WeightInitializer win) {
    }

    @Override
    public int nWeights() {
        return this.to.size();
    }

    @Override
    public void processBatch() {
    }

    public void set(float w) {
        this.w = w;
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
    }

    @Override
    public void setWeightUpdater(WeightUpdaterType wut) {
    }

    @Override
    public float[][] toEligibilitiesMatrix() {
        float[][] m = new float[this.to.size()][this.to.size()];
        return m;
    }

    @Override
    public float[][] toMatrix() {
        float[][] m = new float[this.to.size()][this.to.size()];
        for (int i = 0; i < this.to.size(); ++i) {
            m[i][i] = this.w;
        }
        return m;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showName()) {
            sb.indent();
            sb.append(this.name);
            sb.append(" : ");
            sb.append(this.getClass().getSimpleName());
            sb.appendln();
        }
        sb.pushIndent();
        if (sb.showWeights()) {
            sb.appendln("Untrainable Weights:");
            sb.pushIndent();
            sb.appendln(this.w + " (x" + this.to.size() + ")");
            sb.popIndent();
        }
        sb.popIndent();
    }

    @Override
    public void updateEligibilities(Responsibilities resp, Responsibilities prev) {
    }

    @Override
    public void updateResponsibilities() {
        float[] toD = this.getToLayerResponsibilities();
        if (toD == null) {
            return;
        }
        float[] fromD = this.getFromLayerResponsibilities();
        int toSize = this.to.size();
        for (int j = 0; j < toSize; ++j) {
            fromD[j] = this.w * toD[j];
        }
    }

    @Override
    public void updateWeights(float[][] dw) {
    }

    @Override
    public void updateWeightsFromEligibilities(Responsibilities copyresp) {
    }

    @Override
    public void updateWeightsFromInputs(Responsibilities resp) {
    }
}

