/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import dmonner.xlbp.util.IndexAwareHeapNode;
import java.util.Comparator;

public class IndexAwareHeap<E extends Comparable<E>> {
    private final IndexAwareHeapNode<E>[] h;
    private int size;
    private Comparator<E> comp;

    public static void main(String[] args) {
        IndexAwareHeap<Integer> h = new IndexAwareHeap<Integer>(15);
        h.add(14);
        System.out.println(h);
        h.add(29);
        System.out.println(h);
        h.add(30);
        System.out.println(h);
        h.add(24);
        System.out.println(h);
        h.add(5);
        System.out.println(h);
        h.add(15);
        System.out.println(h);
        h.add(4);
        System.out.println(h);
        h.add(35);
        System.out.println(h);
        h.add(11);
        System.out.println(h);
        h.add(5);
        System.out.println(h);
        h.add(0);
        System.out.println(h);
        h.add(36);
        System.out.println(h);
        h.add(2);
        System.out.println(h);
        h.add(5);
        System.out.println(h);
        h.add(14);
        System.out.println(h);
        System.out.println(h.remove());
        System.out.println(h);
        System.out.println(h.remove());
        System.out.println(h);
        System.out.println(h.remove());
        System.out.println(h);
        h.add(41);
        System.out.println(h);
        h.add(3);
        System.out.println(h);
        h.add(27);
        System.out.println(h);
        System.out.println(h);
        System.out.println(h.remove());
        System.out.println(h);
        System.out.println(h.remove());
        System.out.println(h);
        System.out.println(h.remove());
        System.out.println(h);
        System.out.println(h.remove(2));
        System.out.println(h);
        System.out.println(h.remove(4));
        System.out.println(h);
        System.out.println(h.remove(6));
        System.out.println(h);
        System.out.println(h.remove(8));
        System.out.println(h);
    }

    public IndexAwareHeap(int capacity) {
        this.h = new IndexAwareHeapNode[capacity];
        this.size = 0;
    }

    public IndexAwareHeap(int capacity, Comparator<E> comp) {
        this(capacity);
        this.comp = comp;
    }

    public IndexAwareHeapNode<E> add(E elem) {
        return this.add(new IndexAwareHeapNode<E>(elem));
    }

    public IndexAwareHeapNode<E> add(IndexAwareHeapNode<E> node) {
        this.set(this.size, node);
        this.heapifyUp(this.size);
        ++this.size;
        return node;
    }

    public Comparator<E> getComparator() {
        return this.comp;
    }

    private void heapifyDown(int idx) {
        IndexAwareHeapNode<E> l = this.left(idx);
        IndexAwareHeapNode<E> r = this.right(idx);
        IndexAwareHeapNode<E> c = this.h[idx];
        IndexAwareHeapNode<E> rep = null;
        if (l != null && l.compareTo(c) > 0 && (r == null || l.compareTo(r) >= 0)) {
            rep = l;
        }
        if (r != null && r.compareTo(c) > 0 && (l == null || r.compareTo(l) >= 0)) {
            rep = r;
        }
        if (rep != null) {
            int repIdx = rep.getIndex();
            this.set(idx, rep);
            this.set(repIdx, c);
            this.heapifyDown(repIdx);
        }
    }

    private void heapifyUp(int idx) {
        IndexAwareHeapNode<E> p = this.parent(idx);
        IndexAwareHeapNode<E> c = this.h[idx];
        if (p != null && c.compareTo(p) > 0) {
            int pIdx = p.getIndex();
            this.set(idx, p);
            this.set(pIdx, c);
            this.heapifyUp(pIdx);
        }
    }

    private IndexAwareHeapNode<E> left(int idx) {
        int lIdx = 2 * idx + 1;
        if (lIdx >= this.size) {
            return null;
        }
        return this.h[lIdx];
    }

    private IndexAwareHeapNode<E> parent(int idx) {
        if (idx == 0) {
            return null;
        }
        return this.h[(idx - 1) / 2];
    }

    public E peek() {
        return this.h[0].element;
    }

    public IndexAwareHeapNode<E> remove() {
        IndexAwareHeapNode<E> rv = this.h[0];
        --this.size;
        this.set(0, this.h[this.size]);
        this.heapifyDown(0);
        return rv;
    }

    public IndexAwareHeapNode<E> remove(IndexAwareHeapNode<E> node) {
        return this.remove(node.getIndex());
    }

    public IndexAwareHeapNode<E> remove(int idx) {
        IndexAwareHeapNode<E> rv = this.h[idx];
        --this.size;
        this.set(idx, this.h[this.size]);
        this.heapifyDown(idx);
        this.heapifyUp(idx);
        return rv;
    }

    private IndexAwareHeapNode<E> right(int idx) {
        int rIdx = 2 * idx + 2;
        if (rIdx >= this.size) {
            return null;
        }
        return this.h[rIdx];
    }

    private void set(int idx, IndexAwareHeapNode<E> node) {
        this.h[idx] = node;
        node.set(this, idx);
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.size > 0) {
            sb.append(this.h[0]);
        }
        for (int i = 1; i < this.size; ++i) {
            sb.append(", ");
            sb.append(this.h[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

