/*
 * Decompiled with CFR 0.152.
 */
package zezinho.Moviment;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.util.Utils;
import zezinho.Moviment.State;

public class Movement {
    static final int BINS = 47;
    final double WALL_STICK = 160.0;
    double oppSurroundingCircleRadius = 400.0;
    double[][][] surfStats = new double[4][5][47];
    State state;
    double goAngle;
    public OppWave surfWave;
    public ArrayList<OppWave> oppWaves = new ArrayList();
    public ArrayList<Integer> surfDirections = new ArrayList();
    public ArrayList<Double> surfAbsBearings = new ArrayList();
    Rectangle2D.Double fieldRectangle = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    double oppPrevEnergy = 100.0;
    double oppPrevVelocity = 0.0;
    double oppPrevDistance = 0.0;
    double myPrevVelocity = 0.0;
    Point2D.Double oppPrevLocation;
    Point2D.Double myPrevLocation;
    double advancingVelocityOpp;
    int hitsByOpp = 0;
    int oppBulletsFired = 0;
    Point2D.Double predictedPositionMinus = new Point2D.Double();
    Point2D.Double predictedPositionPlus = new Point2D.Double();
    double debugMinusDanger = 0.0;
    double debugPlusDanger = 0.0;

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public Movement(State state) {
        this.state = state;
    }

    public double onScannedRobot(boolean aproximate) {
        double oppEnergyLoss;
        double angleOffset = Utils.normalAbsoluteAngle((double)(this.state.oppHeading - this.state.bearingToOpp));
        double oppLateralVelocity = this.state.oppVelocity * Math.sin(angleOffset);
        this.surfDirections.add(0, new Integer(oppLateralVelocity >= 0.0 ? 1 : -1));
        this.surfAbsBearings.add(0, new Double(this.state.bearingToOpp + Math.PI));
        double oppBulletPower = this.oppPrevEnergy - this.state.oppEnergy;
        double wallDamage = 0.0;
        if (Math.abs(this.state.oppVelocity) == 0.0 && Math.abs(this.oppPrevVelocity) > 2.0) {
            wallDamage = Math.max(0.0, Math.abs(this.oppPrevVelocity) / 2.0 - 1.0);
        }
        if ((oppEnergyLoss = this.oppPrevEnergy - this.state.oppEnergy - wallDamage) < 3.01 && oppEnergyLoss > 0.09 && this.surfDirections.size() > 2) {
            ++this.oppBulletsFired;
            OppWave ow = new OppWave();
            ow.fireTime = this.state.time - 1L;
            ow.bulletVelocity = Rules.getBulletSpeed((double)oppEnergyLoss);
            ow.distanceTraveled = Rules.getBulletSpeed((double)oppEnergyLoss);
            ow.direction = this.surfDirections.get(2);
            ow.directAngle = this.surfAbsBearings.get(2);
            ow.fireLocation = (Point2D.Double)this.oppPrevLocation.clone();
            ow.waveGuessFactors = this.surfStats[(int)Math.min((ow.fireLocation.distance(this.myPrevLocation) + 50.0) / 200.0, 3.0)][(int)((Math.abs(this.myPrevVelocity) + 1.0) / 2.0)];
            this.oppWaves.add(ow);
        }
        this.updateWaves();
        this.oppPrevEnergy = this.state.oppEnergy;
        this.oppPrevLocation = this.state.oppLocation;
        this.oppPrevVelocity = this.state.oppVelocity;
        this.oppPrevDistance = this.state.oppDistance;
        this.myPrevVelocity = this.state.myVelocity;
        this.myPrevLocation = this.state.myLocation;
        this.surfWave = this.getClosestSurfableWave();
        if (this.surfWave != null) {
            double dangerRight = this.debugPlusDanger = this.checkDanger(1);
            double dangerLeft = this.debugMinusDanger = this.checkDanger(-1);
            this.goAngle = Movement.absoluteBearing(this.surfWave.fireLocation, this.state.myLocation);
            double correction = 1.5707963267948966;
            if (aproximate) {
                if (this.state.oppDistance > 130.0) {
                    correction = 2.25;
                } else if (this.state.oppDistance > 50.0) {
                    correction = 2.7;
                }
            }
            this.goAngle = dangerLeft < dangerRight ? this.doSmoothing(this.state.myLocation, this.goAngle - correction, -1, aproximate) : this.doSmoothing(this.state.myLocation, this.goAngle + correction, 1, aproximate);
        }
        return this.goAngle;
    }

    public static void setTurnTo(AdvancedRobot myBot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - myBot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                myBot.setTurnRightRadians(Math.PI + angle);
            } else {
                myBot.setTurnLeftRadians(Math.PI - angle);
            }
            myBot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                myBot.setTurnLeftRadians(-1.0 * angle);
            } else {
                myBot.setTurnRightRadians(angle);
            }
            myBot.setAhead(100.0);
        }
    }

    public double wallSmoothing(Point2D.Double startLocation, double startAngle, int orientation, double wallStick) {
        double angle = startAngle;
        double wallDistanceX = Math.min(startLocation.x - 18.0, this.fieldRectangle.width - startLocation.x - 18.0);
        double wallDistanceY = Math.min(startLocation.y - 18.0, this.fieldRectangle.height - startLocation.y - 18.0);
        if (wallDistanceX > wallStick && wallDistanceY > wallStick) {
            return startAngle;
        }
        double testX = startLocation.x + Math.sin(angle) * wallStick;
        double testY = startLocation.y + Math.cos(angle) * wallStick;
        double testDistanceX = Math.min(testX - 18.0, this.fieldRectangle.width - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this.fieldRectangle.height - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while ((testDistanceX < 0.0 || testDistanceY < 0.0) && g++ < 25) {
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = startLocation.x + Math.sin(angle += (double)orientation * (Math.abs(Math.acos(adjacent / wallStick)) + 5.0E-4)) * wallStick;
            testY = startLocation.y + Math.cos(angle) * wallStick;
            testDistanceX = Math.min(testX - 18.0, this.fieldRectangle.width - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this.fieldRectangle.height - testY - 18.0);
        }
        return angle;
    }

    private double doSmoothing(Point2D.Double location, double angle, int orientation, boolean aproximate) {
        int MAX_TRIES = 350;
        double angleOffset = Utils.normalAbsoluteAngle((double)(this.state.oppHeading - this.state.bearingToOpp));
        this.advancingVelocityOpp = -this.state.oppVelocity * Math.cos(angleOffset);
        int diff = this.advancingVelocityOpp > 6.5 ? 15 : 30;
        this.oppSurroundingCircleRadius = Math.min(400.0, this.state.myLocation.distance(this.state.oppLocation) + 160.0 - (double)diff);
        Point2D.Double stickLoc = Movement.project(location, angle, 160.0);
        int tries = 0;
        if (!aproximate && location.distance(this.state.oppLocation) > this.oppSurroundingCircleRadius - 160.0) {
            Ellipse2D.Double oppEllipse = new Ellipse2D.Double(this.state.oppLocation.x - this.oppSurroundingCircleRadius, this.state.oppLocation.y - this.oppSurroundingCircleRadius, this.oppSurroundingCircleRadius * 2.0, this.oppSurroundingCircleRadius * 2.0);
            for (tries = 0; oppEllipse.contains(stickLoc.x, stickLoc.y) && tries < 350; ++tries) {
                stickLoc = Movement.project(location, angle += (double)orientation * 0.1, 160.0);
            }
        }
        stickLoc = Movement.project(location, angle, 160.0);
        while (!this.fieldRectangle.contains(stickLoc.x, stickLoc.y)) {
            stickLoc = Movement.project(location, angle += (double)orientation * 0.1, 160.0);
            ++tries;
        }
        return angle;
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    private void logHit(OppWave ow, Point2D.Double targetLocation) {
        int index = Movement.getFactorIndex(ow, targetLocation, 47);
        for (int x = 0; x < 47; ++x) {
            double newValue = 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ow.waveGuessFactors[x] = 0.6 * ow.waveGuessFactors[x] + 0.4 * newValue;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        ++this.hitsByOpp;
        if (!this.oppWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            OppWave hitWave = null;
            for (int x = 0; x < this.oppWaves.size(); ++x) {
                OppWave ow = this.oppWaves.get(x);
                if (!(Math.abs(ow.distanceTraveled - this.state.myLocation.distance(ow.fireLocation)) < 50.0) || !(Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - ow.bulletVelocity) < 0.001)) continue;
                hitWave = ow;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.oppWaves.remove(this.oppWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.oppWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            OppWave hitWave = null;
            for (int x = 0; x < this.oppWaves.size(); ++x) {
                OppWave ow = this.oppWaves.get(x);
                if (!(Math.abs(ow.distanceTraveled - hitBulletLocation.distance(ow.fireLocation)) < 20.0)) continue;
                hitWave = ow;
                break;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.oppWaves.remove(this.oppWaves.lastIndexOf(hitWave));
            }
        }
    }

    private double checkDanger(int direction) {
        double lastPredictedDistance;
        Point2D.Double predictedPosition = (Point2D.Double)this.state.myLocation.clone();
        double predictedHeading = this.state.myHeading;
        double predictedVelocity = this.state.myVelocity;
        int counter = 3;
        do {
            double moveDir = 1.0;
            double moveAngle = this.doSmoothing(predictedPosition, this.surfWave.absoluteBearing(predictedPosition) + (double)direction * 1.5707963267948966, direction, false) - predictedHeading;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            double maxTurning = Rules.getTurnRateRadians((double)Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Movement.limit(-maxTurning, Utils.normalRelativeAngle((double)moveAngle), maxTurning)));
            predictedVelocity = Movement.limit(-8.0, predictedVelocity + (predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir), 8.0);
            predictedPosition = Movement.project(predictedPosition, predictedHeading, predictedVelocity);
            if (direction == -1) {
                this.predictedPositionMinus = predictedPosition;
                continue;
            }
            if (direction != 1) continue;
            this.predictedPositionPlus = predictedPosition;
        } while ((lastPredictedDistance = this.surfWave.distanceToPoint(predictedPosition)) >= this.surfWave.distanceTraveled + (double)(++counter) * this.surfWave.bulletVelocity);
        int index = Movement.getFactorIndex(this.surfWave, predictedPosition, 47);
        return this.surfWave.waveGuessFactors[index];
    }

    private void updateWaves() {
        for (int x = 0; x < this.oppWaves.size(); ++x) {
            OppWave ow = this.oppWaves.get(x);
            ow.distanceTraveled = (double)(this.state.time - ow.fireTime) * ow.bulletVelocity;
            if (!(ow.distanceTraveled > this.state.myLocation.distance(ow.fireLocation) + 50.0)) continue;
            this.oppWaves.remove(x);
            --x;
        }
    }

    private OppWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        OppWave closestSurfWave = null;
        for (OppWave ow : this.oppWaves) {
            double distance = this.state.myLocation.distance(ow.fireLocation) - ow.distanceTraveled;
            if (!(distance > ow.bulletVelocity) || !(distance < closestDistance)) continue;
            closestSurfWave = ow;
            closestDistance = distance;
        }
        return closestSurfWave;
    }

    public static int getFactorIndex(OppWave ow, Point2D.Double myLocation, int bins) {
        return (int)Movement.limit(0.0, Utils.normalRelativeAngle((double)(ow.absoluteBearing(myLocation) - ow.directAngle)) * (double)ow.direction / Math.asin(8.0 / ow.bulletVelocity) * (double)(bins - 1) / 2.0 + (double)((bins - 1) / 2), bins - 1);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public class OppWave {
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
        long fireTime;
        Point2D.Double fireLocation;
        double[] waveGuessFactors;

        public double absoluteBearing(Point2D.Double target) {
            return Math.atan2(target.x - this.fireLocation.x, target.y - this.fireLocation.y);
        }

        public double distanceToPoint(Point2D.Double p) {
            return this.fireLocation.distance(p);
        }
    }
}

