/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.util.Queue;
import pedersen.core.Competitor;
import pedersen.core.Foundation;
import pedersen.core.GameState;
import pedersen.core.Instructions;
import pedersen.debug.Stopwatches;
import pedersen.divination.CombatWaveBank;
import pedersen.divination.WaveOutboundImpl;
import pedersen.movement.MovementMethod;
import pedersen.opponent.Target;
import pedersen.physics.VelocityVector;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.ScannerSubsystem;
import pedersen.systems.TurretSubsystem;
import pedersen.systems.chassis.ChassisSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;
import pedersen.team.communication.CommuniqueMyBullet;
import pedersen.util.ExceptionHandler;

public class Combatant
extends Competitor.CompetitorBase
implements OnRound {
    private WaveOutboundImpl outboundWave = null;
    protected long paintingScalar = 1L;
    private static int initialGracePeriod;
    private static int gracePeriod;
    private static long gracePeriodIncrementFrequency;
    private static final Combatant singleton;

    static {
        gracePeriod = initialGracePeriod = 3;
        gracePeriodIncrementFrequency = 5L;
        singleton = new Combatant();
    }

    Combatant() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
    }

    public void operate(long time) {
        Stopwatches.combatantOperate.start();
        try {
            Stopwatches.combatantOperateGun.start();
            boolean firingBullet = false;
            Target target = TurretSubsystem.getInstance().getTarget();
            if (target != null && this.outboundWave != null && target.getFireControl().readyToFire(this.outboundWave, target)) {
                Combatant.fireBullet(this.outboundWave);
                firingBullet = true;
            }
            if (this.outboundWave != null && !firingBullet) {
                this.outboundWave.teardown();
            }
            this.outboundWave = null;
            Stopwatches.combatantOperateGun.stop();
            Stopwatches.combatantOperateChassis.start();
            VelocityVector movementVector = ChassisSubsystem.getInstance().getAbsoluteMovementVector();
            Instructions.getInstance().setMovementVector(movementVector);
            Stopwatches.combatantOperateChassis.stop();
            Stopwatches.combatantOperateTurret.start();
            this.outboundWave = TurretSubsystem.getInstance().getOutboundWave(Instructions.getInstance().getChassisFuturePosition());
            Stopwatches.combatantOperateTurret.stop();
            Stopwatches.combatantOperateScanner.start();
            ScannerSubsystem.getInstance().operate(Instructions.getInstance().getChassisFuturePosition());
            Stopwatches.combatantOperateScanner.stop();
        }
        catch (Exception ex) {
            ExceptionHandler.handleException(ex);
        }
        Stopwatches.combatantOperate.stop();
    }

    private static void fireBullet(WaveOutboundImpl wave) {
        Instructions.getInstance().fireGun(wave);
        CombatWaveBank.getInstance().add(wave);
        wave.enablePainting();
        CommuniqueMyBullet bo = new CommuniqueMyBullet(wave.getTimeOfCreation(), wave.getPosition().getX(), wave.getPosition().getY(), wave.firingSolution.getAbsoluteRadians(), wave.velocity());
        CommunicationSubsystem.getInstance().prepareCommunique(bo);
        ScannerSubsystem.getInstance().releaseTargetLock();
    }

    public void scan(Target scan) {
        ScannerSubsystem.getInstance().considerTarget(scan);
        TurretSubsystem.getInstance().considerTarget(scan);
    }

    public void recalibrate() {
        Queue<MovementMethod> movementMethods = null;
        Target target = TurretSubsystem.getInstance().getTarget();
        movementMethods = GameState.getInstance().isInDuelMode() && target != null && target.isActive() ? target.getMovementMethods() : Foundation.getInstance().getMovementMethods(GameState.getInstance().getActiveEnemyCount());
        ChassisSubsystem.getInstance().setMovementMethods(movementMethods, gracePeriod);
    }

    @Override
    public void onRound(int round) {
        super.onRound(round);
        gracePeriod = Math.min(5, initialGracePeriod + (int)((long)GameState.getInstance().getRound() / gracePeriodIncrementFrequency));
        this.recalibrate();
    }

    public void onRobotDeath(Target target) {
        this.recalibrate();
    }

    @Override
    public String description() {
        return String.valueOf(this.getClass().getSimpleName()) + "\n" + super.description();
    }

    public static Combatant getCombatant() {
        return singleton;
    }
}

