/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import pedersen.core.Competitor;
import pedersen.core.EnergyTracker;
import pedersen.core.Foundation;
import pedersen.core.GameState;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.WaveInboundImpl;
import pedersen.divination.analysis.WaveAnalysis;
import pedersen.movement.MovementMethod;
import pedersen.opponent.Target;
import pedersen.physics.Firepower;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Velocity;
import pedersen.physics.Wave;
import pedersen.physics.constant.FirepowerImpl;
import pedersen.physics.constant.WaveImpl;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.FireControl;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnGameOver;
import pedersen.systems.notifier.OnPaint;
import pedersen.systems.notifier.OnRound;
import pedersen.targeting.TargetingMethod;
import pedersen.team.communication.CommuniqueEnemyWave;
import pedersen.util.Constraints;
import pedersen.util.Conversions;

public abstract class TargetBase
extends Competitor.CompetitorBase
implements Target,
OnPaint,
OnRound,
OnGameOver {
    private final String name;
    private Iterable<TargetingMethod> offensiveTargetingMethods = new ArrayList<TargetingMethod>();
    private Iterable<TargetingMethod> defensiveTargetingMethods = new ArrayList<TargetingMethod>();
    protected Collection<WaveAnalysis> offensiveWaveAnalyses = new ArrayList<WaveAnalysis>();
    protected Collection<WaveAnalysis> defensiveWaveAnalyses = new ArrayList<WaveAnalysis>();
    protected Queue<MovementMethod> movementMethods;
    protected FireControl fireControl;
    private boolean isActive = true;
    private long lastShotFired = 0L;
    private double lastShotFirepower = 0.0;
    private final EnergyTracker energyTracker = new EnergyTracker();
    private int defensiveGunCount = 0;
    private int offensiveGunCount = 0;

    protected TargetBase(String newName) {
        Foundation robot = Foundation.getInstance();
        this.name = newName;
        this.movementMethods = robot.getMovementMethods();
        this.offensiveTargetingMethods = robot.getInboundTargetingMethods(this);
        this.defensiveTargetingMethods = robot.getOutboundTargetingMethods(this);
        this.fireControl = robot.getFireControl();
        NotificationSubsystem.getInstance().subscribeOnRound(this);
        NotificationSubsystem.getInstance().subscribeOnPaint(this);
        NotificationSubsystem.getInstance().subscribeOnGameOver(this);
        this.onRound(GameState.getInstance().getRound());
    }

    @Override
    public void update(Snapshot snapshot) {
        Snapshot legacy = this.getSnapshot();
        if (legacy == null || legacy.getRound() < snapshot.getRound()) {
            this.activate();
            super.update(snapshot);
        } else {
            long before = this.getSnapshot().getTime();
            if (snapshot.getTime() > before && this.isActive()) {
                if (before > 10L) {
                    snapshot.getTime();
                }
                super.update(snapshot);
                if (GraphicalDebugger.paintOpponents) {
                    GraphicalDebugger.traceVehicleMovement(this);
                }
            }
        }
    }

    @Override
    public void detectShotFired() {
        Snapshot snapshot = this.getSnapshot();
        if (snapshot != null) {
            double totalExpectedEnergy = this.energyTracker.getTotalExpectedEnergy();
            double energyDrop = totalExpectedEnergy - this.getSnapshot().getEnergy().energy();
            if (this.isGunCool() && Constraints.isFirepowerLegal(energyDrop)) {
                FirepowerImpl firepower = new FirepowerImpl(energyDrop);
                Position position = this.getHistoricalSnapshot(1L).getPosition();
                Velocity velocity = Conversions.getBulletVelocityFromFirepower(firepower);
                if (position == null) {
                    position = this.getSnapshot().getPosition();
                }
                if (position != null) {
                    WaveImpl wave = new WaveImpl(GameState.getInstance().getTurnBefore(), position, velocity);
                    CommunicationSubsystem.getInstance().prepareCommunique(new CommuniqueEnemyWave(wave.getTimeOfCreation(), wave.getPosition().getX(), wave.getPosition().getY(), wave.getVelocity().velocity()));
                    this.fire(wave);
                }
            } else {
                this.energyTracker.addUnexplainedEnergyLoss(energyDrop);
            }
        }
    }

    @Override
    public void fire(Wave wave) {
        Firepower firepower = Conversions.getFirepowerFromBulletVelocity(wave);
        this.setLastShotFired(wave.getTimeOfCreation());
        this.setLastShotFirepower(firepower.firepower());
        this.energyTracker.addShotEnergyExpenditure(firepower);
        new WaveInboundImpl(wave, this);
        NotificationSubsystem.getInstance().publishWaveCountChange();
    }

    @Override
    public boolean equals(Target other) {
        return other != null && this.name.compareTo(other.getName()) == 0;
    }

    @Override
    public WaveAnalysis assignOffensiveWaveAnalysis(WaveAnalysis waveAnalysis) {
        this.offensiveWaveAnalyses.add(waveAnalysis);
        return waveAnalysis;
    }

    @Override
    public WaveAnalysis assignDefensiveWaveAnalysis(WaveAnalysis waveAnalysis) {
        this.defensiveWaveAnalyses.add(waveAnalysis);
        return waveAnalysis;
    }

    @Override
    public void recordOffensiveWave(WaveInboundImpl wave, TargetAnalysis targetAnalysis) {
        for (WaveAnalysis e : this.offensiveWaveAnalyses) {
            e.recordWave(wave, targetAnalysis);
        }
    }

    @Override
    public void recordDefensiveWave(CombatWave wave, TargetAnalysis targetAnalysis) {
        for (WaveAnalysis e : this.defensiveWaveAnalyses) {
            e.recordWave(wave, targetAnalysis);
        }
    }

    @Override
    public void onRound(int round) {
        super.onRound(round);
        this.energyTracker.onRound();
        this.lastShotFired = 0L;
        this.lastShotFirepower = 0.0;
    }

    @Override
    public void teardown() {
        this.energyTracker.onRound();
    }

    @Override
    public void paint() {
        Snapshot snapshot;
        if (GraphicalDebugger.paintOpponents && (snapshot = this.getSnapshot()) != null) {
            GraphicalDebugger.drawVehicleCircle(snapshot.getPosition(), Color.darkGray);
        }
    }

    @Override
    public Queue<MovementMethod> getMovementMethods() {
        return this.movementMethods;
    }

    @Override
    public void setFireControl(FireControl newFireControl) {
        this.fireControl = newFireControl;
    }

    @Override
    public FireControl getFireControl() {
        return this.fireControl;
    }

    @Override
    public EnergyTracker getEnergyTracker() {
        return this.energyTracker;
    }

    @Override
    public boolean isActive() {
        return this.isActive && super.isSnapshotValid();
    }

    private void setLastShotFired(long time) {
        this.lastShotFired = time;
    }

    private long getLastShotFired() {
        return this.lastShotFired;
    }

    private void setLastShotFirepower(double firepower) {
        this.lastShotFirepower = firepower;
    }

    private double getLastShotFirepower() {
        return this.lastShotFirepower;
    }

    private void activate() {
        this.isActive = true;
    }

    @Override
    public void deactivate() {
        this.isActive = false;
    }

    @Override
    public Iterable<TargetingMethod> getOffensiveTargetingMethods() {
        return this.offensiveTargetingMethods;
    }

    @Override
    public Iterable<TargetingMethod> getDefensiveTargetingMethods() {
        return this.defensiveTargetingMethods;
    }

    @Override
    public long getElapsedTimeSinceLastScan() {
        return GameState.getInstance().getTurn() - this.getSnapshot().getTime();
    }

    private boolean isGunCool() {
        return GameState.getInstance().isGunCool(this.getLastShotFired(), this.getLastShotFirepower());
    }

    @Override
    public Position getPosition() {
        return this.isActive() && this.isSnapshotValid() ? this.getSnapshot().getPosition() : null;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("\u00bb " + this.name + " [" + this.getClass().getSimpleName() + "]");
        for (TargetingMethod targetingMethod : this.defensiveTargetingMethods) {
            buffer.append("\n\u2020 ").append(targetingMethod.description());
        }
        for (MovementMethod movementMethod : this.movementMethods) {
            buffer.append("\n\u2021 ").append(movementMethod.description());
        }
        buffer.append(this.energyTracker.description());
        buffer.append("\n");
        return buffer.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setDefensiveTargetingMethods(Iterable<TargetingMethod> methods) {
        this.defensiveTargetingMethods = methods;
        this.defensiveGunCount = 0;
        for (TargetingMethod e : this.defensiveTargetingMethods) {
            ++this.defensiveGunCount;
        }
    }

    protected void setOffensiveTargetingMethods(Iterable<TargetingMethod> methods) {
        this.offensiveTargetingMethods = methods;
        this.offensiveGunCount = 0;
        for (TargetingMethod e : this.offensiveTargetingMethods) {
            ++this.offensiveGunCount;
        }
    }

    @Override
    public int getDefensiveGunCount() {
        return this.defensiveGunCount;
    }

    @Override
    public int getOffensiveGunCount() {
        return this.offensiveGunCount;
    }
}

