/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import pa3k.AimingConfiguration;
import pa3k.CircleMoving;
import pa3k.Coloring;
import pa3k.Configurable;
import pa3k.Configuration;
import pa3k.EvasionConfiguration;
import pa3k.FastTronAimingConfiguration;
import pa3k.GlobalTracking;
import pa3k.Gun;
import pa3k.Log;
import pa3k.MCAimingConfiguration;
import pa3k.MonteCarlo;
import pa3k.Opponent;
import pa3k.OpponentCreator;
import pa3k.Position;
import pa3k.RandomMoving;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import pa3k.Tracking;
import pa3k.TronAimingConfiguration;
import pa3k.WaveSurfingConfiguration;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Quark
extends AdvancedRobot
implements Configurable,
OpponentCreator {
    protected RobotModule[] modules;
    protected Tracking tracking;
    protected Gun gun;
    protected CircleMoving moving;
    protected MonteCarlo mc;
    protected SelfTracking st;
    protected static EvasionConfiguration[] evasion = null;
    protected static AimingConfiguration[] aiming = null;
    protected EvasionConfiguration currentEvasion;
    protected AimingConfiguration currentAiming;
    protected static int roundCount = 0;

    public Quark() {
        ++roundCount;
        if (evasion == null) {
            evasion = new EvasionConfiguration[3];
            Quark.evasion[0] = new RandomMoving(false);
            Quark.evasion[1] = new RandomMoving(true);
            Quark.evasion[2] = new WaveSurfingConfiguration();
        }
        if (aiming == null) {
            aiming = new AimingConfiguration[3];
            Quark.aiming[0] = new MCAimingConfiguration();
            Quark.aiming[1] = new TronAimingConfiguration();
            Quark.aiming[2] = new FastTronAimingConfiguration();
        }
        this.st = new SelfTracking(this, 4);
        this.tracking = new GlobalTracking(this, this.st, this);
        this.mc = new MonteCarlo(this, this.tracking, this.st);
        this.currentAiming = (AimingConfiguration)this.chooseOne(aiming);
        this.currentEvasion = (EvasionConfiguration)this.chooseOne(evasion);
        this.currentAiming.apply(this, this);
        this.currentEvasion.apply(this, this);
        this.currentAiming.newRound();
        this.currentEvasion.newRound();
        this.tracking.setMoving(this.moving);
        this.tracking.setAimingConfiguration(this.currentAiming);
        this.tracking.setEvasiveConfiguration(this.currentEvasion);
        this.modules = new RobotModule[6];
        this.modules[0] = new Coloring(this, new Color(151, 151, 151), new Color(204, 204, 204), new Color(151, 151, 151), new Color(255, 255, 255), new Color(204, 204, 204));
        this.modules[1] = this.moving;
        this.modules[2] = this.st;
        this.modules[3] = this.tracking;
        this.modules[4] = this.mc;
        this.modules[5] = this.gun;
    }

    public Configuration chooseOne(Configuration[] array) {
        double sum = 0.0;
        if (Utils.getRandom().nextInt(15) < roundCount) {
            int best = 0;
            int i = 1;
            while (i < array.length) {
                if (array[best].getRating() < array[i].getRating()) {
                    best = i;
                }
                ++i;
            }
            Log.log(2, "Selecting the best confuguration: " + array[best] + "(" + array[best].getRating() + ")");
            return array[best];
        }
        Configuration[] configurationArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration c = configurationArray[n2];
            double r = c.getRating();
            sum += r;
            Log.log(2, c + ": " + r);
            ++n2;
        }
        double r = Utils.getRandom().nextDouble() * sum;
        Log.log(2, " random = " + r);
        double p = 0.0;
        Configuration[] configurationArray2 = array;
        int n3 = array.length;
        int n4 = 0;
        while (n4 < n3) {
            Configuration c = configurationArray2[n4];
            if ((p += c.getRating()) >= r) {
                return c;
            }
            ++n4;
        }
        return array[0];
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.tracking.bulletMissed(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tracking.opponentScanned(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.tracking.hitByBullet(e);
        this.currentEvasion.hit();
    }

    public void onBuletHitBullet(BulletHitBulletEvent e) {
        this.tracking.bulletHitBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.tracking.bulletHit(e);
        this.currentAiming.hit();
    }

    public void onHitRobot(HitRobotEvent e) {
        this.moving.onHitRobot(e);
        this.gun.hitRobot(this.tracking.getByName(e.getName()));
        this.tracking.onHitRobot(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.tracking.robotDeath(e);
        this.gun.robotDeath(e);
        this.mc.dumpData();
        this.currentAiming.dumpData();
        this.currentEvasion.dumpData();
    }

    public void onPaint(Graphics2D g) {
        RobotModule.onPaint(this.modules, g);
        Log.onPaint(g);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        Log.log(1, "***********************************");
        Log.log(1, "Turn " + e.getTime() + " skipped!");
    }

    public void onWin(WinEvent e) {
        this.mc.dumpData();
        this.currentAiming.dumpData();
        this.currentEvasion.dumpData();
    }

    public void run() {
        Position.setBattleField((Robot)this);
        Log.log(1, "Using  " + this.currentAiming);
        Log.log(1, "Using  " + this.currentEvasion);
        RobotModule.init(this.modules);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            RobotModule.turn(this.modules);
            this.execute();
        }
    }

    @Override
    public Opponent createOpponent(String name, AdvancedRobot robot) {
        return new Opponent(name, robot, this.currentAiming.getSelfAiming(this, this, name), this.currentEvasion.getOpponentAiming(this, this, name));
    }

    @Override
    public MonteCarlo getMonteCarlo() {
        return this.mc;
    }

    @Override
    public SelfTracking getSelfTracking() {
        return this.st;
    }

    @Override
    public Tracking getTracking() {
        return this.tracking;
    }

    @Override
    public void setGun(Gun g) {
        this.gun = g;
    }

    @Override
    public void setMoving(CircleMoving m) {
        this.moving = m;
    }
}

