/*
 * Decompiled with CFR 0.152.
 */
package ds;

import ds.Hud;
import ds.IComponent;
import ds.IEventListener;
import ds.ListenerDelegate;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.PaintEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public abstract class PluggableRobot
extends AdvancedRobot {
    private static boolean _battleInitialized = false;
    private static Hud _hud;
    private static PluggableRobot s_instance;
    private ListenerDelegate _listenerDelegate = new ListenerDelegate();
    private ArrayList<IComponent> _components = new ArrayList();
    private ArrayList<Hud.Painter> _painters = new ArrayList();
    private Point2D.Double _center;

    protected PluggableRobot() {
        s_instance = this;
    }

    public final void run() {
        if (!_battleInitialized) {
            _hud = new Hud((Robot)this);
            this.initializeBattle();
            _battleInitialized = true;
        }
        this.addCustomEvent(new Condition("eventManager"){

            public boolean test() {
                PluggableRobot.this.handleEvents();
                return false;
            }
        });
        this.initializeRound();
        while (true) {
            for (IComponent component : this._components) {
                component.Act();
            }
            this.execute();
        }
    }

    protected void initializeBattle() {
    }

    protected void initializeRound() {
    }

    public void onBeforeEventsProcessed() {
    }

    private void onAfterEventsProcessed() {
        Vector events = this.getAllEvents();
        for (Event event : events) {
            if (event.getClass().isAssignableFrom(PaintEvent.class)) continue;
            this.onPaint(this.getGraphics());
        }
    }

    public Point2D.Double getCenter() {
        if (this._center == null) {
            this._center = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        }
        return this._center;
    }

    protected void registerListener(IEventListener listener) {
        this._listenerDelegate.register(listener);
    }

    protected void registerComponent(IComponent component) {
        this._components.add(component);
    }

    protected void registerPainter(Hud.Painter painter) {
        this._painters.add(painter);
    }

    public final void onPaint(Graphics2D g) {
        _hud.setContext(g);
        for (Hud.Painter painter : this._painters) {
            painter.paint(_hud, this.getTime());
        }
        _hud.setContext(null);
    }

    private void handleEvents() {
        this.onBeforeEventsProcessed();
        this._listenerDelegate.processEvents(this.getAllEvents());
        this.onAfterEventsProcessed();
        this.clearAllEvents();
    }

    public final void onBattleEnded(BattleEndedEvent event) {
    }

    public final void onCustomEvent(CustomEvent event) {
    }

    public final void onDeath(DeathEvent event) {
    }

    public final void onSkippedTurn(SkippedTurnEvent event) {
    }

    public final void onBulletHit(BulletHitEvent event) {
    }

    public final void onBulletHitBullet(BulletHitBulletEvent event) {
    }

    public final void onBulletMissed(BulletMissedEvent event) {
    }

    public final void onHitByBullet(HitByBulletEvent event) {
    }

    public final void onHitRobot(HitRobotEvent event) {
    }

    public final void onHitWall(HitWallEvent event) {
    }

    public final void onRobotDeath(RobotDeathEvent event) {
    }

    public final void onScannedRobot(ScannedRobotEvent event) {
    }

    public final void onWin(WinEvent event) {
    }

    public static PluggableRobot getMe() {
        return s_instance;
    }

    public Point2D.Double getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }
}

