/*
 * Decompiled with CFR 0.152.
 */
package ds;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public class PositionLog
implements Cloneable {
    private ArrayList<Point2D.Double> m_positions = new ArrayList();
    private int m_size;

    public PositionLog(int size) {
        this.m_size = size;
    }

    public void add(Point2D.Double position) {
        this.m_positions.add(position);
        if (this.m_positions.size() > this.m_size) {
            this.m_positions.remove(0);
        }
    }

    public Point2D.Double get(int n) {
        return this.m_positions.get(n);
    }

    public Point2D.Double getNOrLast(int n) {
        int realN = n >= this.m_positions.size() ? this.m_positions.size() - 1 : n;
        return this.m_positions.get(realN);
    }

    public double distance(int from, int to) {
        if (this.m_positions.isEmpty()) {
            return 0.0;
        }
        return this.getNOrLast(from).distance(this.getNOrLast(to));
    }

    public double distanceSince(int n) {
        if (this.m_positions.isEmpty()) {
            return 0.0;
        }
        return this.get(0).distance(this.getNOrLast(n));
    }

    public PositionLog clone() {
        PositionLog o = null;
        try {
            o = (PositionLog)super.clone();
            o.m_positions = (ArrayList)this.m_positions.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
        }
        return o;
    }
}

