/*
 * Decompiled with CFR 0.152.
 */
package ds.gun;

import ds.Hud;
import ds.IEventListener;
import ds.constant.ConstantManager;
import ds.gun.AbstractGun;
import ds.gun.BulletPower;
import ds.gun.FireSolution;
import ds.gun.GunStats;
import ds.gun.IDataSaver;
import ds.gun.IGunManager;
import ds.gun.dsgf.DSGFGun;
import ds.gun.hot.HoTGun;
import ds.gun.linear.LinearGun;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Rules;

public class GunManager
implements IGunManager,
Hud.Painter,
IEventListener.BattleEnded {
    private AbstractGun m_lastSelectedGun;
    private ArrayList<AbstractGun> m_guns;
    private AdvancedRobot m_owner;
    private ITargetManager m_targetManager;
    private GunStats m_gunStats;
    AbstractGun m_selectedGun = null;
    private double m_firePower;
    private IDataSaver m_dataSaverGun;
    private HoTGun m_hotGUn;
    int n;
    double medPower;

    public GunManager(AdvancedRobot owner, ITargetManager targetManager) {
        this.m_owner = owner;
        this.m_targetManager = targetManager;
        this.m_guns = new ArrayList();
        this.m_hotGUn = new HoTGun(owner, targetManager);
        if (ConstantManager.getInstance().getBooleanConstant("gun.hot.active")) {
            this.m_guns.add(this.m_hotGUn);
        }
        if (ConstantManager.getInstance().getBooleanConstant("gun.dsgfFast.active")) {
            this.m_guns.add(new DSGFGun("Fast", owner, targetManager, false));
        }
        if (ConstantManager.getInstance().getBooleanConstant("gun.dsgfSlow.active")) {
            this.m_guns.add(new DSGFGun("Slow", owner, targetManager, true));
        }
        if (ConstantManager.getInstance().getBooleanConstant("gun.dsgfAWS.active")) {
            this.m_guns.add(new DSGFGun("AWS", owner, targetManager, false));
        }
        if (ConstantManager.getInstance().getBooleanConstant("gun.linear.active")) {
            this.m_guns.add(new LinearGun(owner, targetManager));
        }
        this.m_gunStats = new GunStats((IVirtualBot)owner, targetManager, this.m_guns);
        this.m_lastSelectedGun = null;
        this.m_firePower = 0.0;
    }

    @Override
    public void Act() {
        this.m_owner.setAdjustGunForRobotTurn(true);
        boolean bShootingRound = this.readyToShoot();
        if (bShootingRound) {
            this.m_owner.setFire(this.m_firePower);
            if (this.n > 0) {
                this.medPower *= (double)this.n;
            }
            this.medPower += this.m_firePower;
            ++this.n;
            this.medPower /= (double)this.n;
            System.out.println("median power = " + this.medPower);
        }
        if (this.m_guns.size() <= 0) {
            return;
        }
        for (AbstractGun gun : this.m_guns) {
            gun.Act(this.m_firePower);
        }
        this.m_gunStats.update();
        this.m_selectedGun = this.m_gunStats.getBestGun();
        if (this.m_selectedGun != this.m_lastSelectedGun) {
            this.m_lastSelectedGun = this.m_selectedGun;
            if (ConstantManager.getInstance().getBooleanConstant("debug")) {
                System.out.println("Using " + this.m_lastSelectedGun.getName());
            }
        }
        try {
            if (this.m_targetManager.getCurrentTarget().getEnergy() <= 0.0) {
                this.m_selectedGun = this.m_hotGUn;
            }
        }
        catch (TargetException gun) {
            // empty catch block
        }
        this.m_firePower = this.computeFirePower();
        FireSolution fs = this.m_selectedGun.getFireSolution(this.m_firePower);
        double angle = fs.getAngle() + Math.random() * Math.PI / 512.0 - 0.01227184630308513;
        this.m_owner.setTurnGunRightRadians(angle);
        try {
            if (this.readyToShootNextTurn() && this.m_targetManager.getCurrentTarget().getEnergy() > 0.0) {
                for (AbstractGun gun : this.m_guns) {
                    this.m_gunStats.virtualFire(gun, this.m_firePower);
                    gun.virtualFire(this.m_firePower);
                }
            }
        }
        catch (TargetException targetException) {
            // empty catch block
        }
    }

    private boolean readyToShootNextTurn() {
        double gunHeat = this.m_owner.getGunHeat() - 0.1;
        return this.m_firePower > 0.0 && gunHeat <= 0.0 && this.m_owner.getEnergy() > this.m_firePower && this.m_owner.getEnergy() > 0.1 && this.m_targetManager.HasTarget() && Math.abs(this.m_owner.getGunTurnRemainingRadians()) <= Rules.GUN_TURN_RATE_RADIANS;
    }

    private boolean readyToShoot() {
        return this.m_firePower > 0.0 && this.m_owner.getGunHeat() <= 0.0 && this.m_owner.getEnergy() > this.m_firePower && this.m_owner.getEnergy() > 0.1 && this.m_targetManager.HasTarget() && Math.abs(this.m_owner.getGunTurnRemainingRadians()) == 0.0;
    }

    private double computeFirePower() {
        double power = Math.min(2.5, Math.max(this.m_owner.getEnergy() - 0.2, 0.0));
        try {
            double targetDistance = this.m_targetManager.getCurrentTarget().getDistance();
            targetDistance = Math.min(300.0 / targetDistance, 1.0);
            double factor = Math.min(this.m_owner.getEnergy(), 25.0) * 1.0 / 25.0;
            power = this.m_owner.getEnergy() > 0.1 ? targetDistance * factor * 3.0 : 0.0;
            power *= Math.min(this.m_gunStats.getScore(this.m_selectedGun) + 0.85, 1.0);
            power *= this.m_selectedGun.getConfidence();
            power = BulletPower.select(power);
            power = Math.min(power, 3.0);
            power = Math.min(power, (this.m_targetManager.getCurrentTarget().getEnergy() + 5.0) / 4.0);
        }
        catch (TargetException targetException) {
            // empty catch block
        }
        return power;
    }

    @Override
    public void paint(Hud hud, long tick) {
        this.m_gunStats.paint(hud, tick);
        if (this.m_selectedGun != null) {
            this.m_selectedGun.paint(hud, tick);
        }
    }

    @Override
    public void onBattleEnded(BattleEndedEvent event) {
        this.m_dataSaverGun.save();
    }
}

