/*
 * Decompiled with CFR 0.152.
 */
package dz;

import dz.Processor;

public class Gravity {
    private Point[] antipts;
    private int numpts;
    private int rounds;
    private double fieldwidth;
    private double fieldheight;
    private long time;

    public void acrossCentrePoint(double ox, double oy, long t) {
        double theta = Processor.findHeading(ox, oy, this.fieldwidth / (double)2, this.fieldheight / (double)2) * Math.PI / 180.0;
        double x = ox + 100.0 * Math.sin(theta);
        double y = oy + 100.0 * Math.cos(theta);
        this.antipts[this.numpts - 2] = new Point("SalviusCentre", x, y, -5.0, 2, 0.0, t + 6L);
    }

    public void reset() {
        ++this.rounds;
        int a = 4;
        while (a < this.numpts - 2) {
            this.antipts[a].reset();
            ++a;
        }
        a = this.numpts - 2;
        while (a < this.numpts) {
            this.antipts[a] = null;
            ++a;
        }
    }

    public int getRounds() {
        return this.rounds;
    }

    public int findPlayer(String n) {
        int a = 4;
        while (a < this.numpts) {
            if (this.antipts[a].showName().equals(n) | this.antipts[a].showName().equals("Salviusccvi")) break;
            ++a;
        }
        this.antipts[a].adjustName(n);
        return a;
    }

    public void died(int a) {
        this.antipts[a].died();
    }

    public void adjPos(int id, double nx, double ny, long t) {
        this.time = t;
        if (this.antipts[this.numpts - 2] != null) {
            this.antipts[this.numpts - 2].dropIfExpired(t);
        }
        this.antipts[id].adjustPos(nx, ny);
    }

    public void adjName(int id, String n) {
        this.antipts[id].adjustName(n);
    }

    public void adjInt(int id, double i) {
        this.antipts[id].adjustInt(i);
    }

    public double adjEnergy(int id, double e) {
        double olde = this.antipts[id].adjustEnergy(e);
        boolean bl = false;
        if (olde - e <= (double)3) {
            bl = true;
        }
        boolean bl2 = false;
        if (olde - e >= 0.1) {
            bl2 = true;
        }
        if (bl & bl2) {
            return olde - e;
        }
        return 0.0;
    }

    public void addDam(int id, double d) {
        this.antipts[id].addDamage(d);
    }

    public double showGravInt(double ownx, double owny) {
        double total = 0.0;
        this.antipts[0].adjustX(ownx);
        this.antipts[1].adjustY(owny);
        this.antipts[2].adjustX(ownx);
        this.antipts[3].adjustY(owny);
        boolean bl = false;
        if (ownx < 20.0) {
            bl = true;
        }
        boolean bl2 = false;
        if (owny < 20.0) {
            bl2 = true;
        }
        boolean bl3 = bl | bl2;
        boolean bl4 = false;
        if (ownx > this.antipts[1].showX() - 20.0) {
            bl4 = true;
        }
        boolean bl5 = bl3 | bl4;
        boolean bl6 = false;
        if (owny > this.antipts[0].showY() - 20.0) {
            bl6 = true;
        }
        if (bl5 | bl6) {
            total += 100000.0;
        }
        int a = 0;
        while (a < this.numpts) {
            if (this.antipts[a] != null) {
                Point point = this.antipts[a];
                boolean bl7 = false;
                if (a > 3) {
                    bl7 = true;
                }
                boolean bl8 = false;
                if (a < this.numpts - 2) {
                    bl8 = true;
                }
                total += point.gravInt(bl7 & bl8, ownx, owny);
            }
            ++a;
        }
        return total;
    }

    public Gravity(int numopponents, double w, double h) {
        this.numpts = numopponents + 6;
        this.fieldwidth = w;
        this.fieldheight = h;
        this.antipts = new Point[this.numpts];
        this.rounds = 1;
        int a = 0;
        while (a <= 3) {
            this.antipts[a] = new Point("SalviusWall" + String.valueOf(a), 0.0, 0.0, 10.0, 4, 0.0);
            ++a;
        }
        a = 4;
        while (a < this.numpts) {
            this.antipts[a] = new Point("Salviusccvi", 0.0, 0.0, 0.0, 2, 0.0);
            ++a;
        }
        this.antipts[0].adjustY(h);
        this.antipts[1].adjustX(w);
    }

    public class Point {
        private double x;
        private double y;
        private double intensity;
        private double pow;
        private double energy;
        private double damage;
        private String name;
        private long endtime;
        private boolean alive;

        public void reset() {
            this.alive = true;
            this.energy = 100.0;
            this.x = -10000.0;
            this.y = -10000.0;
        }

        public int aliveFactor() {
            if (this.alive) {
                return 1;
            }
            return 0;
        }

        public void dropIfExpired(long t) {
            if (t >= this.endtime) {
                this.intensity = 0.0;
            }
        }

        public void adjustName(String n) {
            this.name = n;
        }

        public void adjustPos(double nx, double ny) {
            this.x = nx;
            this.y = ny;
        }

        public void adjustX(double nx) {
            this.x = nx;
        }

        public void adjustY(double ny) {
            this.y = ny;
        }

        public void adjustInt(double i) {
            this.intensity = i;
        }

        public double adjustEnergy(double e) {
            double reenergy = this.energy;
            this.energy = e;
            return reenergy;
        }

        public void addDamage(double d) {
            this.damage = d > 1.0 ? (this.damage += d * (double)4 + (d - 1.0) * (double)2) : (this.damage += d * (double)4);
        }

        public String showName() {
            return this.name;
        }

        public double showX() {
            return this.x;
        }

        public double showY() {
            return this.y;
        }

        public double gravInt(boolean bot, double ownx, double owny) {
            double dist = Math.sqrt((ownx - this.x) * (ownx - this.x) + (owny - this.y) * (owny - this.y));
            if (dist < 20.0) {
                dist = 20.0;
            }
            if (bot) {
                this.intensity = Math.sqrt(this.energy) + Math.sqrt(this.damage) / (double)Gravity.this.getRounds();
            }
            return (double)this.aliveFactor() * this.intensity / Math.pow(dist / 40.0, this.pow);
        }

        public void died() {
            this.alive = false;
        }

        public Point(String n, double nx, double ny, double i, double p, double e) {
            this.name = n;
            this.x = nx;
            this.y = ny;
            this.pow = p;
            this.energy = e;
            this.intensity = i;
            this.damage = 0.0;
            this.alive = true;
            this.endtime = 9999999L;
        }

        public Point(String n, double nx, double ny, double i, double p, double e, long t) {
            this.name = n;
            this.x = nx;
            this.y = ny;
            this.pow = p;
            this.energy = e;
            this.intensity = i;
            this.damage = 0.0;
            this.alive = true;
            this.endtime = t;
        }
    }
}

