/*
 * Decompiled with CFR 0.152.
 */
package rampancy;

import java.awt.Color;
import java.awt.Graphics2D;
import rampancy.RampantRobot;
import rampancy.standard.RDefaultEnemyManager;
import rampancy.standard.RDefaultMovementManager;
import rampancy.standard.RDefaultStatisticsManager;
import rampancy.standard.RDefaultTargetingManager;
import rampancy.standard.RDefaultWaveManager;
import rampancy.util.RUtil;
import rampancy.util.weapon.RAGFGun;
import rampancy.util.weapon.RGun;
import robocode.BattleEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Durandal
extends RampantRobot {
    public static final double MAX_RADAR_TRACKING_AMOUNT = 0.7853981633974483;
    public static final RGun[] guns = new RGun[]{new RAGFGun()};

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
    }

    public void run() {
        super.run();
        this.initialSetup();
        this.updateState(null);
        targetingManager.updateNewRound();
        while (this.getRadarTurnRemainingRadians() == 0.0) {
            this.turnRadarRightRadians(0.7853981633974483);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.focusRadar(e);
        super.onScannedRobot(e);
    }

    public void onBattleEnded(BattleEndedEvent e) {
        if (targetingManager instanceof RDefaultTargetingManager) {
            System.out.println(((RDefaultTargetingManager)targetingManager).getGunStatistics());
        }
    }

    private void initialSetup() {
        this.setColors(Color.black, new Color(876048), new Color(876048), Color.white, Color.blue);
        if (enemyManager == null) {
            enemyManager = new RDefaultEnemyManager(this);
        }
        enemyManager.updateReference(this);
        enemyManager.resetAll();
        if (waveManager == null) {
            waveManager = new RDefaultWaveManager(this);
        }
        waveManager.updateReference(this);
        waveManager.clearWaves();
        if (movementManager == null) {
            movementManager = new RDefaultMovementManager(this);
        }
        movementManager.updateReference(this);
        if (targetingManager == null) {
            targetingManager = new RDefaultTargetingManager(guns);
        }
        if (statisticsManager == null) {
            statisticsManager = new RDefaultStatisticsManager();
        }
    }

    private void focusRadar(ScannedRobotEvent e) {
        double factor = 3.0;
        if (this.getOthers() > 1) {
            factor = 0.2;
        }
        double radarBearingOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - (e.getBearingRadians() + this.getHeadingRadians())));
        this.setTurnRadarLeftRadians(radarBearingOffset + (double)RUtil.nonZeroSign(radarBearingOffset) * (0.7853981633974483 / factor));
    }
}

