/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.guns;

import gre.svman4.guns.GunInformation;
import gre.svman4.useful.RobotState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import robocode.ScannedRobotEvent;

public abstract class Gun {
    protected RobotState _mineRobot;

    public Gun(RobotState mineRobot) {
        this._mineRobot = mineRobot;
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public abstract GunInformation getFiringInformation();

    public void onStatus() {
    }

    public void onScannedRobot(ScannedRobotEvent event) {
    }

    public void onPaint(Graphics2D paint) {
    }

    public void onRoundEnd() {
    }

    public abstract String getName();

    protected Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = value / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, 0.9f, 0.9f);
    }

    protected Stroke getStroke(double min, double d, double max) {
        double range = max - min;
        double val = d - min;
        return new BasicStroke((float)(val / range) * 5.0f);
    }

    public void onBattleEnd() {
    }
}

