/*
 * Decompiled with CFR 0.152.
 */
package jwirde;

import jwirde.Vect;

public class VectPol {
    final double angle;
    final double magnitude;

    public VectPol(double angle, double magnitude) {
        this.angle = angle;
        this.magnitude = magnitude;
    }

    public VectPol add(VectPol otherPol) {
        Vect me = this.asVect();
        Vect other = otherPol.asVect();
        Vect result = new Vect(me.deltax + other.deltax, me.deltay + other.deltay);
        return result.asVectPol();
    }

    public Vect asVect() {
        double x = Math.sin(this.angle) * this.magnitude;
        double y = Math.cos(this.angle) * this.magnitude;
        return new Vect(x, y);
    }

    public String toString() {
        return "[" + this.angle + ", " + this.magnitude + "]";
    }
}

