/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import java.util.Vector;
import krillr.mega.utils.KrillrUtil;
import krillr.mega.utils.Module;
import krillr.mega.utils.Point2d;
import krillr.mega.utils.UnitInfo;
import krillr.mega.utils.UnitTracker;
import krillr.mega.utils.Vector2d;
import krillr.mega.utils.VirtualBullet;

public abstract class Predictor
extends Module {
    public UnitTracker parentUnit;
    public Vector virtualBullets = new Vector();
    public int weight = 0;

    public void update() {
    }

    public double predictBearing() {
        return 0.0;
    }

    public VirtualBullet getVirtualBullet() {
        if (this.parentUnit.name == this.bot.getName()) {
            return this.getBulletFromEnemy(3.0);
        }
        return this.getBulletToEnemy(3.0);
    }

    public VirtualBullet getBulletToEnemy(double energy) {
        Point2d bulletLocation = this.bot.location();
        UnitInfo oldInfo = this.parentUnit.info();
        if (oldInfo == null) {
            return new VirtualBullet(new Point2d(0.0, 0.0), new Vector2d(0.0, 0.0), this.parentUnit);
        }
        Vector2d vector = new Vector2d(oldInfo.velocity(), this.predictBearing());
        Point2d location = this.parentUnit.info().location.applyVector(vector);
        Vector2d bulletVector = new Vector2d(bulletLocation.bearing(location));
        bulletVector.setMagnitude(KrillrUtil.getSpeedFromEnergy(energy));
        return new VirtualBullet(bulletLocation, bulletVector, this.parentUnit);
    }

    public VirtualBullet getBulletFromEnemy(double energy) {
        if (this.bot.currentTarget == null) {
            return new VirtualBullet(new Point2d(0.0, 0.0), new Vector2d(0.0, 0.0), this.parentUnit);
        }
        Point2d bulletLocation = this.bot.currentTarget.info().location;
        Vector2d vector = new Vector2d(this.bot.getVelocity(), this.bot.battleTracker.parentTracker.getPredictor().predictBearing());
        Point2d location = this.bot.location().applyVector(vector);
        Vector2d bulletVector = new Vector2d(bulletLocation.bearing(location));
        bulletVector.setMagnitude(KrillrUtil.getSpeedFromEnergy(energy));
        return new VirtualBullet(bulletLocation, bulletVector, this.bot.battleTracker.parentTracker);
    }

    public void fireVirtualBullet() {
        if (this.virtualBullets.size() < 500) {
            this.virtualBullets.add(this.getVirtualBullet());
        }
    }

    public void checkVirtualBullets() {
        Vector tempvector = new Vector(this.virtualBullets);
        for (int i = 0; i < tempvector.size(); ++i) {
            VirtualBullet bullet = (VirtualBullet)tempvector.get(i);
            bullet.progress();
            if (bullet.hasHit()) {
                ++this.weight;
                this.virtualBullets.remove(bullet);
                continue;
            }
            if (bullet.hasMissed()) {
                --this.weight;
                this.virtualBullets.remove(this.virtualBullets.indexOf(bullet));
                continue;
            }
            this.virtualBullets.set(this.virtualBullets.indexOf(bullet), bullet);
        }
    }

    public void handleVirtualBulletHit(VirtualBullet b) {
    }

    public void handleVirtualBulletMiss(VirtualBullet b) {
    }
}

