/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import krillr.mega.utils.Point2d;

public class Vector2d {
    public double xForce;
    public double yForce;

    public Vector2d(double magnitude, double rads) {
        this.xForce = magnitude * Math.sin(rads);
        this.yForce = magnitude * Math.cos(rads);
    }

    public Vector2d(double rads) {
        this.xForce = Math.sin(rads);
        this.yForce = Math.cos(rads);
    }

    public double angle() {
        return Math.atan2(this.xForce, this.yForce);
    }

    public double magnitude() {
        return Math.sqrt(Math.pow(this.xForce, 2.0) + Math.pow(this.yForce, 2.0));
    }

    public void setAngle(double rads) {
        this.xForce = this.magnitude() * Math.sin(rads);
        this.yForce = this.magnitude() * Math.cos(rads);
    }

    public void setMagnitude(double m) {
        double angle = this.angle();
        this.xForce = m * Math.sin(angle);
        this.yForce = m * Math.cos(angle);
    }

    public void multiply(double f) {
        this.xForce *= f;
        this.yForce *= f;
    }

    public Vector2d normalized() {
        return new Vector2d(this.xForce / this.magnitude(), this.yForce / this.magnitude());
    }

    public Point2d toPoint() {
        return new Point2d(this.xForce, this.yForce);
    }

    public Point2d toPoint(Point2d p) {
        p.x += this.xForce;
        p.y += this.yForce;
        return p;
    }
}

