/*
 * Decompiled with CFR 0.152.
 */
package tw;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import tw.OurWave;
import tw.TheirWave;

public class Exterminator
extends AdvancedRobot {
    public static double[] _surfStats = new double[41];
    public Point2D.Double _ourLocation;
    public Point2D.Double _theirLocation;
    public ArrayList<TheirWave> _theirWaves = new ArrayList();
    public ArrayList<Integer> _surfDirections = new ArrayList();
    public ArrayList<Double> _surfAbsoluteBearings = new ArrayList();
    public ArrayList<OurWave> _waves = new ArrayList();
    public static int[] _guessFactorStats = new int[31];
    public int _direction = 1;
    public double _theirEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 225.0;
    public double _ourBulletPower = 0.2;
    public long _lastScannedTime = 0L;
    public long _lastDecayTime = 0L;
    public long _timesFired = 0L;
    public long _lastConfusion = 0L;
    public boolean _fullPower = false;
    static StringBuffer history = new StringBuffer("00000000000000000000000000000");
    static final double APPROACHANGLE = -Math.toRadians(20.0);
    static final double NINTYDEG = 1.5707963267948966;
    static final double BULLETVEL = 12.5;
    static final int PATTERN_DEPTH = 30;

    public void paintMyself() {
        Color bodyColor = new Color(255, 255, 255);
        Color gunColor = new Color(255, 255, 255);
        Color radarColor = new Color(0, 0, 0);
        Color bulletColor = new Color(255, 255, 255);
        Color scanArcColor = new Color(0, 0, 0);
        this.setColors(bodyColor, gunColor, radarColor, bulletColor, scanArcColor);
    }

    public void makeMyAnatomyIndependent() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
    }

    public void searchTheOpponent() {
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void run() {
        this.paintMyself();
        this.makeMyAnatomyIndependent();
        this.searchTheOpponent();
        while (true) {
            this.scan();
            if (this.getTime() - this._lastScannedTime <= 3L) continue;
            this.searchTheOpponent();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        int index;
        this._ourLocation = new Point2D.Double(this.getX(), this.getY());
        double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double radarTurn = absoluteBearing - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(1.995 * Utils.normalRelativeAngle((double)radarTurn));
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsoluteBearings.add(0, new Double(absoluteBearing + Math.PI));
        double bulletPower = this._theirEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            TheirWave ew = new TheirWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = Exterminator.bulletVelocity(bulletPower);
            ew.distanceTraveled = Exterminator.bulletVelocity(bulletPower);
            ew.direction = this._surfDirections.get(2);
            ew.directAngle = this._surfAbsoluteBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._theirLocation.clone();
            this._theirWaves.add(ew);
        }
        this._theirEnergy = e.getEnergy();
        this._theirLocation = Exterminator.project(this._ourLocation, absoluteBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        double dist = e.getDistance();
        double absB = e.getBearingRadians() + this.getHeadingRadians();
        int matchLenght = 30;
        history.insert(0, (char)(Math.sin(e.getHeadingRadians() - absB) * e.getVelocity()));
        while ((index = history.toString().indexOf(history.substring(0, matchLenght--), 1)) < 0) {
        }
        matchLenght = index - (int)(dist / 12.5);
        do {
            absB += Math.asin((double)((byte)history.charAt(index--)) / dist);
        } while (index >= Math.max(0, matchLenght));
        if (this.getEnergy() > 80.0 && Math.abs(this._ourLocation.distance(this._theirLocation)) > 100.0) {
            double ex = this.getX() + Math.sin(absoluteBearing) * e.getDistance();
            double ey = this.getY() + Math.cos(absoluteBearing) * e.getDistance();
            for (OurWave currentWave : this._waves) {
                if (!currentWave.checkHit(ex, ey, this.getTime())) continue;
                this._waves.remove(currentWave);
                break;
            }
            if (e.getVelocity() != 0.0) {
                this._direction = Math.sin(e.getHeadingRadians() - absoluteBearing) * e.getVelocity() < 0.0 ? -1 : 1;
            }
            int[] currentStats = _guessFactorStats;
            int bestIndex = 15;
            int i = 0;
            while (i < 31) {
                if (currentStats[bestIndex] < currentStats[i]) {
                    bestIndex = i;
                }
                ++i;
            }
            if (this._timesFired - this._lastConfusion >= 6L) {
                this._fullPower = true;
                this._lastConfusion = this._timesFired;
            }
            OurWave newWave = new OurWave(this.getX(), this.getY(), absoluteBearing, this._fullPower ? 2.4 : this._ourBulletPower, this._direction, this.getTime(), currentStats);
            double guessFactor = (double)(bestIndex - (_guessFactorStats.length - 1) / 2) / (double)((_guessFactorStats.length - 1) / 2);
            double angleOffset = (double)this._direction * guessFactor * newWave.maxEscapeAngle();
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + angleOffset)));
            if (this.fireBullet(this._fullPower ? 2.4 : this._ourBulletPower) != null) {
                this._waves.add(newWave);
                ++this._timesFired;
            }
        } else {
            if (Math.abs(this._ourLocation.distance(this._theirLocation)) < 64.0) {
                this._fullPower = true;
            }
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absB - this.getGunHeadingRadians())));
            if (this.fireBullet(this._fullPower ? 2.4 : this._ourBulletPower) != null) {
                ++this._timesFired;
            }
        }
        if (this._fullPower) {
            this._fullPower = false;
        }
        if (this.getTime() - this._lastDecayTime == 30L) {
            Object[] objectArray = _guessFactorStats;
            int n = _guessFactorStats.length;
            int n2 = 0;
            while (n2 < n) {
                double guessFactorStat = objectArray[n2];
                guessFactorStat = guessFactorStat >= 9.0 ? (guessFactorStat -= 9.0) : 0.0;
                ++n2;
            }
            objectArray = _surfStats;
            n = _surfStats.length;
            n2 = 0;
            while (n2 < n) {
                int surfStat = objectArray[n2];
                surfStat = surfStat >= 0.00175 ? (surfStat -= 0.00175) : (int)0.0;
                ++n2;
            }
            this._lastDecayTime = this.getTime();
        }
        this._lastScannedTime = this.getTime();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this._theirEnergy += e.getPower() * 3.0;
        if (!this._theirWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            TheirWave hitWave = null;
            int x = 0;
            while (x < this._theirWaves.size()) {
                TheirWave ew = this._theirWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._ourLocation.distance(ew.fireLocation)) < 50.0 && Math.round(Exterminator.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._theirWaves.remove(this._theirWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onHitRobot(HitRobotEvent event) {
        this._theirEnergy -= 0.6;
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        if (event.getBearing() > -90.0 && event.getBearing() <= 90.0) {
            this.back(200.0);
        } else {
            this.ahead(200.0);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this._ourBulletPower = this._ourBulletPower <= 1.775 ? (this._ourBulletPower += 1.225) : 3.0;
        double power = e.getBullet().getPower();
        this._theirEnergy -= power * 4.0;
        if (power > 1.0) {
            this._theirEnergy -= (power - 1.0) * 2.0;
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this._ourBulletPower = this._ourBulletPower >= 1.125 ? (this._ourBulletPower -= 1.025) : 0.1;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double crashP = new Point2D.Double();
        crashP.x = e.getBullet().getX();
        crashP.y = e.getBullet().getY();
        Point2D.Double ourP = new Point2D.Double();
        ourP.x = this.getX();
        ourP.y = this.getY();
        double distanceToCrash = crashP.distance(ourP);
        int x = 0;
        while (x < this._theirWaves.size()) {
            TheirWave ew = this._theirWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            double distanceToWave = this._ourLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (Math.abs(distanceToWave - distanceToCrash) < 15.0) {
                this._theirWaves.remove(x);
                break;
            }
            ++x;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this._ourBulletPower = 0.2;
    }

    public Point2D.Double predictPosition(TheirWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._ourLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, Exterminator.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Exterminator.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Exterminator.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Exterminator.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(TheirWave surfWave, int direction) {
        int index = Exterminator.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void doSurfing() {
        TheirWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = Exterminator.absoluteBearing(surfWave.fireLocation, this._ourLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._ourLocation, goAngle - 1.5707963267948966 + 0.7643777745960567, -1) : this.wallSmoothing(this._ourLocation, goAngle + 1.5707963267948966 - 0.7643777745960567, 1);
        Exterminator.setBackAsFront(this, goAngle);
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._theirWaves.size()) {
            TheirWave ew = this._theirWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._ourLocation.distance(ew.fireLocation) + 48.0) {
                this._theirWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public TheirWave getClosestSurfableWave() {
        double closestDistance = Double.MAX_VALUE;
        TheirWave surfWave = null;
        int x = 0;
        while (x < this._theirWaves.size()) {
            TheirWave ew = this._theirWaves.get(x);
            double distance = this._ourLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(TheirWave ew, Point2D.Double targetLocation) {
        double offsetAngle = Exterminator.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / Exterminator.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)Exterminator.limit(0.0, factor * 20.0 + 20.0, 40.0);
    }

    public void logHit(TheirWave ew, Point2D.Double targetLocation) {
        int index = Exterminator.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < 41) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(Exterminator.project(botLocation, angle, WALL_STICK))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double bulletVelocity) {
        return Math.asin(8.0 / bulletVelocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }
}

