/*
 * Decompiled with CFR 0.152.
 */
package am;

import am.VirtualBullet;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.CustomEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

public abstract class MiedzixAdvancedRobot
extends AdvancedRobot {
    protected final int ROBOT_STRATEGY_AT_START = 1;
    protected final int GUN_STRATEGY_AT_START = 4;
    protected final double BLINK_COLORS = 1.0;
    protected final double BLINK_RATE = 4.0;
    protected final double BATTLEFIELD_WALL_MARGINS = 64.0;
    protected final double PI = Math.PI;
    protected double robotEnergy;
    protected double robotGunHeading;
    protected double robotGunHeadingRadians;
    protected double robotGunHeat;
    protected double robotHeading;
    protected double robotHeadingRadians;
    protected String robotName;
    protected double robotRadarHeading;
    protected double robotRadarHeadingRadians;
    protected double robotVelocity;
    protected double robotX;
    protected double robotY;
    protected double robotFirePower;
    protected double robotTurnDirection;
    protected double robotGunTurnDirection;
    protected double robotRadarTurnDirection;
    protected double robotTurnAngle;
    protected double robotTurnAngleRadians;
    protected double robotGunTurnAngle;
    protected double robotGunTurnAngleRadians;
    protected double robotRadarTurnAngle;
    protected double robotRadarTurnAngleRadians;
    protected double robotMoveDistance;
    protected double robotMoveDirection;
    protected double robotLastEnergy;
    protected double robotLastGunHeading;
    protected double robotLastGunHeadingRadians;
    protected double robotLastGunHeat;
    protected double robotLastHeading;
    protected double robotLastHeadingRadians;
    protected double robotLastRadarHeading;
    protected double robotLastRadarHeadingRadians;
    protected double robotLastVelocity;
    protected double robotLastX;
    protected double robotLastY;
    protected double robotLastFirePower;
    protected double robotLastTurnDirection;
    protected double robotLastGunTurnDirection;
    protected double robotLastRadarTurnDirection;
    protected double robotLastTurnAngle;
    protected double robotLastGunTurnAngle;
    protected double robotLastRadarTurnAngle;
    protected double robotLastMoveDistance;
    protected double robotLastMoveDirection;
    protected double enemyBearing;
    protected double enemyBearingRadians;
    protected double enemyDistance;
    protected double enemyEnergy;
    protected double enemyHeading;
    protected double enemyHeadingRadians;
    protected String enemyName;
    protected double enemyVelocity;
    protected double enemyX;
    protected double enemyY;
    protected double enemyAbsoluteBearing;
    protected double enemyAbsoluteBearingRadians;
    protected double enemyFirePower;
    protected double enemyGunHeat;
    protected double enemyTurnDirection;
    protected double enemyTurnAngle;
    protected double enemyTurnAngleRadians;
    protected double enemyLastBearing;
    protected double enemyLastBearingRadians;
    protected double enemyLastDistance;
    protected double enemyLastEnergy;
    protected double enemyLastHeading;
    protected double enemyLastHeadingRadians;
    protected double enemyLastVelocity;
    protected double enemyLastX;
    protected double enemyLastY;
    protected double enemyLastAbsoluteBearing;
    protected double enemyLastAbsoluteBearingRadians;
    protected double enemyLastFirePower;
    protected double enemyLastGunHeat;
    protected double enemyLastTurnDirection;
    protected double enemyLastTurnAngle;
    protected double enemyLastTurnAngleRadians;
    protected double battlefieldWidth;
    protected double battlefieldHeight;
    protected double gunCoolingRate;
    protected int numRounds;
    protected int others;
    protected int roundNum;
    protected double roundTime;
    protected boolean firstBattleWin = false;
    protected boolean enemyFound;
    protected boolean enemyHitted;
    protected boolean enemyHittedByBullet;
    protected boolean enemyHittedWall;
    protected Color currentColor;
    protected int robotStrategy = 1;
    protected int gunStrategy = 4;
    protected int lastGunStrategy = 4;
    protected double robotHitted;
    protected double robotMissed;
    protected double[] robotDeaths = new double[6];
    protected double[] robotWins = new double[6];
    protected double[] roundGunHitted = new double[6];
    protected Rectangle2D.Double robotRectangle;
    protected Rectangle2D.Double enemyRectangle;
    protected Rectangle2D.Double battleFieldRectangle;
    protected Line2D[] ls = new Line2D[10];
    protected ArrayList<VirtualBullet> vBullets = new ArrayList();

    protected void getRobotInfo() {
        this.robotLastEnergy = this.robotEnergy;
        this.robotLastGunHeading = this.robotGunHeading;
        this.robotLastGunHeadingRadians = this.robotGunHeadingRadians;
        this.robotLastGunHeat = this.robotGunHeat;
        this.robotLastHeading = this.robotHeading;
        this.robotLastHeadingRadians = this.robotHeadingRadians;
        this.robotLastRadarHeading = this.robotRadarHeading;
        this.robotLastRadarHeadingRadians = this.robotRadarHeadingRadians;
        this.robotLastVelocity = this.robotVelocity;
        this.robotLastX = this.robotX;
        this.robotLastY = this.robotY;
        this.robotLastFirePower = this.robotFirePower;
        this.robotLastTurnDirection = this.robotTurnDirection;
        this.robotLastGunTurnDirection = this.robotGunTurnDirection;
        this.robotLastRadarTurnDirection = this.robotRadarTurnDirection;
        this.robotLastTurnAngle = this.robotTurnAngle;
        this.robotLastGunTurnAngle = this.robotGunTurnAngle;
        this.robotLastRadarTurnAngle = this.robotRadarTurnAngle;
        this.robotLastMoveDistance = this.robotMoveDistance;
        this.robotLastMoveDirection = this.robotMoveDirection;
        this.robotEnergy = this.getEnergy();
        this.robotGunHeading = this.getGunHeading();
        this.robotGunHeadingRadians = this.getGunHeadingRadians();
        this.robotGunHeat = this.getGunHeat();
        this.robotHeading = this.getHeading();
        this.robotHeadingRadians = this.getHeadingRadians();
        this.robotRadarHeading = this.getRadarHeading();
        this.robotRadarHeadingRadians = this.getRadarHeadingRadians();
        this.robotVelocity = this.getVelocity();
        this.robotX = this.getX();
        this.robotY = this.getY();
        this.robotRectangle.setRect(this.robotX - 18.0, this.robotY - 18.0, 36.0, 36.0);
    }

    protected void getEnemyInfo(ScannedRobotEvent e) {
        this.enemyLastBearing = this.enemyBearing;
        this.enemyLastBearingRadians = this.enemyBearingRadians;
        this.enemyLastDistance = this.enemyDistance;
        this.enemyLastEnergy = this.enemyEnergy;
        this.enemyLastGunHeat = this.enemyGunHeat;
        this.enemyLastHeading = this.enemyHeading;
        this.enemyLastHeadingRadians = this.enemyHeadingRadians;
        this.enemyLastVelocity = this.enemyVelocity;
        this.enemyLastX = this.enemyX;
        this.enemyLastY = this.enemyY;
        this.enemyLastAbsoluteBearing = this.enemyAbsoluteBearing;
        this.enemyLastAbsoluteBearingRadians = this.enemyAbsoluteBearingRadians;
        this.enemyLastFirePower = this.enemyFirePower;
        this.enemyLastTurnDirection = this.enemyTurnDirection;
        this.enemyLastTurnAngle = this.enemyTurnAngle;
        this.enemyLastTurnAngleRadians = this.enemyTurnAngleRadians;
        this.enemyBearing = e.getBearing();
        this.enemyBearingRadians = e.getBearingRadians();
        this.enemyDistance = e.getDistance();
        this.enemyEnergy = e.getEnergy();
        this.enemyHeading = e.getHeading();
        this.enemyHeadingRadians = e.getHeadingRadians();
        this.enemyName = e.getName();
        this.enemyVelocity = e.getVelocity();
        this.enemyAbsoluteBearing = this.robotHeading + this.enemyBearing;
        this.enemyAbsoluteBearingRadians = this.robotHeadingRadians + this.enemyBearingRadians;
        this.enemyX = this.robotX + this.enemyDistance * Math.sin(this.enemyAbsoluteBearingRadians);
        this.enemyY = this.robotY + this.enemyDistance * Math.cos(this.enemyAbsoluteBearingRadians);
        if (!(this.enemyHitted && this.enemyHittedByBullet && this.enemyHittedWall || !(this.enemyLastEnergy - this.enemyEnergy >= 0.0))) {
            this.enemyFirePower = this.enemyLastEnergy - this.enemyEnergy;
        }
        if (this.enemyGunHeat == 0.0) {
            if (this.enemyFirePower > 0.001) {
                this.enemyGunHeat = 1.0 + this.enemyFirePower / 5.0;
            }
        } else {
            this.enemyGunHeat -= this.gunCoolingRate;
            if (this.enemyGunHeat < 0.001) {
                this.enemyGunHeat = 0.0;
            }
            if (this.enemyFirePower >= 0.0) {
                this.enemyGunHeat = 1.0 + this.enemyFirePower / 5.0;
            }
        }
        this.enemyHitted = false;
        this.enemyTurnDirection = Utils.normalRelativeAngle((double)(this.enemyHeading - this.enemyLastHeading)) >= 0.0 ? 1 : -1;
        this.enemyTurnAngle = this.enemyHeading - this.enemyLastHeading;
        this.enemyTurnAngleRadians = Utils.normalRelativeAngle((double)(this.enemyHeadingRadians - this.enemyLastHeadingRadians));
        this.enemyRectangle.setRect(this.enemyX - 18.0, this.enemyY - 18.0, 36.0, 36.0);
    }

    protected void getUsefullInfo() {
        this.roundTime = this.getTime();
    }

    public void onCustomEvent(CustomEvent event) {
        System.out.println("CustomEvent");
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        System.out.println("SkippedTurnEvent");
    }

    public void onStatus(StatusEvent event) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        System.out.println("BulletHitBulletEvent");
    }

    protected void initialization() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.getStartingInfo();
        this.initializeVariables();
        this.startingStrategy();
    }

    protected void getStartingInfo() {
        this.battlefieldWidth = this.getBattleFieldWidth();
        this.battlefieldHeight = this.getBattleFieldHeight();
        this.gunCoolingRate = this.getGunCoolingRate();
        this.numRounds = this.getNumRounds();
        this.others = this.getOthers();
        this.roundNum = this.getRoundNum();
        this.roundTime = this.getTime();
        this.robotName = this.getName();
    }

    protected void initializeVariables() {
        this.robotMoveDirection = 1.0;
        this.robotMoveDistance = 0.0;
        this.robotTurnDirection = 1.0;
        this.robotHitted = 0.0;
        this.robotMissed = 0.0;
        this.enemyGunHeat = 0.0;
        this.gunStrategy = this.lastGunStrategy;
        int i = 0;
        while (i < 6) {
            this.roundGunHitted[i] = 0.0;
            ++i;
        }
        this.robotRectangle = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        this.enemyRectangle = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        this.battleFieldRectangle = new Rectangle2D.Double(0.0, 0.0, this.battlefieldWidth - 1.0, this.battlefieldHeight - 1.0);
        this.ls[0] = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.ls[1] = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.ls[2] = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.ls[3] = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.ls[4] = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    protected void startingStrategy() {
        this.getRobotInfo();
        this.enemyFound = false;
        this.robotGunTurnDirection = this.robotRadarTurnDirection = (double)(Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(this.battlefieldWidth / 2.0 - this.robotX, this.battlefieldHeight / 2.0 - this.robotY)) - this.robotRadarHeadingRadians)) >= 0.0 ? 1 : -1);
        this.robotRadarTurnDirection = this.robotRadarTurnDirection;
        while (!this.enemyFound) {
            this.setTurnRight(this.robotTurnDirection * 10.0);
            this.setTurnGunRight(this.robotGunTurnDirection * 20.0);
            this.setTurnRadarRight(this.robotRadarTurnDirection * 45.0);
            this.execute();
        }
    }

    protected void searchStrategy() {
    }

    protected void blinkingColors() {
        if (this.roundTime % 4.0 == 0.0) {
            if (this.roundTime % 3.0 == 0.0) {
                this.currentColor = Color.red;
            }
            if (this.roundTime % 3.0 == 1.0) {
                this.currentColor = Color.green;
            }
            if (this.roundTime % 3.0 == 2.0) {
                this.currentColor = Color.blue;
            }
            this.setBodyColor(this.currentColor);
            this.setGunColor(this.currentColor);
            this.setRadarColor(this.currentColor);
            this.setBulletColor(this.currentColor);
            this.setScanColor(this.currentColor);
        }
    }

    protected void radar() {
        this.robotRadarTurnAngleRadians = Utils.normalRelativeAngle((double)(this.enemyAbsoluteBearingRadians - this.robotRadarHeadingRadians));
        double arcToScan = Math.max(Math.min(Math.atan(36.0 / this.enemyDistance), 0.7853981633974483), 0.39269908169872414);
        this.robotRadarTurnAngleRadians += this.robotRadarTurnAngleRadians < 0.0 ? -arcToScan : arcToScan;
        this.setTurnRadarRightRadians(this.robotRadarTurnAngleRadians);
    }

    protected void chooseStrategy() {
        if (this.roundNum == 1 || this.firstBattleWin) {
            this.robotStrategy = 1;
            if (this.robotEnergy - this.enemyEnergy < 0.0) {
                this.robotStrategy = 2;
            }
        } else {
            this.robotStrategy = 2;
            if (this.robotEnergy - this.enemyEnergy > 20.0) {
                this.robotStrategy = 1;
            }
            if (this.robotEnergy - this.enemyEnergy < -20.0) {
                this.robotStrategy = 1;
            }
        }
        if (this.robotStrategy == 0) {
            ++this.robotStrategy;
        }
        if (this.robotStrategy > 2) {
            this.robotStrategy = 2;
        }
    }

    protected void robot() {
        this.chooseStrategy();
        switch (this.robotStrategy) {
            case 1: {
                this.robotRamBot1();
                break;
            }
            case 2: {
                this.robotCircleRandomBot1();
            }
        }
    }

    protected void robotRamBot1() {
        this.robotTurnAngle = this.enemyBearing;
        double currentVelocity = (10.0 - Math.abs(this.robotTurnAngle)) * 4.0 / 3.0;
        if (currentVelocity >= 8.0) {
            this.setMaxVelocity(8.0);
        } else if (currentVelocity <= 0.0) {
            this.setMaxVelocity(0.0);
        } else {
            this.setMaxVelocity(currentVelocity);
        }
        this.setAhead(99.0);
        this.setTurnRight(this.robotTurnAngle);
    }

    protected void robotCircleRandomBot1() {
        double d;
        this.robotMoveDistance = this.getDistanceRemaining();
        if (d <= 20.0) {
            this.robotTurnAngle = this.enemyBearing + 90.0;
            this.robotMoveDistance = Math.sin(this.getTime() / 11L) * Math.cos(this.getTime() / 29L) * 260.0 + (Math.random() * 100.0 - 50.0);
            this.setAhead(this.robotMoveDistance);
            this.setTurnRight(this.robotTurnAngle);
        }
        this.setMaxVelocity(8.0);
        if (this.robotX < 64.0 || this.battlefieldWidth - this.robotX < 64.0 || this.robotY < 64.0 || this.battlefieldHeight - this.robotY < 64.0) {
            this.robotTurnAngleRadians = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(this.battlefieldHeight / 2.0 - this.robotX, this.battlefieldHeight / 2.0 - this.robotY)) - this.robotHeadingRadians));
            this.setAhead(32.0);
            this.setTurnRightRadians(this.robotTurnAngleRadians);
            this.setMaxVelocity(5.0);
        }
    }

    protected void chooseGunStrategy() {
        double max = 0.0;
        int i = 1;
        while (i < 4) {
            if (this.roundGunHitted[i] > max) {
                max = this.roundGunHitted[i];
                this.gunStrategy = i;
            }
            ++i;
        }
        if (this.gunStrategy == 0) {
            ++this.gunStrategy;
        }
        if (this.gunStrategy > 3) {
            this.gunStrategy = 3;
        }
        this.robotFirePower = 0.2;
        if (this.enemyDistance < 600.0) {
            this.robotFirePower = 1.2;
        }
        if (this.enemyDistance < 300.0) {
            this.robotFirePower = 3.0;
        }
        if (this.robotEnergy <= this.robotFirePower) {
            this.robotFirePower = this.robotEnergy - 0.1;
        }
        switch (this.gunStrategy) {
            case 1: {
                this.gunStraight();
                break;
            }
            case 2: {
                this.gunLinear();
                break;
            }
            case 3: {
                this.gunCircle();
            }
        }
        this.setTurnGunRightRadians(this.robotGunTurnAngleRadians);
    }

    protected void gunStraight() {
        this.robotFirePower = 3.0;
        this.robotGunTurnAngleRadians = Utils.normalRelativeAngle((double)(this.enemyAbsoluteBearingRadians - this.robotGunHeadingRadians));
        this.ls[1].setLine(this.robotX, this.robotY, this.enemyX, this.enemyY);
    }

    protected void gunLinear() {
        double deltaTime = 0.0;
        Point2D.Double p = new Point2D.Double(this.enemyX, this.enemyY);
        while ((deltaTime += 1.0) * (20.0 - 3.0 * this.robotFirePower) < Point2D.Double.distance(this.robotX, this.robotY, p.x, p.y)) {
            p.x += Math.sin(this.enemyHeadingRadians) * this.enemyVelocity;
            p.y += Math.cos(this.enemyHeadingRadians) * this.enemyVelocity;
            if (!(p.x <= 18.0 || p.y <= 18.0 || p.x >= this.battlefieldWidth - 18.0) && !(p.y >= this.battlefieldHeight - 18.0)) continue;
            p.x = Math.min(Math.max(18.0, p.x), this.battlefieldWidth - 18.0);
            p.y = Math.min(Math.max(18.0, p.y), this.battlefieldHeight - 18.0);
            break;
        }
        this.robotGunTurnAngleRadians = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(p.x - this.robotX, p.y - this.robotY)) - this.robotGunHeadingRadians));
        this.ls[2].setLine(this.robotX, this.robotY, p.x, p.y);
    }

    /*
     * Unable to fully structure code
     */
    protected void gunCircle() {
        block2: {
            deltaTime = 0.0;
            p = new Point2D.Double(this.enemyX, this.enemyY);
            if (!(Math.abs(this.enemyTurnAngleRadians) > 0.001)) ** GOTO lbl21
            radius = this.enemyVelocity / this.enemyTurnAngleRadians;
            while (Math.abs(Math.sqrt((p.x - this.robotX) * (p.x - this.robotX) + (p.y - this.robotY) * (p.y - this.robotY)) / (20.0 - 3.0 * this.robotFirePower) - deltaTime) > 0.1) {
                deltaTime = Math.sqrt((p.x - this.robotX) * (p.x - this.robotX) + (p.y - this.robotY) * (p.y - this.robotY)) / (20.0 - 3.0 * this.robotFirePower);
                p.setLocation(this.enemyX + Math.cos(this.enemyHeadingRadians) * radius - Math.cos(this.enemyHeadingRadians + deltaTime * this.enemyTurnAngleRadians) * radius, this.enemyY + Math.sin(this.enemyHeadingRadians + deltaTime * this.enemyTurnAngleRadians) * radius - Math.sin(this.enemyHeadingRadians) * radius);
                if (!(p.x <= 18.0 || p.y <= 18.0 || p.x >= this.battlefieldWidth - 18.0) && !(p.y >= this.battlefieldHeight - 18.0)) continue;
                p.x = Math.min(Math.max(18.0, p.x), this.battlefieldWidth - 18.0);
                p.y = Math.min(Math.max(18.0, p.y), this.battlefieldHeight - 18.0);
                System.out.println("hmmm " + deltaTime);
                break block2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                p.x += Math.sin(this.enemyHeadingRadians) * this.enemyVelocity;
                p.y += Math.cos(this.enemyHeadingRadians) * this.enemyVelocity;
                if (!(p.x <= 18.0 || p.y <= 18.0 || p.x >= this.battlefieldWidth - 18.0) && !(p.y >= this.battlefieldHeight - 18.0)) continue;
                p.x = Math.min(Math.max(18.0, p.x), this.battlefieldWidth - 18.0);
                p.y = Math.min(Math.max(18.0, p.y), this.battlefieldHeight - 18.0);
                System.out.println("hmmm " + deltaTime);
                break;
lbl21:
                // 2 sources

                ** while ((deltaTime += 1.0) * (20.0 - 3.0 * this.robotFirePower) < Point2D.Double.distance((double)this.robotX, (double)this.robotY, (double)p.x, (double)p.y))
            }
        }
        this.robotGunTurnAngleRadians = Utils.normalRelativeAngle((double)(1.5707963267948966 - Math.atan2(p.y - this.robotY, p.x - this.robotX) - this.robotGunHeadingRadians));
        this.ls[3].setLine(this.robotX, this.robotY, p.x, p.y);
    }
}

