/*
 * Decompiled with CFR 0.152.
 */
package jab.radar;

import jab.module.Module;
import jab.module.Radar;
import jab.radar.RadarAssignation;
import java.io.IOException;
import robocode.Event;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class SuperWideLock
extends Radar {
    public String[] radarAssignations;
    private int timeSinceLastScan = 10;
    private double enemyAbsoluteBearing;

    public SuperWideLock(Module bot) {
        super(bot);
    }

    public void scan() {
        if (this.radarAssignations == null) {
            this.radarAssignations = new String[this.bot.getTeammates().length];
        }
        ++this.timeSinceLastScan;
        double radarOffset = Double.NEGATIVE_INFINITY;
        if (this.timeSinceLastScan < 3) {
            radarOffset = Utils.normalRelativeAngle((double)(this.bot.getRadarHeadingRadians() - this.enemyAbsoluteBearing));
            radarOffset += Math.signum(radarOffset) * 0.2;
        }
        this.bot.setTurnRadarLeftRadians(radarOffset);
    }

    public void listen(Event e) {
        String deathName;
        if (e instanceof MessageEvent) {
            MessageEvent message = (MessageEvent)e;
            if (message.getMessage() instanceof RadarAssignation) {
                RadarAssignation assign = (RadarAssignation)message.getMessage();
                this.radarAssignations[this.getMateNum((String)message.getSender())] = assign.focusOnEnemy;
            }
        } else if (e instanceof ScannedRobotEvent) {
            String scannedName = ((ScannedRobotEvent)e).getName();
            if (!this.bot.isTeammate(scannedName) && !this.isAssigned(scannedName)) {
                RadarAssignation radarAssignation = new RadarAssignation();
                radarAssignation.focusOnEnemy = scannedName;
                try {
                    this.bot.broadcastMessage(radarAssignation);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.enemyAbsoluteBearing = this.bot.getHeadingRadians() + ((ScannedRobotEvent)e).getBearingRadians();
                this.timeSinceLastScan = 0;
            }
        } else if (e instanceof RobotDeathEvent && this.bot.isTeammate(deathName = ((RobotDeathEvent)e).getName())) {
            this.radarAssignations[this.getMateNum((String)deathName)] = null;
        }
    }

    boolean isAssigned(String enemyName) {
        int x = 0;
        while (x < this.radarAssignations.length) {
            if (this.radarAssignations[x] != null && this.radarAssignations[x].equals(enemyName)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    int getMateNum(String name) {
        String[] mates = this.bot.getTeammates();
        int x = 0;
        while (x < mates.length) {
            if (mates[x].equals(name)) {
                return x;
            }
            ++x;
        }
        return 0;
    }

    void printAssignations() {
        System.out.println("_________");
        int x = 0;
        while (x < this.radarAssignations.length) {
            System.out.print(String.valueOf(this.radarAssignations[x]) + " , ");
            ++x;
        }
        System.out.println("");
        System.out.println("_________");
    }
}

