/*
 * Decompiled with CFR 0.152.
 */
package velas;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Beta_2_0
extends AdvancedRobot {
    double prevEnergy = 100.0;
    int direction = 1;
    int lock = -1;
    long lastscan = 0L;

    public void run() {
        this.setColors(Color.black, Color.blue, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        int count = 0;
        while (true) {
            ++count;
            if (this.lastscan < this.getTime() - 2L) {
                this.lock = -this.lock;
                System.out.println("lock lost");
            }
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(6.0);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double bulletPower = 2.0;
        if (this.getTurnRemaining() == 0.0) {
            this.setTurnRight(e.getBearing() + this.getHeading());
        }
        if (this.getGunTurnRemaining() == 0.0) {
            double gunmove = this.getHeadingRadians() + e.getBearingRadians() - this.getGunHeadingRadians();
            if (Utils.normalRelativeAngle((double)gunmove) > 0.05) {
                System.out.println("Moving Gun: " + Utils.normalRelativeAngle((double)gunmove));
            } else {
                bulletPower = 3.0;
            }
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getGunHeadingRadians())));
        }
        if (this.getGunTurnRemaining() < 15.0) {
            bulletPower = 3.0;
        } else if (this.getGunTurnRemaining() < 20.0) {
            bulletPower = 2.0;
        }
        double headOnBearing = this.getHeadingRadians() + e.getBearingRadians();
        double linearBearing = headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed((double)bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(linearBearing - this.getGunHeadingRadians())));
        this.fire(bulletPower);
        if (this.lock == -1) {
            this.lock = -this.lock;
            System.out.println("lock gained");
        }
        this.lastscan = this.getTime();
        double multiplier = 0.5;
        if (Math.random() < 0.035) {
            this.direction = -this.direction;
        }
        multiplier = Math.random();
        if (this.prevEnergy - e.getEnergy() > 0.0 && this.prevEnergy - e.getEnergy() <= 3.0) {
            System.out.println("enemy fired: moving.. " + (double)(120 * this.direction) * multiplier + this.direction * 40);
            this.setAhead((double)(120 * this.direction) * multiplier + (double)(this.direction * 40));
        }
        this.prevEnergy = e.getEnergy();
        double radarTurn = this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)radarTurn));
    }

    public void onHitByBullet(HitByBulletEvent e) {
        System.out.println("ouch!");
    }

    public void onHitWall(HitWallEvent e) {
        this.setBack(30.0);
        this.direction = -this.direction;
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.BLUE);
        g.drawLine((int)this.getX(), (int)this.getY(), (int)(this.getX() + 150.0 * Math.sin(this.getRadarHeadingRadians())), (int)(this.getY() + 150.0 * Math.cos(this.getRadarHeadingRadians())));
    }
}

