/*
 * Decompiled with CFR 0.152.
 */
package simonton.core;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import simonton.core.Bot;
import simonton.core.BulletWrapper;
import simonton.core.EnemySynchronizer;
import simonton.core.SelfSynchronizer;
import simonton.core.Synchronizer;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;

public class SlaveBot
implements Bot {
    public Location myLoc;
    public Location hisLoc;
    public double firePower;
    public boolean fire;
    public double lastEnergy;
    private String name;
    private BulletWrapper bulletWrapper;
    private double gunTurnRemainingRadians;
    private double turnRemainingRadians;
    private double distanceRemaining;
    private double gunHeadingRadians;
    private double headingRadians;
    private double maxVelocity = 8.0;
    private double velocity;
    private double gunHeat;
    private double energy;
    private double x;
    private double y;
    private long time;
    private Collection customEvents = new HashSet();
    private double lastCalc = 0.0;
    private double sinLastCalc = 0.0;
    private double cosLastCalc = 1.0;
    private Collection synchronizers = new ArrayList(2);

    public void keepSynchronized(boolean asEnemy, SlaveBot bot) {
        Synchronizer synchronizer = asEnemy ? new EnemySynchronizer(this, bot) : new SelfSynchronizer(this, bot);
        this.synchronizers.add(synchronizer);
    }

    public void tick() {
        this.setTime(this.getTime() + 1L);
        double speed = this.getVelocity();
        double turnRemaining = this.getTurnRemainingRadians();
        double maxTurn = Util.getTurnRateRadians(speed);
        double turn = FastMath.bound(turnRemaining, -maxTurn, maxTurn);
        this.setTurnRemainingRadians(turnRemaining - turn);
        double heading = this.getHeadingRadians();
        this.setHeadingRadians(heading += turn);
        double distance = this.getDistanceRemaining();
        speed = distance >= 0.0 ? this.getNextSpeed(speed, distance) : -this.getNextSpeed(-speed, -distance);
        this.setVelocity(speed);
        if (speed != 0.0) {
            if (heading != this.lastCalc) {
                this.lastCalc = heading;
                this.sinLastCalc = FastMath.sin(heading);
                this.cosLastCalc = FastMath.cos(heading);
            }
            this.setX(this.getX() + speed * this.sinLastCalc);
            this.setY(this.getY() + speed * this.cosLastCalc);
            this.setDistanceRemaining(distance - speed);
        }
    }

    @Override
    public void run() {
        this.hisLoc = null;
        this.lastEnergy = 100.0;
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.run();
        }
    }

    public void runIteration() {
        this.myLoc = new Location(this);
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.runIteration();
        }
        this.lastEnergy = this.getEnergy();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.hisLoc = new Location(this, e);
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onScannedRobot(e);
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onBulletHit(e);
        }
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onBulletMissed(e);
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onHitByBullet(e);
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onHitRobot(e);
        }
    }

    @Override
    public void onHitWall(HitWallEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onHitWall(e);
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onBulletHitBullet(e);
        }
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onSkippedTurn(e);
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onRobodDeath(e);
        }
    }

    @Override
    public void onDeath(DeathEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onDeath(e);
        }
    }

    @Override
    public void onWin(WinEvent e) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onWin(e);
        }
    }

    @Override
    public void onCustomEvent(CustomEvent customevent) {
    }

    @Override
    public void onPaint(Graphics2D g) {
        for (Synchronizer synchronizer : this.synchronizers) {
            synchronizer.onPaint(g);
        }
    }

    @Override
    public double getGunCoolingRate() {
        return Util.gunCoolingRate;
    }

    @Override
    public void setTurnRightRadians(double toTurn) {
        this.turnRemainingRadians = toTurn;
    }

    @Override
    public void setTurnRight(double toTurn) {
        this.turnRemainingRadians = Math.toRadians(toTurn);
    }

    @Override
    public void setTurnGunRightRadians(double toTurn) {
        this.gunTurnRemainingRadians = toTurn;
    }

    @Override
    public void setAhead(double toMove) {
        this.distanceRemaining = toMove;
    }

    @Override
    public void setBack(double toMove) {
        this.distanceRemaining = -toMove;
    }

    @Override
    public double getDistanceRemaining() {
        return this.distanceRemaining;
    }

    public void setDistanceRemaining(double distanceRemaining) {
        this.distanceRemaining = distanceRemaining;
    }

    @Override
    public double getHeadingRadians() {
        return this.headingRadians;
    }

    @Override
    public double getHeading() {
        return Math.toDegrees(this.headingRadians);
    }

    public void setHeadingRadians(double headingRadians) {
        this.headingRadians = headingRadians;
    }

    @Override
    public double getTurnRemainingRadians() {
        return this.turnRemainingRadians;
    }

    public void setTurnRemainingRadians(double turnRemainingRadians) {
        this.turnRemainingRadians = turnRemainingRadians;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    @Override
    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = FastMath.bound(maxVelocity, 0.0, 8.0);
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    @Override
    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public double getGunHeadingRadians() {
        return this.gunHeadingRadians;
    }

    @Override
    public double getGunHeading() {
        return FastMath.toDegrees(this.gunHeadingRadians);
    }

    public void setGunHeadingRadians(double gunHeadingRadians) {
        this.gunHeadingRadians = gunHeadingRadians;
    }

    @Override
    public double getGunTurnRemainingRadians() {
        return this.gunTurnRemainingRadians;
    }

    public void setGunTurnRemainingRadians(double gunTurnRemainingRadians) {
        this.gunTurnRemainingRadians = gunTurnRemainingRadians;
    }

    @Override
    public double getGunHeat() {
        return this.gunHeat;
    }

    public void setGunHeat(double gunHeat) {
        this.gunHeat = gunHeat;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    @Override
    public int getNumRounds() {
        return Util.numRounds;
    }

    @Override
    public int getRoundNum() {
        return Util.roundNum;
    }

    @Override
    public Bullet setFireBullet(double power) {
        throw new AssertionError((Object)"Slave bots should only call setFireBulletWrapper.");
    }

    public BulletWrapper setFireBulletWrapper(double power) {
        if (this.getGunHeat() > 0.0 || this.getEnergy() <= 0.0) {
            return null;
        }
        this.bulletWrapper = new BulletWrapper(this, power);
        return this.bulletWrapper;
    }

    public BulletWrapper pollBulletWrapper() {
        BulletWrapper wrapper = this.bulletWrapper;
        this.bulletWrapper = null;
        return wrapper;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void printStats() {
    }

    @Override
    public void addCustomEvent(Condition condition) {
        this.customEvents.add(condition);
    }

    @Override
    public void removeCustomEvent(Condition condition) {
        this.customEvents.remove(condition);
    }

    public void doCustomEvents() {
        Condition[] iterable;
        Condition[] acondition = iterable = this.customEvents.toArray(new Condition[this.customEvents.size()]);
        int j = iterable.length;
        int i = 0;
        while (i < j) {
            Condition condition = acondition[i];
            if (condition.test()) {
                this.onCustomEvent(new CustomEvent(condition));
            }
            ++i;
        }
    }

    private double getNextSpeed(double speed, double distance) {
        double nextSpeed;
        if (speed < 0.0) {
            nextSpeed = speed + 2.0;
            if (nextSpeed > distance) {
                nextSpeed = distance;
            }
        } else if (distance <= 2.0 && speed <= 2.0 && speed + 1.0 >= distance) {
            nextSpeed = distance;
        } else if (distance >= 20.0) {
            nextSpeed = Math.min(speed + 1.0, 8.0);
        } else {
            double slowdownVelocity = (int)(Math.sqrt(4.0 * distance + 1.0) - 1.0);
            nextSpeed = Math.min(speed + 1.0, 8.0);
            if (nextSpeed > slowdownVelocity && (nextSpeed = speed - 2.0) < slowdownVelocity) {
                nextSpeed = slowdownVelocity;
            }
        }
        if (nextSpeed > this.getMaxVelocity()) {
            nextSpeed = Math.max(speed - 2.0, this.getMaxVelocity());
        }
        return nextSpeed;
    }
}

