/*
 * Decompiled with CFR 0.152.
 */
package simonton.utils;

import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.ScannedRobotEvent;
import simonton.core.Bot;
import simonton.utils.FastMath;
import simonton.utils.Util;

public class Location
extends Point2D.Double {
    public static Location random() {
        double x = FastMath.random(18.0, Util.worldWidth - 18.0);
        double y = FastMath.random(18.0, Util.worldHeight - 18.0);
        return new Location(x, y);
    }

    public Location(double x, double y) {
        super(x, y);
    }

    public Location(Point2D.Double p) {
        this(p.x, p.y);
    }

    public Location(Bot b) {
        this(b.getX(), b.getY());
    }

    public Location(Bot b, ScannedRobotEvent e) {
        this(Util.project(b, e));
    }

    public Location(Bullet b) {
        this(b.getX(), b.getY());
    }

    public double bearing(Location other) {
        return FastMath.atan2(other.x - this.x, other.y - this.y);
    }
}

