/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns.Guns;

import java.awt.geom.Point2D;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.VirtualGuns.VirtualGun;
import rdt.VirtualGuns.VirtualGunFiringData;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;
import robocode.util.Utils;

public class VirtualGunCircularMean
extends VirtualGun {
    @Override
    public String GetName() {
        return "Circular (Mean)";
    }

    @Override
    public void Update() {
    }

    @Override
    public VirtualGunFiringData GetFiringData(VirtualGunsFiringData overallFiringData) {
        double absFiringAngle = this.GetFireAngle(overallFiringData);
        VirtualGunFiringData data = new VirtualGunFiringData();
        data.AddFiringAngle(absFiringAngle);
        return data;
    }

    private double GetFireAngle(VirtualGunsFiringData overallFiringData) {
        RobotData target = this._dataInterface.GetTargetData();
        RobotDataSnapshot targetSnapshot = target.Snapshots.get(this._dataInterface.GetTargetDataAge());
        RobotDataSnapshot targetSnapsotOld = target.Snapshots.get(this._dataInterface.GetTargetDataAge() + 1);
        double myX = overallFiringData.FiringLocationX;
        double myY = overallFiringData.FiringLocationY;
        double enemyX = targetSnapshot.LocationX;
        double enemyY = targetSnapshot.LocationY;
        double enemyHeading = targetSnapshot.AbsoluteHeading;
        double enemyVelocity = this.GetMeanVelocity(target, this._dataInterface.GetTargetDataAge(), 20);
        double enemyHeadingChange = enemyHeading - targetSnapsotOld.AbsoluteHeading;
        double deltaTime = 0.0;
        double battleFieldHeight = AgentSmith.Instance().getBattleFieldHeight();
        double battleFieldWidth = AgentSmith.Instance().getBattleFieldWidth();
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * overallFiringData.FirePower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        return Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - myX, predictedY - myY));
    }

    private double GetMeanVelocity(RobotData target, int startXTicksAgo, int averaveOverYTicks) {
        double totalVelocity = 0.0;
        int numTicks = 0;
        int tick = startXTicksAgo;
        while (tick < startXTicksAgo + averaveOverYTicks) {
            if (tick >= target.NumSnapshots) break;
            RobotDataSnapshot snapshot = target.Snapshots.get(tick);
            totalVelocity += snapshot.VelocityAlongHeading;
            ++numTicks;
            ++tick;
        }
        if (numTicks <= 0) {
            return 0.0;
        }
        return totalVelocity / (double)numTicks;
    }

    @Override
    public void OnWaveReachedTarget(WaveData wave) {
    }

    @Override
    public void OnActualHitOnTarget(WaveData wave, double hitX, double hitY) {
    }
}

