/*
 * Decompiled with CFR 0.152.
 */
package jekl.gunnery.guns;

import java.awt.geom.Point2D;
import jekl.Jekyl;
import jekl.gunnery.guns.LinearFire;

public class CircularFire
extends LinearFire {
    public CircularFire(Jekyl _ar) {
        super(_ar);
    }

    protected Point2D.Double getEstimatedPosition(double time) {
        if (Math.abs(this.angularVelocity_rad_per_sec) < Math.toRadians(0.001)) {
            return super.getEstimatedPosition(time);
        }
        double initialTargetHeading = this.targetHeading;
        double finalTargetHeading = initialTargetHeading + this.angularVelocity_rad_per_sec * time;
        double x = this.targetStartingPoint.getX() - this.targetVelocity / this.angularVelocity_rad_per_sec * (Math.cos(finalTargetHeading) - Math.cos(initialTargetHeading));
        double y = this.targetStartingPoint.getY() - this.targetVelocity / this.angularVelocity_rad_per_sec * (Math.sin(initialTargetHeading) - Math.sin(finalTargetHeading));
        if (x < 0.0) {
            x = 0.0;
        }
        if (x > this.ar.getBattleFieldWidth()) {
            x = this.ar.getBattleFieldWidth();
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y > this.ar.getBattleFieldHeight()) {
            y = this.ar.getBattleFieldHeight();
        }
        return new Point2D.Double(x, y);
    }
}

