/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Analyzer;
import et.CircularDbuf;
import et.CircularObuf;
import et.Driver;
import et.DriverMulti;
import et.DriverSingle;
import et.Enemy;
import et.EnemyMap;
import et.EtRobot;
import et.Gunner;
import et.Location;
import et.Radar;
import java.awt.Color;
import java.io.PrintStream;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public final class Predator
extends EtRobot {
    public static EnemyMap theEnemyMap;
    public static Radar theRadar;
    public static Gunner theGunner;
    public static Driver theDriver;
    private static DriverMulti driverMulti;
    private static DriverSingle driverSingle;
    private CircularDbuf energy;
    private CircularObuf hitMeBuf;
    private static Analyzer theAnalyzer;
    private CircularDbuf velocity;
    private long lastHitByBullet = -1000L;
    private static boolean initOnceDone;
    private long tick = 0L;
    public static long[] placing;
    public static long numOthers;
    long lastFired = 0L;
    private Location vp = new Location(200.0, 200.0);

    private void setDriver() {
        if (this.getOthers() > 1 && theDriver != driverMulti) {
            theDriver = driverMulti;
            ((Robot)this).out.println("switched to driverMulti");
        } else if (this.getOthers() <= 1 && theDriver != driverSingle) {
            theDriver = driverSingle;
            ((Robot)this).out.println("switched to driverSingle");
        }
    }

    protected void initialize() {
        if (!initOnceDone) {
            super.initialize();
            theEnemyMap = new EnemyMap(this);
            theRadar = new Radar(this);
            driverMulti = new DriverMulti(this);
            driverSingle = new DriverSingle(this);
            this.setDriver();
            theGunner = new Gunner(this);
            ((Robot)this).out.println("Predator 1.7, by Eivind Tjore, eivind.tjore@c2i.net");
            this.setColors(Color.cyan, Color.black, Color.white);
            placing = new long[this.getOthers() + 1];
            numOthers = this.getOthers();
            initOnceDone = true;
        }
        this.setEventPriority("HitWallEvent", 0);
        this.setEventPriority("BulletHitEvent", 0);
        this.setEventPriority("BulletHitBulletEvent", 0);
        this.setEventPriority("BulletMissedEvent", 0);
        this.setEventPriority("HitByBulletEvent", 40);
        this.setEventPriority("HitRobotEvent", 50);
        this.setEventPriority("ScannedRobotEvent", 70);
        this.setEventPriority("RobotDeathEvent", 90);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this, 85));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setTurnRadarRight(90.0);
        this.setTurnGunRight(90.0);
        this.setTurnRight(90.0);
        this.energy = new CircularDbuf(2);
        this.hitMeBuf = new CircularObuf(20);
        int n = 0;
        while (n < this.hitMeBuf.size()) {
            this.hitMeBuf.put(new SDPair("", 0.0), 0L);
            ++n;
        }
        driverSingle.reset();
        driverMulti.reset();
        theGunner.reset();
        theEnemyMap.reset();
        this.lastFired = 0L;
        this.velocity = new CircularDbuf(10);
    }

    public final void fireOrExecute(boolean bl) {
        if (bl) {
            theGunner.aimAtTarget();
        }
        Vector vector = this.getScannedRobotEvents();
        int n = 0;
        n = 0;
        while (n < vector.size()) {
            theEnemyMap.update((ScannedRobotEvent)vector.elementAt(n));
            ++n;
        }
        if (theGunner.readyToFire()) {
            theGunner.fireAtTarget();
            this.lastFired = this.getTime();
        } else {
            this.execute();
        }
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            try {
                while (true) {
                    this.energy.put(this.getEnergy(), this.getTime());
                    if (this.energy.delta() > 3.0) {
                        this.lastHitByBullet = this.getTime();
                    }
                    if (this.getOthers() == 0) {
                        theDriver.victoryDance(this.vp);
                    } else {
                        double d = this.direction;
                        this.setDriver();
                        if (this.getOthers() <= 1) {
                            theRadar.sweep();
                        }
                        this.velocity.put(this.getVelocity(), 0L);
                        theDriver.move();
                        this.fireOrExecute(d == this.direction);
                    }
                    theGunner.processBulletList();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var4_4 = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            throw throwable;
        }
    }

    public double getAvgVelocity() {
        double d = 0.0;
        int n = 0;
        while (n < this.velocity.size()) {
            d += this.velocity.get(n);
            ++n;
        }
        return d / (double)this.velocity.size();
    }

    public void onCustomEvent(CustomEvent customEvent) {
        try {
            if (customEvent.getCondition() instanceof RadarTurnCompleteCondition && this.getOthers() > 1) {
                theRadar.sweep();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        theEnemyMap.update(scannedRobotEvent);
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.scan();
        theRadar.sweep();
        if (!hitRobotEvent.isMyFault()) {
            theEnemyMap.setHitMe(hitRobotEvent.getName(), 0.6);
        }
        theDriver.handleHitRobot(hitRobotEvent);
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        this.scan();
        theDriver.handleHitWall();
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this.lastHitByBullet = hitByBulletEvent.getTime();
        double d = hitByBulletEvent.getPower() * 4.0;
        if (hitByBulletEvent.getPower() > 1.0) {
            d += 2.0 * (hitByBulletEvent.getPower() - 1.0);
        }
        theEnemyMap.setHitMe(hitByBulletEvent.getName(), d);
        this.hitMeBuf.put(new SDPair(hitByBulletEvent.getName(), d), hitByBulletEvent.getTime());
    }

    public double getCurrentThreat(Enemy enemy) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.hitMeBuf.size()) {
            if (((SDPair)this.hitMeBuf.get(n)).getS().equals(enemy.getName())) {
                d += ((SDPair)this.hitMeBuf.get(n)).getD();
            }
            d2 += ((SDPair)this.hitMeBuf.get(n)).getD();
            ++n;
        }
        if (d2 > 0.0) {
            return d / d2;
        }
        return 0.0;
    }

    public long timeSinceHit() {
        return (long)this.timeSince(this.lastHitByBullet);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        if (this.getOthers() == 0 && theEnemyMap.get(robotDeathEvent.getName()) != null) {
            this.vp.setLocation(theEnemyMap.get(robotDeathEvent.getName()).getX(), theEnemyMap.get(robotDeathEvent.getName()).getY());
        }
        theEnemyMap.setDead(robotDeathEvent.getName());
    }

    private void printStats(boolean bl, boolean bl2) {
        PrintStream printStream = ((Robot)this).out;
        try {
            printStream.println(theRadar.getStats());
            theGunner.printStats(printStream);
            theDriver.printStats(printStream);
            if (bl) {
                theEnemyMap.printStats(printStream);
                printStream.println("-----------------------------------------------------------------------------");
            }
            int n = 0;
            while ((long)n < numOthers + 1L) {
                printStream.print(placing[n] + "   ");
                ++n;
            }
            printStream.println(" ");
            if (printStream.checkError()) {
                ((Robot)this).out.println("Error writing to file!");
            }
            if (bl2) {
                printStream.close();
            }
        }
        catch (Exception exception) {
            ((Robot)this).out.println("Exception trying to write: " + exception);
        }
    }

    public void onWin(WinEvent winEvent) {
        theEnemyMap.reset();
        placing[0] = placing[0] + 1L;
        if (this.getRoundNum() == this.getNumRounds() - 1) {
            this.printStats(true, true);
        }
        this.printStats(true, false);
    }

    public void onDeath(DeathEvent deathEvent) {
        theEnemyMap.updateKillers();
        theEnemyMap.reset();
        int n = this.getOthers();
        placing[n] = placing[n] + 1L;
        if (this.getRoundNum() == this.getNumRounds() - 1) {
            this.printStats(true, true);
        }
        this.printStats(true, false);
    }

    public void onSkippedTurnEvent(SkippedTurnEvent skippedTurnEvent) {
        ((Robot)this).out.println(" *********************** ");
        ((Robot)this).out.println("   SkippedTurnEvent ");
        ((Robot)this).out.println(" *********************** ");
    }

    static {
        theDriver = null;
        initOnceDone = false;
        numOthers = 0L;
    }

    class SDPair {
        private String st;
        private double db = 0.0;

        public SDPair(String string, double d) {
            this.st = string;
            this.db = d;
        }

        public String getS() {
            return this.st;
        }

        public double getD() {
            return this.db;
        }
    }
}

