/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.CircularObuf;
import et.Tensor;

class TensorCBuf
extends Tensor {
    private CircularObuf buf = new CircularObuf(200);
    private long lastReverse = 0L;

    public TensorCBuf() {
        int n = 0;
        while (n < this.buf.size()) {
            this.buf.put(new Tensor(), n);
            ++n;
        }
    }

    protected void put(Tensor tensor, long l) {
        this.buf.put(tensor, l, true);
        this.setTensor(tensor);
    }

    protected void reset() {
        int n = 0;
        while (n < this.buf.size()) {
            this.buf.put(new Tensor(), n);
            ++n;
        }
        this.lastReverse = 0L;
    }

    protected Tensor get(int n) {
        return (Tensor)this.buf.get(n);
    }

    protected double deltaH() {
        double d = this.getHeading() - this.get(1).getHeading();
        if (this.buf.deltaT() > 0L) {
            d /= (double)this.buf.deltaT();
        }
        if (d > 10.0) {
            d = 10.0;
        } else if (d < -10.0) {
            d = -10.0;
        }
        return d;
    }

    protected double deltaV() {
        double d = this.getVelocity() - this.get(1).getVelocity();
        if (this.buf.deltaT() > 0L) {
            d /= (double)this.buf.deltaT();
        }
        if (d > 2.0) {
            d = 2.0;
        } else if (d < -2.0) {
            d = -2.0;
        }
        return d;
    }

    protected double getAvgHeading(double d) {
        double d2 = 0.0;
        int n = this.buf.timeToPos((long)d);
        int n2 = 0;
        while (n2 < n) {
            d2 += this.get(n2).getHeading();
            ++n2;
        }
        return d2 / (double)n;
    }

    protected double getAvgVelocity(double d) {
        double d2 = 0.0;
        int n = this.buf.timeToPos((long)d);
        int n2 = 0;
        while (n2 < n) {
            d2 += this.get(n2).getVelocity();
            ++n2;
        }
        return d2 / (double)n;
    }

    protected double deltaH(double d) {
        int n = this.buf.timeToPos((long)d);
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n - 1) {
            double d3 = this.get(n2).getHeading() - this.get(n2 + 1).getHeading();
            long l = this.buf.getTimeStamp(n2) - this.buf.getTimeStamp(n2 + 1);
            if (l > 0L) {
                d3 /= (double)l;
            }
            if (d3 > 10.0) {
                d3 = 10.0;
            } else if (d3 < -10.0) {
                d3 = -10.0;
            }
            d2 += d3;
            ++n2;
        }
        return d2 / (double)n;
    }
}

