/*
 * Decompiled with CFR 0.152.
 */
package bndl;

import bndl.Enemy;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import robocode.AdvancedRobot;

public class EnemyTable
extends Hashtable {
    AdvancedRobot robot;
    Enemy lastTarget;

    public EnemyTable(AdvancedRobot advancedRobot) {
        this.robot = advancedRobot;
        this.lastTarget = null;
    }

    public void saveData() {
        Enumeration enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            Enemy enemy = (Enemy)super.get(enumeration.nextElement());
            enemy.writeData();
        }
    }

    public Enumeration getAliveEnemyKeys() {
        return this.getAliveEnemyKeysVec().elements();
    }

    public Vector getAliveEnemyKeysVec() {
        Vector vector = new Vector();
        Enumeration enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!((Enemy)super.get(k)).isAlive()) continue;
            vector.add(k);
        }
        return vector;
    }

    public Enumeration getUpdatedEnemyKeys(long l) {
        return this.getUpdatedEnemyKeysVec(l).elements();
    }

    public Vector getUpdatedEnemyKeysVec(long l) {
        Vector vector = new Vector();
        Enumeration enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!((Enemy)super.get(k)).isAlive() || !((Enemy)super.get(k)).isUpdated(l)) continue;
            vector.add(k);
        }
        return vector;
    }

    public Enemy getNextTarget(long l) {
        double d = Point2D.Double.distance(0.0, 0.0, this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight());
        Enemy enemy = null;
        Enumeration enumeration = this.getUpdatedEnemyKeys(l);
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            Enemy enemy2 = (Enemy)super.get(enumeration.nextElement());
            double d3 = (d - enemy2.getDistance(this.robot.getX(), this.robot.getY())) / 100.0;
            d3 *= d3;
            if (!((d3 += enemy2.getEnergy() / 10.0) >= d2)) continue;
            d2 = d3;
            enemy = enemy2;
        }
        this.lastTarget = enemy;
        return enemy;
    }

    public Enemy getLastTarget() {
        return this.lastTarget;
    }

    public void updateBulletLists() {
        Enumeration enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            ((Enemy)this.get(enumeration.nextElement())).updateBulletList();
        }
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance(Locale.FRANCE);
        NumberFormat numberFormat2 = NumberFormat.getInstance(Locale.FRANCE);
        numberFormat2.setMaximumFractionDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        String string = "";
        Enumeration enumeration = super.keys();
        while (enumeration.hasMoreElements()) {
            Enemy enemy = (Enemy)super.get(enumeration.nextElement());
            string = string + enemy.toString() + "\n";
            n2 += enemy.getHits();
            n += enemy.getRounds();
            d += enemy.getDamageFrom();
        }
        string = string + "--------------------------------------\n";
        string = string + "Total:            " + n + "\t";
        string = n == 0 ? string + "---" + "\t" : string + numberFormat.format(1.0 * (double)n2 / (double)n) + "\t";
        string = string + numberFormat2.format(d);
        return string;
    }
}

