/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Targeting;

import java.util.ArrayList;
import java.util.HashMap;
import rdt.AgentSmith.IBulletHitEventHandler;
import rdt.AgentSmith.IHitByBulletEventHandler;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.IRobotDeathEventHandler;
import rdt.AgentSmith.IRoundStartedEventHandler;
import rdt.AgentSmith.IScannedRobotEventHandler;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.RobotHistory.RobotSnapshotUtils;
import rdt.AgentSmith.Stats.IStats;
import rdt.AgentSmith.Targeting.ITargeting;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Targeting.TargetingDebug;
import rdt.AgentSmith.Utils.MathUtils;
import rdt.AgentSmith.Waves.IWaveManager;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Targeting
implements ITargeting,
IScannedRobotEventHandler,
IRobotDeathEventHandler,
IRoundStartedEventHandler,
IBulletHitEventHandler,
IHitByBulletEventHandler {
    private IStats _stats;
    private IRobot _robot;
    private IWaveManager _friendlyWaveManager;
    private IWaveManager _enemyWaveManager;
    private Target _currentTarget;
    private HashMap<String, Target> _targetsLookup = new HashMap();
    private ArrayList<Target> _targets = new ArrayList();

    public Targeting(IRobot robot, IStats stats) {
        this._robot = robot;
        this._stats = stats;
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        this._robot.RegisterForEventHandling(this);
        new TargetingDebug(robot, this);
    }

    @Override
    public void SetWaveManagers(IWaveManager friendlyWaveManager, IWaveManager enemyWaveManager) {
        this._friendlyWaveManager = friendlyWaveManager;
        this._enemyWaveManager = enemyWaveManager;
    }

    @Override
    public ArrayList<Target> GetTargets() {
        return this._targets;
    }

    @Override
    public boolean HasValidTarget() {
        if (this._currentTarget == null) {
            return false;
        }
        return this._currentTarget.Valid;
    }

    @Override
    public void SetCurrentTarget(Target target) {
        this._currentTarget = target;
    }

    @Override
    public Target GetCurrentTarget() {
        return this._currentTarget;
    }

    public Target GetTargetByName(String name) {
        Target target = this._targetsLookup.get(name);
        if (target == null) {
            target = new Target(name, this._robot, this._friendlyWaveManager, this._enemyWaveManager, this._stats);
            this._targetsLookup.put(name, target);
            this._targets.add(target);
        }
        return target;
    }

    @Override
    public void OnScannedRobotEvent(ScannedRobotEvent eventData) {
        Target target = this.GetTargetByName(eventData.getName());
        RobotHistory history = target.RobotHistory;
        RobotSnapshot snapshot = history.GetSnapshotForWriting();
        double absoluteAngle = this._robot.getHeadingRadians() + eventData.getBearingRadians();
        double x = this._robot.getX() + eventData.getDistance() * MathUtils.FastSin(absoluteAngle);
        double y = this._robot.getY() + eventData.getDistance() * MathUtils.FastCos(absoluteAngle);
        this.UpdateTarget(target, snapshot, x, y, eventData.getHeadingRadians(), eventData.getVelocity(), eventData.getEnergy(), absoluteAngle);
        target.RobotHistory.SubmitSnapshot(snapshot);
        this.CheckForTargetFiring(target);
    }

    @Override
    public void OnHitByBulletEvent(HitByBulletEvent event) {
        Target target = this.GetTargetByName(event.getName());
        if (target == null || !target.Valid || !target.Alive) {
            return;
        }
        target.LastTickTargetHitUs = this._robot.getTime();
        target.LastEnergyGainedFromHittingUs = event.getPower() * 3.0;
    }

    @Override
    public void OnBulletHitEvent(BulletHitEvent event) {
        Target target = this.GetTargetByName(event.getName());
        if (target == null || !target.Valid || !target.Alive) {
            return;
        }
        double firepower = event.getBullet().getPower();
        double energyLost = firepower * 4.0;
        if (firepower > 1.0) {
            energyLost += 2.0 * (firepower - 1.0);
        }
        target.LastTickWeHitTarget = this._robot.getTime();
        target.LastEnergyLostFromUsHittingTarget = energyLost;
    }

    @Override
    public void OnRobotDeathEvent(RobotDeathEvent eventData) {
        Target target = this.GetTargetByName(eventData.getName());
        target.Alive = false;
        target.Invalidate();
    }

    @Override
    public void OnRoundStartedEvent() {
        for (int targetIndex = 0; targetIndex < this._targets.size(); ++targetIndex) {
            this._targets.get(targetIndex).OnRoundStart();
        }
    }

    private void UpdateTarget(Target target, RobotSnapshot snapshot, double x, double y, double absHeading, double velocity, double energy, double absAngleFromAgentSmith) {
        target.Valid = true;
        target.Alive = true;
        target.LastUpdatedTick = this._robot.getTime();
        RobotSnapshotUtils.FillInSnapshot(this._robot, snapshot, target.RobotHistory, x, y, velocity, absHeading, this._robot.getX(), this._robot.getY(), absAngleFromAgentSmith, energy);
    }

    private void CheckForTargetFiring(Target target) {
        double bulletFirepower;
        double velocityChange;
        if (target.NextTickCanFireAgain > this._robot.getTime()) {
            return;
        }
        if (target.RobotHistory.SnapshotCount <= 1) {
            return;
        }
        RobotSnapshot latestSnapshot = target.RobotHistory.Snapshots.get(0);
        RobotSnapshot previousSnapshot = target.RobotHistory.Snapshots.get(1);
        if (latestSnapshot.Tick - previousSnapshot.Tick > 1L) {
            return;
        }
        boolean hitUs = false;
        if (!hitUs && Utils.isNear((double)latestSnapshot.VelocityAlongHeading, (double)0.0) && (velocityChange = Math.abs(previousSnapshot.VelocityAlongHeading)) > 2.0) {
            return;
        }
        double energyChange = latestSnapshot.Energy - previousSnapshot.Energy;
        if (target.LastTickTargetHitUs == this._robot.getTime()) {
            energyChange -= target.LastEnergyGainedFromHittingUs;
        }
        if (target.LastTickWeHitTarget == this._robot.getTime()) {
            energyChange += target.LastEnergyLostFromUsHittingTarget;
        }
        if (Utils.isNear((double)(bulletFirepower = Math.abs(energyChange)), (double)0.0)) {
            return;
        }
        if (bulletFirepower < 0.0 || bulletFirepower > 3.0) {
            System.out.println("Detected firing energy drop but it is out of range: " + bulletFirepower);
            return;
        }
        target.LastTickFired = previousSnapshot.Tick;
        target.LastFiredBulletFirepower = bulletFirepower;
        double gunHeatGenerated = 1.0 + bulletFirepower / 5.0;
        long ticksToCool = (int)Math.ceil(gunHeatGenerated / 0.1);
        target.NextTickCanFireAgain = target.LastTickFired + ticksToCool;
    }
}

