/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import jcs.Coord;
import jcs.Enemy;
import jcs.Seth;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AntiGrav {
    private final double WALLFACTOR = 6000.0;
    private final double BOTFACTOR = 15000.0;
    private final double WALL_TOLERANCE = 3000.0;
    private double xWall;
    private double yWall;
    private final int POINT_POWER = 3;
    public Seth seth;

    public Coord calcCoord(Coord currentPos) {
        Enemy[] enemies = this.seth.getEnemyList().getEnemies();
        Coord go = new Coord(0.0, 0.0);
        double hyp = 0.0;
        double xSum = 0.0;
        double ySum = 0.0;
        Coord wall = this.wallSum(currentPos);
        double botX = 0.0;
        double botY = 0.0;
        int i = 0;
        while (i < enemies.length && enemies[i] != null) {
            Coord temp = this.pointSum(currentPos, enemies[i].getCoord(), 1.0);
            botX += temp.getX();
            botY += temp.getY();
            ++i;
        }
        Coord artificial = this.pointSum(currentPos, new Coord(this.xWall / (double)2, this.yWall / (double)2), 0.5);
        xSum = botX / (double)this.seth.getEnemyList().getCount() + wall.getX() + artificial.getX();
        ySum = botY / (double)this.seth.getEnemyList().getCount() + wall.getY() + artificial.getY();
        go.setX(xSum + currentPos.getX());
        go.setY(ySum + currentPos.getY());
        return go;
    }

    private final Coord wallSum(Coord currentPos) {
        double sumX = 0.0;
        double sumY = 0.0;
        if (currentPos.getX() < 3000.0) {
            sumX += 6000.0 * (1.0 / currentPos.getX());
        }
        if (currentPos.getY() < 3000.0) {
            sumY += 6000.0 * (1.0 / currentPos.getY());
        }
        if (this.xWall - currentPos.getX() < 3000.0) {
            sumX -= 6000.0 * (1.0 / (this.xWall - currentPos.getX()));
        }
        if (this.yWall - currentPos.getY() < 3000.0) {
            sumY -= 6000.0 * (1.0 / (this.yWall - currentPos.getY()));
        }
        return new Coord(sumX, sumY);
    }

    private final Coord pointSum(Coord currentPos, Coord enemyPos, double power) {
        double distance = currentPos.calcDist(enemyPos);
        double theta = enemyPos.calcHeading(currentPos);
        double force = power * 15000.0 * (1.0 / distance);
        Coord sum = currentPos.getCoordFromScan(theta, force);
        sum.setX(sum.getX() - currentPos.getX());
        sum.setY(sum.getY() - currentPos.getY());
        return sum;
    }

    private final /* synthetic */ void this() {
        this.WALLFACTOR = 6000.0;
        this.BOTFACTOR = 15000.0;
        this.WALL_TOLERANCE = 3000.0;
        this.POINT_POWER = 3;
    }

    public AntiGrav(Seth _seth) {
        this.this();
        this.xWall = _seth.getBattleFieldWidth();
        this.yWall = _seth.getBattleFieldHeight();
        this.seth = _seth;
    }
}

