/*
 * Decompiled with CFR 0.152.
 */
package kenran.mega;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kenran.util.EnemyWave;
import kenran.util.MovementState;
import kenran.util.Utils;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public class Pantheist
extends AdvancedRobot {
    private static final int PM_LENGTH = 3000;
    private static final int RECENT_PATTERN_LENGTH = 12;
    private static Rectangle2D _fieldRect;
    private static Point2D _enemyPosition;
    private static Point2D _robotPosition;
    private static double _enemyHeading;
    private static double _enemyBearing;
    private static double _enemyVelocity;
    private static double _enemyDistance;
    private static double _deltaHeading;
    private static double _enemyEnergy;
    private static ArrayList _record;
    private static MovementDeque _recent;
    private static MovementDeque _iterator;
    private static int _recordSize;
    private static boolean _recordIsFull;
    private static boolean aimed;
    private static final int BINS = 47;
    private static double[] _surfStats;
    private static ArrayList _enemyWaves;
    private static ArrayList _surfDirections;
    private static ArrayList _surfAbsBearings;
    private static final double WALL_STICK = 160.0;

    public void run() {
        _enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();
        _enemyHeading = 0.0;
        _enemyEnergy = 100.0;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        aimed = false;
        _fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        if (this.getRoundNum() == 0) {
            for (int i = 0; i < 12; ++i) {
                _recent.add(0.0, 8.0);
            }
        }
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        _robotPosition.setLocation(this.getX(), this.getY());
        _enemyDistance = scannedRobotEvent.getDistance();
        _deltaHeading = scannedRobotEvent.getHeadingRadians() - _enemyHeading;
        _enemyHeading = scannedRobotEvent.getHeadingRadians();
        _enemyBearing = this.getHeadingRadians() + scannedRobotEvent.getBearingRadians();
        _enemyVelocity = scannedRobotEvent.getVelocity();
        _enemyPosition.setLocation(Utils.project(_robotPosition, _enemyBearing, _enemyDistance));
        double d = this.getVelocity() * Math.sin(scannedRobotEvent.getBearingRadians());
        _surfDirections.add(0, new Integer(d >= 0.0 ? 1 : -1));
        _surfAbsBearings.add(0, new Double(_enemyBearing + Math.PI));
        double d2 = _enemyEnergy - scannedRobotEvent.getEnergy();
        _enemyEnergy = scannedRobotEvent.getEnergy();
        if (_enemyEnergy < 0.1) {
            this.stop();
            this.setTurnGunRightRadians(_enemyBearing);
            this.setFire(0.1);
        }
        if (d2 < 3.01 && d2 > 0.09 && _surfDirections.size() > 2) {
            EnemyWave enemyWave = new EnemyWave();
            enemyWave.fireTime = this.getTime() - 1L;
            enemyWave.distanceTraveled = enemyWave.bulletVelocity = Utils.bulletVelocity(d2);
            enemyWave.direction = (Integer)_surfDirections.get(2);
            enemyWave.directAngle = (Double)_surfAbsBearings.get(2);
            enemyWave.fireLocation = (Point2D.Double)_enemyPosition.clone();
            _enemyWaves.add(enemyWave);
        }
        this.updateWaves();
        this.doSurfing();
        this.record(_deltaHeading, _enemyVelocity);
        _recent.add(_deltaHeading, _enemyVelocity);
        double d3 = this.bulletPower();
        if (this.getRoundNum() != 0) {
            Point2D.Double double_ = new Point2D.Double();
            double_.setLocation(this.predictPosition(d3));
            double d4 = Utils.absoluteBearing(_robotPosition, double_);
            this.setTurnGunRightRadians(Utils.normalRelativeAngle(d4 - this.getGunHeadingRadians()));
            aimed = true;
        } else {
            double d5;
            double d6;
            block6: {
                double d7 = 0.0;
                d6 = _enemyPosition.getX();
                d5 = _enemyPosition.getY();
                double d8 = _enemyHeading;
                double d9 = this.getBattleFieldWidth();
                double d10 = this.getBattleFieldHeight();
                do {
                    double d11;
                    d7 += 1.0;
                    if (!(d11 * Utils.bulletVelocity(d3) < Utils.distance(_robotPosition.getX(), _robotPosition.getY(), d6, d5))) break block6;
                    d5 += Math.cos(d8) * _enemyVelocity;
                } while (!((d6 += Math.sin(d8 += _deltaHeading) * _enemyVelocity) < 17.9 || d5 < 17.9 || d6 > d9 - 17.9) && !(d5 > d10 - 17.9));
                d6 = Math.min(Math.max(18.0, d6), d9 - 18.0);
                d5 = Math.min(Math.max(18.0, d5), d10 - 18.0);
            }
            double d12 = Utils.normalAbsoluteAngle(Utils.absoluteBearing(this.getX(), this.getY(), d6, d5));
            this.setTurnGunRightRadians(Utils.normalRelativeAngle(d12 - this.getGunHeadingRadians()));
            aimed = true;
        }
        if (aimed) {
            this.setFire(this.bulletPower());
            aimed = false;
        }
        double d13 = _enemyBearing - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(2.1 * Utils.normalRelativeAngle(d13));
    }

    public void updateWaves() {
        for (int i = 0; i < _enemyWaves.size(); ++i) {
            EnemyWave enemyWave = (EnemyWave)_enemyWaves.get(i);
            enemyWave.distanceTraveled = (double)(this.getTime() - enemyWave.fireTime) * enemyWave.bulletVelocity;
            if (!(enemyWave.distanceTraveled > _robotPosition.distance(enemyWave.fireLocation) + 50.0)) continue;
            _enemyWaves.remove(i);
            --i;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double d = 50000.0;
        EnemyWave enemyWave = null;
        for (int i = 0; i < _enemyWaves.size(); ++i) {
            EnemyWave enemyWave2 = (EnemyWave)_enemyWaves.get(i);
            double d2 = _robotPosition.distance(enemyWave2.fireLocation) - enemyWave2.distanceTraveled;
            if (!(d2 > enemyWave2.bulletVelocity) || !(d2 < d)) continue;
            enemyWave = enemyWave2;
            d = d2;
        }
        return enemyWave;
    }

    public static int getFactorIndex(EnemyWave enemyWave, Point2D point2D) {
        double d = Utils.absoluteBearing(enemyWave.fireLocation, point2D) - enemyWave.directAngle;
        double d2 = Utils.normalRelativeAngle(d) / Utils.maxEscapeAngle(enemyWave.bulletVelocity) * (double)enemyWave.direction;
        return (int)Utils.limit(0.0, d2 * 23.0 + 23.0, 46.0);
    }

    public void logHit(EnemyWave enemyWave, Point2D.Double double_) {
        int n = Pantheist.getFactorIndex(enemyWave, double_);
        for (int i = 0; i < 47; ++i) {
            int n2 = i;
            _surfStats[n2] = _surfStats[n2] + 1.0 / (Math.pow(n - i, 2.0) + 1.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double double_ = new Point2D.Double(hitByBulletEvent.getBullet().getX(), hitByBulletEvent.getBullet().getY());
            EnemyWave enemyWave = null;
            for (int i = 0; i < _enemyWaves.size(); ++i) {
                EnemyWave enemyWave2 = (EnemyWave)_enemyWaves.get(i);
                if (!(Math.abs(enemyWave2.distanceTraveled - _robotPosition.distance(enemyWave2.fireLocation)) < 50.0) || Math.round(Utils.bulletVelocity(hitByBulletEvent.getBullet().getPower()) * 10.0) != Math.round(enemyWave2.bulletVelocity * 10.0)) continue;
                enemyWave = enemyWave2;
                break;
            }
            if (enemyWave != null) {
                this.logHit(enemyWave, double_);
                _enemyWaves.remove(_enemyWaves.lastIndexOf(enemyWave));
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double double_ = new Point2D.Double(bulletHitBulletEvent.getBullet().getX(), bulletHitBulletEvent.getBullet().getY());
            EnemyWave enemyWave = null;
            for (int i = 0; i < _enemyWaves.size(); ++i) {
                EnemyWave enemyWave2 = (EnemyWave)_enemyWaves.get(i);
                if (!(Math.abs(enemyWave2.distanceTraveled - enemyWave2.fireLocation.distance(double_)) < 50.0) || Math.round(Utils.bulletVelocity(bulletHitBulletEvent.getHitBullet().getPower()) * 10.0) != Math.round(enemyWave2.bulletVelocity * 10.0)) continue;
                enemyWave = enemyWave2;
                break;
            }
            if (enemyWave != null) {
                this.logHit(enemyWave, double_);
                _enemyWaves.remove(_enemyWaves.lastIndexOf(enemyWave));
            }
        }
    }

    public Point2D predictPosition(EnemyWave enemyWave, int n) {
        Point2D point2D = (Point2D)_robotPosition.clone();
        double d = this.getVelocity();
        double d2 = this.getHeadingRadians();
        int n2 = 0;
        boolean bl = false;
        do {
            double d3 = Utils.wallSmoothing(_fieldRect, point2D, Utils.absoluteBearing(enemyWave.fireLocation, point2D) + (double)n * 1.5707963267948966, n) - d2;
            double d4 = 1.0;
            if (Math.cos(d3) < 0.0) {
                d3 += Math.PI;
                d4 = -1.0;
            }
            d3 = Utils.normalRelativeAngle(d3);
            double d5 = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(d));
            d2 = Utils.normalRelativeAngle(d2 + Utils.limit(-d5, d3, d5));
            d += d * d4 < 0.0 ? 2.0 * d4 : d4;
            d = Utils.limit(-8.0, d, 8.0);
            point2D = Utils.project(point2D, d2, d);
            ++n2;
            if (!(point2D.distance(enemyWave.fireLocation) < enemyWave.distanceTraveled + (double)n2 * enemyWave.bulletVelocity + enemyWave.bulletVelocity)) continue;
            bl = true;
        } while (!bl && n2 < 500);
        return point2D;
    }

    public double checkDanger(EnemyWave enemyWave, int n) {
        int n2 = Pantheist.getFactorIndex(enemyWave, this.predictPosition(enemyWave, n));
        return _surfStats[n2];
    }

    public void doSurfing() {
        EnemyWave enemyWave = this.getClosestSurfableWave();
        if (enemyWave == null) {
            return;
        }
        double d = this.checkDanger(enemyWave, -1);
        double d2 = this.checkDanger(enemyWave, 1);
        double d3 = Utils.absoluteBearing(enemyWave.fireLocation, _robotPosition);
        d3 = d < d2 ? Utils.wallSmoothing(_fieldRect, _robotPosition, d3 - 1.5707963267948966, -1) : Utils.wallSmoothing(_fieldRect, _robotPosition, d3 + 1.5707963267948966, 1);
        Utils.setBackAsFront(this, d3);
    }

    private double bulletPower() {
        double d = _enemyEnergy <= 1.0 ? Math.min(0.3, this.getEnergy()) : (_enemyEnergy <= 2.0 && _enemyEnergy > 1.0 ? Math.min(0.6, this.getEnergy()) : (_enemyEnergy <= 3.0 && _enemyEnergy > 2.0 ? Math.min(0.8, this.getEnergy()) : (_enemyEnergy <= 4.0 && _enemyEnergy > 3.0 ? Math.min(1.0, this.getEnergy()) : Math.min(2.0, this.getEnergy()))));
        return d;
    }

    private void record(double d, double d2) {
        _record.add(new MovementState(d, d2));
        if (_recordIsFull) {
            _record.remove(0);
        } else {
            _recordIsFull = ++_recordSize >= 3000;
        }
    }

    private double compare(MovementDeque movementDeque, MovementDeque movementDeque2) {
        double d = 0.0;
        for (int i = 0; i < 12; ++i) {
            d += Math.abs(movementDeque.get(i).getDeltaHeading() - movementDeque2.get(i).getDeltaHeading()) + Math.abs(movementDeque.get(i).getVelocity() - movementDeque2.get(i).getVelocity());
        }
        return d;
    }

    private int lastIndexOfMatchingSeries() {
        for (int i = 0; i < 12; ++i) {
            _iterator.add((MovementState)_record.get(i));
        }
        double d = this.compare(_iterator, _recent);
        int n = 11;
        int n2 = 12;
        do {
            MovementState movementState = (MovementState)_record.get(n2);
            _iterator.add(movementState.getDeltaHeading(), movementState.getVelocity());
            double d2 = this.compare(_iterator, _recent);
            if (!(d2 < d)) continue;
            d = d2;
            n = n2;
        } while (++n2 < _recordSize - 50);
        return n;
    }

    private Point2D predictPosition(double d) {
        int n = this.lastIndexOfMatchingSeries();
        double d2 = _enemyPosition.getX();
        double d3 = _enemyPosition.getY();
        double d4 = _enemyHeading;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = n + 1; i < _recordSize && d6 <= d5; d6 += 1.0, ++i) {
            MovementState movementState = (MovementState)_record.get(i);
            d5 = (int)Utils.bulletTravelTime(_robotPosition.distance(d2 += Math.sin(d4 += movementState.getDeltaHeading()) * movementState.getVelocity(), d3 += Math.cos(d4) * movementState.getVelocity()), d);
        }
        return new Point2D.Double(d2, d3);
    }

    static {
        _enemyPosition = new Point2D.Double();
        _robotPosition = new Point2D.Double();
        _record = new ArrayList(3000);
        _recent = new MovementDeque();
        _iterator = new MovementDeque();
        _recordSize = 0;
        _recordIsFull = false;
        _surfStats = new double[47];
    }

    static class MovementDeque {
        private MovementState[] msArray = new MovementState[12];

        MovementDeque() {
        }

        void add(double d, double d2) {
            for (int i = 0; i < 11; ++i) {
                this.msArray[i] = this.msArray[i + 1];
            }
            this.msArray[11] = new MovementState(d, d2);
        }

        void add(MovementState movementState) {
            this.add(movementState.getDeltaHeading(), movementState.getVelocity());
        }

        MovementState get(int n) {
            if (0 <= n && n < 12) {
                return this.msArray[n];
            }
            return null;
        }
    }
}

