/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile;

import cbot.agile.CU;
import cbot.agile.GameInfo;
import cbot.agile.Point;
import cbot.agile.Pray;
import cbot.agile.StorageManager;
import cbot.agile.driver.AbstractDriver;
import cbot.agile.driver.RandomPointDriver;
import cbot.agile.gun.Gun;
import cbot.agile.test.UnitTestBase;
import java.awt.Color;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Nibbler
extends UnitTestBase {
    public static Pray pray;
    public static Gun gun;
    public static AbstractDriver driver;
    public StorageManager storageManager;
    public Point currentCordinate;

    public void run() {
        this.running = true;
        this.initRobot();
        while (true) {
            this.initTurn();
            if (pray != null) {
                gun.aimAndFire(pray);
                driver.drive(pray);
            }
            this.execute();
        }
    }

    private final void initTurn() {
        GameInfo.addTotalTurns();
        this.currentCordinate = new Point(this.getX(), this.getY());
        if (pray == null || this.getTime() - pray.getTime() > (long)2) {
            this.setTurnRadarRight(90.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (pray == null) {
            pray = new Pray(e, this);
        } else {
            pray.update(e, this);
        }
        gun.aim(pray);
        this.setTurnRadarRight(CU.normalRelativeAngle(this.getHeading() + pray.getBearing() - this.getRadarHeading()) * 1.6);
    }

    public void onWin(WinEvent e) {
        GameInfo.addWin();
        this.end();
        driver.victoryDance();
    }

    public void onDeath(DeathEvent e) {
        GameInfo.addLost();
        this.end();
    }

    public void onBulletHit(BulletHitEvent e) {
        if (pray != null) {
            pray.gotHitByBullet(e.getBullet());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        driver.handleBeeingHit();
        if (pray != null) {
            pray.hitRobotWithBullet(e.getBullet());
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        GameInfo.addSkippedTurns();
    }

    public Point getCordinate() {
        return this.currentCordinate;
    }

    public void initTestRobot() {
        CU.init(this);
        driver = new RandomPointDriver(this);
        gun = new Gun(this);
        this.currentCordinate = new Point(0.0, 0.0);
        StorageManager.init(this);
    }

    private final void initRobot() {
        this.setColors(new Color(180, 180, 213), new Color(153, 204, 255), new Color(153, 204, 255));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        CU.init(this);
        this.setTurnRadarRight(90.0);
        StorageManager.init(this);
        if (driver == null) {
            driver = new RandomPointDriver(this);
        } else {
            driver.update(this);
        }
        if (gun == null) {
            gun = new Gun(this);
        } else {
            gun.update(this);
        }
    }

    private final void printStatistics() {
    }

    private final void end() {
        this.clearAllEvents();
        this.printStatistics();
        try {
            pray.getPattern().logBreak();
            pray.saveData();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        pray = null;
        StorageManager.writeDataToFile();
    }
}

