/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations;

import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.IRobot;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Utils.MathUtils;

public class IterativeLinearWithWallStopping
extends Gun {
    public IterativeLinearWithWallStopping(String ownerName, IRobot robot, RobotSnapshots targetSnapshots, IStats stats) {
        super(ownerName + " : Iterative Linear with Wall Stopping", robot, targetSnapshots, stats);
    }

    @Override
    public void GetFiringSolutions(FiringData firingData, FiringSolutions outSolutions) {
        double dY;
        double dX;
        double distanceToTargetSq;
        RobotSnapshot snapshot = firingData.TargetAtFiringTick;
        double enemyHeading = snapshot.AbsoluteHeading;
        double enemyVelocity = snapshot.VelocityAlongHeading;
        double battleFieldWidth = this._robot.getBattleFieldWidth();
        double battleFieldHeight = this._robot.getBattleFieldHeight();
        double predictedX = snapshot.LocationX;
        double predictedY = snapshot.LocationY;
        double distanceTravelled = 0.0;
        while (!((distanceTravelled += firingData.BulletVelocity) * distanceTravelled > (distanceToTargetSq = (dX = predictedX - firingData.SourceX) * dX + (dY = predictedY - firingData.SourceY) * dY))) {
            predictedY += MathUtils.FastCos(enemyHeading) * enemyVelocity;
            if (!((predictedX += MathUtils.FastSin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        outSolutions.WriteSolution(Math.atan2(predictedX - firingData.SourceX, predictedY - firingData.SourceY), 1.0, this);
    }
}

