/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Waves;

import java.util.ArrayList;
import rdt.Wraith.IRobot;
import rdt.Wraith.MEA.RealWallCullingAndInterceptMEACalculator;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.FastOutsideOfBattlefield;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.WaveData;
import rdt.Wraith.Waves.WaveManagerBase;

public class FriendlyWaveManager
extends WaveManagerBase {
    private final ITargeting _targeting;

    public FriendlyWaveManager(IRobot robot, ITargeting targeting) {
        super(robot, 200, new RealWallCullingAndInterceptMEACalculator(new FastOutsideOfBattlefield(robot, 22)));
        this._targeting = targeting;
    }

    @Override
    public void Update() {
        ArrayList<WaveData> activeWaves = this.GetActiveWaves();
        int numActiveWaves = activeWaves.size();
        for (int index = 0; index < numActiveWaves; ++index) {
            WaveData activeWave = activeWaves.get(index);
            this.CheckAndRegisterWavePassingTargets(activeWave);
        }
        super.Update();
    }

    private void CheckAndRegisterWavePassingTargets(WaveData waveData) {
        long currentTick = this._robot.getTime();
        double distanceFromOrigin = waveData.GetDistanceForTick(currentTick);
        double distanceFromOriginSq = distanceFromOrigin * distanceFromOrigin;
        ArrayList<Target> targets = this._targeting.GetTargets();
        int numTargets = targets.size();
        for (int targetIndex = 0; targetIndex < numTargets; ++targetIndex) {
            Target target = targets.get(targetIndex);
            if (!target.Valid || waveData.HasPassedTarget(target)) continue;
            RobotSnapshot snapshot = target.RobotSnapshots.Read(currentTick);
            double dX = waveData.OriginX - snapshot.LocationX;
            double dY = waveData.OriginY - snapshot.LocationY;
            double distanceFromWaveOriginToTargetSq = dX * dX + dY * dY;
            if (!(distanceFromOriginSq > distanceFromWaveOriginToTargetSq)) continue;
            waveData.RegisterPassedTarget(target);
            for (int listenerIndex = 0; listenerIndex < this._eventHandlers.size(); ++listenerIndex) {
                ((IWaveEventHandler)this._eventHandlers.get(listenerIndex)).OnWavePassed(waveData, target);
            }
        }
    }
}

