/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.utils.knn;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.WeightedManhattanDistanceFunction;
import catcat20.helios.utils.HUtils;
import catcat20.helios.utils.Wave;
import catcat20.helios.utils.knn.DataPointMaker;
import catcat20.helios.utils.knn.GFData;
import java.util.ArrayList;

public class WaveKNNModel {
    public DistanceFunction distanceFunction;
    public int kSize;
    public int kDivisor;
    public double treeWeight = 1.0;
    public double decayRate = 1.0;
    public KdTree<GFData> tree;
    public DataPointMaker dataPointMaker;

    public WaveKNNModel(DataPointMaker dataPointMaker) {
        this.tree = new KdTree(dataPointMaker.weights.length);
        this.distanceFunction = new WeightedManhattanDistanceFunction(dataPointMaker.weights);
        this.dataPointMaker = dataPointMaker;
    }

    public WaveKNNModel setKSize(int kSize) {
        this.kSize = kSize;
        return this;
    }

    public WaveKNNModel setKDivisor(int kDivisor) {
        this.kDivisor = kDivisor;
        return this;
    }

    public WaveKNNModel setTreeWeight(int treeWeight) {
        this.treeWeight = treeWeight;
        return this;
    }

    public WaveKNNModel setDecayRate(int decayRate) {
        this.decayRate = decayRate;
        return this;
    }

    public void addPoint(Wave w, GFData data) {
        this.tree.addPoint(this.dataPointMaker.dataPointFromWave(w), (Object)data);
    }

    public ArrayList<GFData> getNearestNeighborsList(Wave w) {
        return this.getNearestNeighborsList(w, HUtils.limit(1, this.tree.size() / this.kDivisor, this.kSize));
    }

    public ArrayList<GFData> getNearestNeighborsList(Wave w, int k) {
        NearestNeighborIterator<GFData> neighbors = this.tree.getNearestNeighborIterator(this.dataPointMaker.dataPointFromWave(w), k, this.distanceFunction);
        ArrayList<GFData> list = new ArrayList<GFData>();
        for (GFData data : neighbors) {
            data.distance = neighbors.distance();
            data.decayRate = this.decayRate;
            data.treeWeight = this.treeWeight;
            list.add(data);
        }
        return list;
    }
}

