/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.knnUtils;

import catcat20.jewel.iolite.knnUtils.DangerModel;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.MovementPredictor;
import catcat20.jewel.iolite.utils.Wave;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import robocode.Rules;
import robocode.util.Utils;
import voidious.utils.DiaUtils;

public class KNNModel<T>
extends DangerModel<T> {
    public static final int COUNTERCLOCKWISE = -1;
    public static final int CLOCKWISE = 1;
    public KdTree<T> tree;
    public int maxK = 32;
    public int kDivider = 2;
    public String[] components;
    public double[] weights;
    Rectangle2D.Double rect;
    public static double currentGF = 0.0;
    double oldLatVel = 0.0;

    public KNNModel(String[] components, double[] weights, String name) {
        super(name);
        this.components = components;
        this.weights = weights;
        this.name = name;
        this.isQuickTargeting = false;
        this.tree = new KdTree(weights.length);
    }

    public KNNModel<T> setMaxK(int maxK) {
        this.maxK = maxK;
        return this;
    }

    public KNNModel<T> setKDivider(int kDivider) {
        this.kDivider = kDivider;
        return this;
    }

    @Override
    public KNNModel<T> setModelWeight(double modelWeight) {
        this.modelWeight = modelWeight;
        return this;
    }

    public double[] dataPoint(Wave ew) {
        double[] dataPoint = new double[this.components.length];
        HashMap<String, Double> data = this.getData(ew);
        for (int i = 0; i < this.components.length; ++i) {
            try {
                dataPoint[i] = data.get(this.components[i]) * this.weights[i];
                continue;
            }
            catch (Exception e) {
                System.err.println("dataPoint\u3068weights\u306e\u9577\u3055\u304c\u9055\u3046\u304b\u3001\u5b58\u5728\u3057\u306a\u3044\u30ad\u30fc\u3092\u5165\u308c\u305f\u304b\u3082\uff01");
            }
        }
        return dataPoint;
    }

    public HashMap<String, Double> getData(Wave ew) {
        HashMap<String, Double> data = new HashMap<String, Double>();
        this.rect = ew.enemyData.rect;
        double[] meas = this.getMea(ew.enemyData, ew.myData, (long)ew.fireTime);
        double maeWallAhead = (ew.direction < 0.0 ? meas[0] : meas[1]) / IUtils.maxEscapeAngle(ew.bulletVelocity());
        double maeWallReverse = (ew.direction > 0.0 ? meas[0] : meas[1]) / IUtils.maxEscapeAngle(ew.bulletVelocity());
        double orbitalWallAhead = this.orbitalWallDistance(this.rect, ew.enemyData, ew.myData, (int)ew.direction, IUtils.maxEscapeAngle(ew.bulletVelocity()), true);
        double orbitalWallReverse = this.orbitalWallDistance(this.rect, ew.enemyData, ew.myData, (int)ew.direction, IUtils.maxEscapeAngle(ew.bulletVelocity()), false);
        double myLatVel = ew.myData.latVel;
        double myAdvVel = ew.myData.advVel;
        double myAccel = this.accelSegment(ew.myData.latVel, ew.myData.oldLatVel, ew.myData.distance);
        double bft = ew.enemyData.distance / ew.bulletVelocity();
        double myRelativeHeadingFromEnemy = Utils.normalRelativeAngle((double)(this.effectiveHeading(ew.myData.heading, IUtils.sign(ew.myData.velocity)) - DiaUtils.absoluteBearing(ew.enemyData, ew.myData)));
        double myOrbitDirection = myRelativeHeadingFromEnemy < 0.0 ? -1.0 : 1.0;
        double myRelativeHeading = Math.abs(myRelativeHeadingFromEnemy);
        double enDistLast10 = ew.enemyData.distance(ew.enemyData.oldPositions.get(Math.min(10, ew.enemyData.oldPositions.size() - 1)));
        double enDistLast16 = ew.enemyData.distance(ew.enemyData.oldPositions.get(Math.min(16, ew.enemyData.oldPositions.size() - 1)));
        double enDistLast35 = ew.enemyData.distance(ew.enemyData.oldPositions.get(Math.min(35, ew.enemyData.oldPositions.size() - 1)));
        double enDistLast30 = ew.enemyData.distance(ew.enemyData.oldPositions.get(Math.min(30, ew.enemyData.oldPositions.size() - 1)));
        double enDistLast60 = ew.enemyData.distance(ew.enemyData.oldPositions.get(Math.min(60, ew.enemyData.oldPositions.size() - 1)));
        double enDistLast120 = ew.enemyData.distance(ew.enemyData.oldPositions.get(Math.min(120, ew.enemyData.oldPositions.size() - 1)));
        double myDistLast10 = ew.myData.distance(ew.enemyData.oldPositions.get(Math.min(10, ew.enemyData.oldPositions.size() - 1)));
        double myDistLast16 = ew.myData.distance(ew.enemyData.oldPositions.get(Math.min(16, ew.enemyData.oldPositions.size() - 1)));
        double myDistLast35 = ew.myData.distance(ew.enemyData.oldPositions.get(Math.min(35, ew.enemyData.oldPositions.size() - 1)));
        double virtuality = ew.virtuality();
        data.put("firePower", ew.bulletPower);
        data.put("bft", bft / 120.0);
        data.put("distance", ew.enemyData.distance / 1300.0);
        data.put("enLatVel", Math.abs(ew.enemyData.latVel) / 8.0);
        data.put("enAdvVel", Math.abs(ew.enemyData.advVel) / 8.0);
        data.put("enDistLast10", enDistLast10 / 80.0);
        data.put("enDistLast16", enDistLast16 / 128.0);
        data.put("enDistLast35", enDistLast35 / 280.0);
        data.put("enDistLast30", enDistLast30 / 240.0);
        data.put("enDistLast60", enDistLast60 / 480.0);
        data.put("enDistLast120", enDistLast120 / 960.0);
        data.put("enAccel", (KNNModel.accel(ew.enemyData.oldLatVel, ew.enemyData.latVel) + 2.0) / 3.0);
        data.put("enShotsFired", ew.enemyData.shotsFired / 1000.0);
        data.put("enDirChangeTime", 1.0 / (1.0 + ew.enemyData.dirChangeTime));
        data.put("enDirectWallDistForward", Math.min(1.25, this.directToWallDistance(ew, true)));
        data.put("enDirectWallDistReverse", Math.min(1.15, this.directToWallDistance(ew, false)));
        data.put("enDirChangeTimePerTick", Math.min(1.0, ew.enemyData.dirChangeTime / (ew.enemyData.distance / ew.bulletVelocity())));
        data.put("enVel", (ew.enemyData.velocity + 8.0) / 16.0);
        data.put("enHeading", ew.enemyData.heading / (Math.PI * 2));
        data.put("myDistLast10", myDistLast10 / 80.0);
        data.put("myDistLast16", myDistLast16 / 128.0);
        data.put("myDistLast35", myDistLast35 / 280.0);
        data.put("myVirtuality", ew.isRealWave ? 0.0 : virtuality);
        data.put("myVel", (ew.myData.velocity + 8.0) / 16.0);
        data.put("myAbsVel", Math.abs(ew.myData.velocity) / 8.0);
        data.put("myLatVel", Math.abs(myLatVel) / 8.0);
        data.put("myAdvVel", Math.abs(myAdvVel) / 8.0);
        data.put("myAbsLatVel", Math.abs(myLatVel) / 8.0);
        data.put("myAbsAdvVel", Math.abs(myAdvVel) / 8.0);
        data.put("myAccel", myAccel / 2.0);
        data.put("myForwardPreciseMEA", ew.enemyData.meas[0]);
        data.put("myReversePreciseMEA", ew.enemyData.meas[1]);
        data.put("myTimeSinceDecel", 1.0 / (1.0 + ew.myData.timeSinceDecel));
        data.put("myTimeSinceDecelPerTick", 1.0 / (1.0 + ew.myData.timeSinceDecel / bft));
        data.put("myCurrentGF", (ew.myData.currentGF + 1.0) / 2.0);
        data.put("myDirChangeTime", 1.0 / (1.0 + ew.myData.dirChangeTime));
        data.put("myDirChangeTimePerTick", 1.0 / (1.0 + ew.myData.dirChangeTime / bft));
        data.put("myVChangeTime", 1.0 / (1.0 + ew.myData.vChangeTimer));
        data.put("meaWallAhead", maeWallAhead);
        data.put("meaWallReverse", maeWallReverse);
        data.put("orbitalWallAhead", orbitalWallAhead);
        data.put("orbitalWallReverse", orbitalWallReverse);
        data.put("myRelativeHeadingSin", Math.sin(myRelativeHeading));
        data.put("myRelativeHeadingCos", (Math.cos(myRelativeHeading) + 1.0) / 2.0);
        return data;
    }

    public double effectiveHeading(double targetHeading, double targetVelocitySign) {
        return Utils.normalAbsoluteAngle((double)(targetHeading + (targetVelocitySign == 1.0 ? 0.0 : Math.PI)));
    }

    private double directToWallDistance(Wave w, boolean forward) {
        return Math.min(1.5, this.directToWallDistance(w.enemyData, w.distance(w.enemyData), w.enemyData.effectiveHeading() + (forward ? 0.0 : Math.PI), w.bulletPower));
    }

    public double directToWallDistance(Point2D.Double targetLocation, double distance, double heading, double bulletPower) {
        int bulletTicks = DiaUtils.bulletTicksFromPower(distance, bulletPower);
        double wallDistance = 2.0;
        double sinHeading = Math.sin(heading);
        double cosHeading = Math.cos(heading);
        for (int x = 0; x < 2 * bulletTicks; ++x) {
            if (this.rect.contains(targetLocation.x + sinHeading * 8.0 * (double)x, targetLocation.y + cosHeading * 8.0 * (double)x)) continue;
            wallDistance = (double)x / (double)bulletTicks;
            break;
        }
        return wallDistance;
    }

    public static double accel(double velocity, double previousVelocity) {
        double accel = velocity - previousVelocity;
        accel = previousVelocity == 0.0 ? Math.abs(accel) : (accel *= Math.signum(previousVelocity));
        return accel;
    }

    public double orbitalWallDistance(Rectangle2D.Double rect, BotState myState, BotState enemyState, int orbitDirection, double maxEscapeAngle, boolean isForward) {
        Point2D.Double enemyProjectedLocation;
        double wallDistance;
        if (!isForward) {
            orbitDirection *= -1;
        }
        double absoluteBearing = IUtils.absoluteBearing(myState, enemyState);
        double distance = myState.distance(enemyState);
        for (wallDistance = 0.0; wallDistance < 1.5 * maxEscapeAngle + 0.01 && rect.contains(enemyProjectedLocation = IUtils.project(myState, absoluteBearing + (double)orbitDirection * wallDistance, distance)); wallDistance += 0.01) {
        }
        wallDistance /= maxEscapeAngle;
        wallDistance = Math.min(wallDistance, 1.5);
        return wallDistance;
    }

    public double[] getMea(BotState en, Point2D.Double myPos, long time) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double power = IoliteRadar.calculatePower();
        double bft = en.distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = myPos.distance(dir1);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = IUtils.absoluteBearing(dir1, myPos) + 1.5707963267948966;
            angle = this.wallSmoothing(dir1, angle, -1);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = myPos.distance(dir2);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = IUtils.absoluteBearing(dir2, myPos) - 1.5707963267948966;
            angle = this.wallSmoothing(dir2, angle, 1);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(IUtils.absoluteBearing(myPos, dir1) - en.absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(IUtils.absoluteBearing(myPos, dir2) - en.absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!this.rect.contains(IUtils.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    double accelSegment(double deltaBearing, double oldDeltaBearing, double enemyDistance) {
        int delta = (int)Math.round(5.0 * enemyDistance * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing)));
        if (delta < 0) {
            return 0.0;
        }
        if (delta > 0) {
            return 2.0;
        }
        return 1.0;
    }

    public NearestNeighborIterator<T> getNearestNeighbor(Wave w, DistanceFunction distanceFunction) {
        return this.tree.getNearestNeighborIterator(this.dataPoint(w), this.getCount(), distanceFunction);
    }

    public int getCount() {
        return Math.min(this.maxK, Math.max(5, this.tree.size() / this.kDivider));
    }
}

