/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.util.Utils;
import voidious.utils.DiaWave;
import voidious.utils.MovSim;
import voidious.utils.MovSimStat;
import voidious.utils.RobotState;
import voidious.utils.geom.Circle;
import voidious.utils.geom.LineSeg;
import voidious.utils.trace.TraceLogger;

public class DiaUtils {
    public static MovSim moveSimulator;
    public static boolean traceEnabled;
    public static final boolean IGNORE_WALLS = true;
    public static final boolean OBSERVE_WALL_HITS = false;
    protected static final double HALF_PI = 1.5707963267948966;
    protected static final double TWO_PI = Math.PI * 2;
    protected static final double BOT_HALF_WIDTH = 18.0;
    public static final double BOT_HALF_WIDTH_DIAGONAL;
    protected static TraceLogger _traceLogger;

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return DiaUtils.project(sourceLocation, Math.sin(angle), Math.cos(angle), length);
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double sinAngle, double cosAngle, double length) {
        return new Point2D.Double(sourceLocation.x + sinAngle * length, sourceLocation.y + cosAngle * length);
    }

    public static double absoluteBearing(Point2D.Double sourceLocation, Point2D.Double target) {
        return Math.atan2(target.x - sourceLocation.x, target.y - sourceLocation.y);
    }

    public static int nonZeroSign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public static double square(double d) {
        return d * d;
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static double power(double d, int exp) {
        double r = 1.0;
        for (int x = 0; x < exp; ++x) {
            r *= d;
        }
        return r;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double botWidthAimAngle(double distance) {
        return Math.abs(18.0 / distance);
    }

    public static int bulletTicksFromPower(double distance, double power) {
        return (int)Math.ceil(distance / (20.0 - 3.0 * power));
    }

    public static int bulletTicksFromSpeed(double distance, double speed) {
        return (int)Math.ceil(distance / speed);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngleRadians) {
        double angle = Utils.normalRelativeAngle((double)(goAngleRadians - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public static double rollingAverage(double previousValue, double newValue, double depth) {
        return (previousValue * depth + newValue) / (depth + 1.0);
    }

    public static double round(double d, int i) {
        long powerTen = 1L;
        for (int x = 0; x < i; ++x) {
            powerTen *= 10L;
        }
        return (double)Math.round(d * (double)powerTen) / (double)powerTen;
    }

    public static Point2D.Double nextLocation(AdvancedRobot robot) {
        if (moveSimulator == null) {
            moveSimulator = new MovSim();
        }
        MovSimStat[] next = moveSimulator.futurePos(1, robot);
        return new Point2D.Double(next[0].x, next[0].y);
    }

    public static Point2D.Double nextLocation(Point2D.Double botLocation, double velocity, double heading) {
        return new Point2D.Double(botLocation.x + Math.sin(heading) * velocity, botLocation.y + Math.cos(heading) * velocity);
    }

    public static RobotState nextLocation(Point2D.Double botLocation, double velocity, double maxVelocity, double headingRadians, double goAngleRadians, long currentTime, boolean isSmoothing, boolean ignoreWallHits, double battleFieldWidth, double battleFieldHeight) {
        double futureDistance;
        MovSim movSim = DiaUtils.getMovSim();
        double futureTurn = Utils.normalRelativeAngle((double)(goAngleRadians - headingRadians));
        if (Math.abs(futureTurn) > 1.5707963267948966) {
            futureTurn = futureTurn < 0.0 ? Math.PI + futureTurn : -1.0 * (Math.PI - futureTurn);
            futureDistance = -1000.0;
        } else {
            futureDistance = 1000.0;
        }
        int extraWallSize = 0;
        if (ignoreWallHits) {
            extraWallSize = 50000;
        }
        MovSimStat[] futureMoves = movSim.futurePos(1, (double)extraWallSize + botLocation.x, (double)extraWallSize + botLocation.y, velocity, maxVelocity, headingRadians, futureDistance, futureTurn, 10.0, (double)(extraWallSize * 2) + battleFieldWidth, (double)(extraWallSize * 2) + battleFieldHeight);
        return new RobotState(new Point2D.Double(DiaUtils.round(futureMoves[0].x - (double)extraWallSize, 4), DiaUtils.round(futureMoves[0].y - (double)extraWallSize, 4)), futureMoves[0].h, futureMoves[0].v, currentTime + 1L, isSmoothing);
    }

    public static RobotState nextPerpendicularLocation(Point2D.Double targetLocation, double absBearingRadians, double enemyVelocity, double enemyHeadingRadians, boolean clockwise, long currentTime, boolean ignoreWallHits) {
        boolean purelyPerpendicularOffset = false;
        return DiaUtils.nextPerpendicularLocation(targetLocation, absBearingRadians, enemyVelocity, enemyHeadingRadians, (double)purelyPerpendicularOffset, clockwise, currentTime, ignoreWallHits);
    }

    public static RobotState nextPerpendicularLocation(Point2D.Double targetLocation, double absBearingRadians, double enemyVelocity, double enemyHeadingRadians, double attackAngle, boolean clockwise, long currentTime, boolean ignoreWallHits) {
        return DiaUtils.nextPerpendicularWallSmoothedLocation(targetLocation, absBearingRadians, enemyVelocity, 8.0, enemyHeadingRadians, attackAngle, clockwise, currentTime, null, 0.0, 0.0, 0.0, ignoreWallHits);
    }

    public static RobotState nextPerpendicularWallSmoothedLocation(Point2D.Double targetLocation, double absBearingRadians, double enemyVelocity, double maxVelocity, double enemyHeadingRadians, double attackAngle, boolean clockwise, long currentTime, Rectangle2D.Double battleField, double bfWidth, double bfHeight, double wallStick, boolean ignoreWallHits) {
        int orientation = clockwise ? 1 : -1;
        double goAngleRadians = Utils.normalRelativeAngle((double)(absBearingRadians + (double)orientation * (1.5707963267948966 + attackAngle)));
        boolean isSmoothing = false;
        if (wallStick != 0.0 && battleField != null) {
            double smoothedAngle = DiaUtils.wallSmoothing(battleField, bfWidth, bfHeight, targetLocation, goAngleRadians, orientation, wallStick);
            if (DiaUtils.round(smoothedAngle, 4) != DiaUtils.round(goAngleRadians, 4)) {
                isSmoothing = true;
            }
            goAngleRadians = smoothedAngle;
        }
        return DiaUtils.nextLocation(targetLocation, enemyVelocity, maxVelocity, enemyHeadingRadians, goAngleRadians, currentTime, isSmoothing, bfWidth, bfHeight, ignoreWallHits);
    }

    public static RobotState nextLocation(Point2D.Double targetLocation, double enemyVelocity, double maxVelocity, double enemyHeadingRadians, double goAngleRadians, long currentTime, boolean isSmoothing, double battleFieldWidth, double battleFieldHeight, boolean ignoreWallHits) {
        double futureDistance;
        MovSim movSim = DiaUtils.getMovSim();
        double futureTurn = Utils.normalRelativeAngle((double)(goAngleRadians - enemyHeadingRadians));
        if (Math.abs(futureTurn) > 1.5707963267948966) {
            futureTurn = futureTurn < 0.0 ? Math.PI + futureTurn : -1.0 * (Math.PI - futureTurn);
            futureDistance = -1000.0;
        } else {
            futureDistance = 1000.0;
        }
        int extraWallSize = 0;
        if (ignoreWallHits) {
            extraWallSize = 50000;
        }
        MovSimStat[] futureMoves = movSim.futurePos(1, (double)extraWallSize + targetLocation.x, (double)extraWallSize + targetLocation.y, enemyVelocity, maxVelocity, enemyHeadingRadians, futureDistance, futureTurn, 10.0, (double)(extraWallSize * 2) + battleFieldWidth, (double)(extraWallSize * 2) + battleFieldHeight);
        return new RobotState(new Point2D.Double(futureMoves[0].x - (double)extraWallSize, futureMoves[0].y - (double)extraWallSize), futureMoves[0].h, futureMoves[0].v, currentTime + 1L, isSmoothing);
    }

    public static MovSim getMovSim() {
        if (moveSimulator == null) {
            moveSimulator = new MovSim();
        }
        return moveSimulator;
    }

    public static double orbitalWallDistance(Point2D.Double sourceLocation, Point2D.Double targetLocation, double bulletPower, int direction, Rectangle2D.Double fieldRect) {
        return DiaUtils.orbitalWallDistance(sourceLocation, targetLocation, bulletPower, direction, fieldRect, 1.0);
    }

    public static double orbitalWallDistance(Point2D.Double sourceLocation, Point2D.Double targetLocation, double bulletPower, int direction, Rectangle2D.Double fieldRect, double fudge) {
        double absBearing = DiaUtils.absoluteBearing(sourceLocation, targetLocation);
        double distance = sourceLocation.distance(targetLocation) * fudge;
        double maxAngleRadians = Math.asin(8.0 / (20.0 - 3.0 * bulletPower));
        double wallDistance = 2.0;
        for (int x = 0; x < 200; ++x) {
            if (fieldRect.contains(sourceLocation.x + Math.sin(absBearing + (double)direction * ((double)x / 100.0) * maxAngleRadians) * distance, sourceLocation.y + Math.cos(absBearing + (double)direction * ((double)x / 100.0) * maxAngleRadians) * distance)) continue;
            wallDistance = (double)x / 100.0;
            break;
        }
        return wallDistance;
    }

    public static double directToWallDistance(Point2D.Double targetLocation, double distance, double heading, double bulletPower, Rectangle2D.Double fieldRect) {
        int bulletTicks = DiaUtils.bulletTicksFromPower(distance, bulletPower);
        double wallDistance = 2.0;
        double sinHeading = Math.sin(heading);
        double cosHeading = Math.cos(heading);
        for (int x = 0; x < 2 * bulletTicks; ++x) {
            if (fieldRect.contains(targetLocation.x + sinHeading * 8.0 * (double)x, targetLocation.y + cosHeading * 8.0 * (double)x)) continue;
            wallDistance = (double)x / (double)bulletTicks;
            break;
        }
        return wallDistance;
    }

    public static double wallSmoothing(Rectangle2D.Double field, double bfWidth, double bfHeight, Point2D.Double startLocation, double startAngleRadians, int orientation, double wallStick) {
        double angle = startAngleRadians;
        double wallDistanceX = Math.min(startLocation.x - 18.0, bfWidth - startLocation.x - 18.0);
        double wallDistanceY = Math.min(startLocation.y - 18.0, bfHeight - startLocation.y - 18.0);
        if (wallDistanceX > wallStick && wallDistanceY > wallStick) {
            return startAngleRadians;
        }
        double testX = startLocation.x + Math.sin(angle) * wallStick;
        double testY = startLocation.y + Math.cos(angle) * wallStick;
        double testDistanceX = Math.min(testX - 18.0, bfWidth - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, bfHeight - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while ((testDistanceX < 0.0 || testDistanceY < 0.0) && g++ < 25) {
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = startLocation.x + Math.sin(angle += (double)orientation * (Math.abs(Math.acos(adjacent / wallStick)) + 5.0E-4)) * wallStick;
            testY = startLocation.y + Math.cos(angle) * wallStick;
            testDistanceX = Math.min(testX - 18.0, bfWidth - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, bfHeight - testY - 18.0);
        }
        return angle;
    }

    public static DiaWave findClosestWave(List<DiaWave> waveList, Point2D.Double targetLocation, long currentTime, boolean onlySurfable, double matchDistanceThreshold) {
        return DiaUtils.findClosestWave(waveList, targetLocation, currentTime, onlySurfable, false, matchDistanceThreshold, null);
    }

    public static DiaWave findClosestWave(List<DiaWave> waveList, Point2D.Double targetLocation, long currentTime, boolean onlySurfable, double matchDistanceThreshold, double bulletPower) {
        return DiaUtils.findClosestWave(waveList, targetLocation, currentTime, onlySurfable, false, matchDistanceThreshold, null, bulletPower);
    }

    public static DiaWave findClosestWave(List<DiaWave> waveList, Point2D.Double targetLocation, long currentTime, boolean onlySurfable, boolean onlyFiring, double matchDistanceThreshold, String botName) {
        return DiaUtils.findClosestWave(waveList, targetLocation, currentTime, onlySurfable, false, matchDistanceThreshold, null, -1.0);
    }

    public static DiaWave findClosestWave(List<DiaWave> waveList, Point2D.Double targetLocation, long currentTime, boolean onlySurfable, boolean onlyFiring, double matchDistanceThreshold, String botName, double bulletPower) {
        double closestDistance = Double.POSITIVE_INFINITY;
        DiaWave closestWave = null;
        for (DiaWave w : waveList) {
            double distanceFromTargetToWave;
            if (w.altWave || botName != null && !botName.equals(w.botName) && !botName.equals("") || !(Math.abs(distanceFromTargetToWave = w.sourceLocation.distance(targetLocation) - w.distanceTraveled(currentTime)) < matchDistanceThreshold) || !(Math.abs(distanceFromTargetToWave) < closestDistance) || onlySurfable && !(distanceFromTargetToWave > 0.0) || onlyFiring && !w.firingWave || bulletPower != -1.0 && !(Math.abs(bulletPower - w.bulletPower) < 0.001)) continue;
            closestDistance = Math.abs(distanceFromTargetToWave);
            closestWave = w;
        }
        return closestWave;
    }

    public static double standardDeviation(double[] values) {
        double avg = DiaUtils.average(values);
        double sumSquares = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sumSquares += DiaUtils.square(avg - values[x]);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double average(double[] values) {
        double sum = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sum += values[x];
        }
        return sum / (double)values.length;
    }

    public static double accel(double velocity, double previousVelocity) {
        double accel = velocity - previousVelocity;
        accel = previousVelocity == 0.0 ? Math.abs(accel) : (accel *= Math.signum(previousVelocity));
        return accel;
    }

    public static Point2D.Double translateToField(Point2D.Double p, double width, double height) {
        return new Point2D.Double(DiaUtils.limit(18.0, p.x, width - 18.0), DiaUtils.limit(18.0, p.y, height - 18.0));
    }

    public static double preciseFrontBumperOffset(Point2D.Double sourceLocation, Point2D.Double botLocation) {
        return sourceLocation.distance(botLocation) - DiaUtils.distancePointToBot(sourceLocation, botLocation);
    }

    public static Rectangle2D.Double botRect(Point2D.Double botLocation) {
        Rectangle2D.Double botRect = new Rectangle2D.Double(botLocation.x - 18.0, botLocation.y - 18.0, 36.0, 36.0);
        return botRect;
    }

    public static ArrayList<Line2D.Double> botSides(Point2D.Double botLocation) {
        ArrayList<Line2D.Double> botSides = new ArrayList<Line2D.Double>();
        botSides.add(new Line2D.Double(botLocation.x - 18.0, botLocation.y - 18.0, botLocation.x + 18.0, botLocation.y - 18.0));
        botSides.add(new Line2D.Double(botLocation.x + 18.0, botLocation.y - 18.0, botLocation.x + 18.0, botLocation.y + 18.0));
        botSides.add(new Line2D.Double(botLocation.x + 18.0, botLocation.y + 18.0, botLocation.x - 18.0, botLocation.y + 18.0));
        botSides.add(new Line2D.Double(botLocation.x - 18.0, botLocation.y + 18.0, botLocation.x - 18.0, botLocation.y - 18.0));
        return botSides;
    }

    public static double distancePointToBot(Point2D.Double sourceLocation, Point2D.Double botLocation) {
        if (sourceLocation.x > botLocation.x - 18.0 && sourceLocation.x < botLocation.x + 18.0 && sourceLocation.y > botLocation.y - 18.0 && sourceLocation.y < botLocation.y + 18.0) {
            return 0.0;
        }
        ArrayList<Line2D.Double> botSides = new ArrayList<Line2D.Double>();
        botSides.add(new Line2D.Double(botLocation.x - 18.0, botLocation.y - 18.0, botLocation.x + 18.0, botLocation.y - 18.0));
        botSides.add(new Line2D.Double(botLocation.x + 18.0, botLocation.y - 18.0, botLocation.x + 18.0, botLocation.y + 18.0));
        botSides.add(new Line2D.Double(botLocation.x + 18.0, botLocation.y + 18.0, botLocation.x - 18.0, botLocation.y + 18.0));
        botSides.add(new Line2D.Double(botLocation.x - 18.0, botLocation.y + 18.0, botLocation.x - 18.0, botLocation.y - 18.0));
        double distance = Double.POSITIVE_INFINITY;
        Iterator sideIterator = botSides.iterator();
        while (sideIterator.hasNext()) {
            distance = Math.min(distance, ((Line2D.Double)sideIterator.next()).ptSegDist(sourceLocation));
        }
        return distance;
    }

    public static ArrayList<Point2D.Double> botCorners(Point2D.Double p) {
        ArrayList<Point2D.Double> corners = new ArrayList<Point2D.Double>();
        corners.add(new Point2D.Double(p.x - 18.0, p.y - 18.0));
        corners.add(new Point2D.Double(p.x - 18.0, p.y + 18.0));
        corners.add(new Point2D.Double(p.x + 18.0, p.y - 18.0));
        corners.add(new Point2D.Double(p.x + 18.0, p.y + 18.0));
        return corners;
    }

    public static double[] preciseBotWidth(DiaWave w, ArrayList<RobotState> dangerStates) {
        double normalizeReference;
        if (w == null || dangerStates == null || dangerStates.size() == 0) {
            return null;
        }
        ArrayList<Double> aimAngles = new ArrayList<Double>();
        for (RobotState dangerState : dangerStates) {
            ArrayList<Point2D.Double> corners = DiaUtils.botCorners(dangerState.location);
            Circle waveStart = new Circle(w.sourceLocation.x, w.sourceLocation.y, w.bulletSpeed * (double)(dangerState.time - w.fireTime));
            Circle waveEnd = new Circle(w.sourceLocation.x, w.sourceLocation.y, w.bulletSpeed * (double)(dangerState.time - w.fireTime + 1L));
            for (Point2D.Double corner : corners) {
                if (!waveEnd.contains(corner) || waveStart.contains(corner)) continue;
                aimAngles.add(DiaUtils.absoluteBearing(w.sourceLocation, corner));
            }
            for (Line2D.Double side : dangerState.botSides()) {
                int x;
                LineSeg seg = new LineSeg(side.x1, side.y1, side.x2, side.y2);
                Point2D.Double[] intersects = waveStart.intersectsLineSeg(seg);
                for (x = 0; x < intersects.length; ++x) {
                    if (intersects[x] == null) continue;
                    aimAngles.add(DiaUtils.absoluteBearing(w.sourceLocation, intersects[x]));
                }
                intersects = waveEnd.intersectsLineSeg(seg);
                if (intersects == null) continue;
                for (x = 0; x < intersects.length; ++x) {
                    if (intersects[x] == null) continue;
                    aimAngles.add(DiaUtils.absoluteBearing(w.sourceLocation, intersects[x]));
                }
            }
        }
        if (aimAngles.size() == 0) {
            return new double[]{DiaUtils.absoluteBearing(w.sourceLocation, dangerStates.get((int)0).location), DiaUtils.botWidthAimAngle(dangerStates.get((int)0).location.distance(w.sourceLocation)) / Math.asin(8.0 / w.bulletSpeed)};
        }
        double minAngle = normalizeReference = ((Double)aimAngles.get(0)).doubleValue();
        double maxAngle = normalizeReference;
        Iterator anglesIterator = aimAngles.iterator();
        while (anglesIterator.hasNext()) {
            double thisAngle = (Double)anglesIterator.next();
            double normDiff = normalizeReference - thisAngle;
            while (Math.abs(normDiff) > Math.PI) {
                normDiff = normalizeReference - (thisAngle += Math.signum(normDiff) * (Math.PI * 2));
            }
            if (thisAngle > maxAngle) {
                maxAngle = thisAngle;
            }
            if (!(thisAngle < minAngle)) continue;
            minAngle = thisAngle;
        }
        double centerAngle = (maxAngle + minAngle) / 2.0;
        double bandwidth = maxAngle - centerAngle;
        return new double[]{centerAngle, bandwidth};
    }

    public static double[] preciseBotWidthForTick(DiaWave w, Point2D.Double location, long time) {
        ArrayList<Double> aimAngles = new ArrayList<Double>();
        double radius = w.bulletSpeed * (double)(time - w.fireTime);
        double nextRadius = radius + w.bulletSpeed;
        double nextRadiusPlusHalfDiag = nextRadius + BOT_HALF_WIDTH_DIAGONAL;
        if (Math.abs(location.x - w.sourceLocation.x) - 18.0 > nextRadius) {
            return null;
        }
        if (Math.abs(location.y - w.sourceLocation.y) - 18.0 > nextRadius) {
            return null;
        }
        if (location.distanceSq(w.sourceLocation) > nextRadiusPlusHalfDiag * nextRadiusPlusHalfDiag) {
            return null;
        }
        ArrayList<Point2D.Double> corners = DiaUtils.botCorners(location);
        Circle waveStart = new Circle(w.sourceLocation.x, w.sourceLocation.y, radius);
        Circle waveEnd = new Circle(w.sourceLocation.x, w.sourceLocation.y, nextRadius);
        for (Point2D.Double corner : corners) {
            if (!waveEnd.contains(corner) || waveStart.contains(corner)) continue;
            aimAngles.add(DiaUtils.absoluteBearing(w.sourceLocation, corner));
        }
        for (Line2D.Double side : DiaUtils.botSides(location)) {
            int x;
            LineSeg seg = new LineSeg(side.x1, side.y1, side.x2, side.y2);
            Point2D.Double[] intersects = waveStart.intersectsLineSeg(seg);
            for (x = 0; x < intersects.length; ++x) {
                if (intersects[x] == null) continue;
                aimAngles.add(DiaUtils.absoluteBearing(w.sourceLocation, intersects[x]));
            }
            intersects = waveEnd.intersectsLineSeg(seg);
            if (intersects == null) continue;
            for (x = 0; x < intersects.length; ++x) {
                if (intersects[x] == null) continue;
                aimAngles.add(DiaUtils.absoluteBearing(w.sourceLocation, intersects[x]));
            }
        }
        if (aimAngles.size() == 0) {
            return null;
        }
        double normalizeReference = w.absBearing;
        double minAngle = Double.POSITIVE_INFINITY;
        double maxAngle = Double.NEGATIVE_INFINITY;
        Iterator anglesIterator = aimAngles.iterator();
        while (anglesIterator.hasNext()) {
            double thisAngle = (Double)anglesIterator.next();
            double normDiff = normalizeReference - thisAngle;
            while (Math.abs(normDiff) > Math.PI) {
                normDiff = normalizeReference - (thisAngle += Math.signum(normDiff) * (Math.PI * 2));
            }
            if (thisAngle > maxAngle) {
                maxAngle = thisAngle;
            }
            if (!(thisAngle < minAngle)) continue;
            minAngle = thisAngle;
        }
        return new double[]{minAngle, maxAngle};
    }

    public static double distanceSq(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int x = 0; x < p1.length; ++x) {
            double z = p1[x] - p2[x];
            sum += z * z;
        }
        return sum;
    }

    public static double distanceSq(double[] p1, double[] p2, double[] weights) {
        double sum = 0.0;
        for (int x = 0; x < p1.length; ++x) {
            double z = (p1[x] - p2[x]) * weights[x];
            sum += z * z;
        }
        return sum;
    }

    public static double manhattanDistance(double[] p1, double[] p2, double[] weights) {
        double sum = 0.0;
        for (int x = 0; x < p1.length; ++x) {
            sum += Math.abs(p1[x] - p2[x]) * weights[x];
        }
        return sum;
    }

    public static double findLongestDistance(double[][] points, double[] testPoint, double[] weights, boolean manhattan) {
        double longestDistance = 0.0;
        for (int x = 0; x < points.length; ++x) {
            double distance = manhattan ? DiaUtils.manhattanDistance(points[x], testPoint, weights) : DiaUtils.distanceSq(points[x], testPoint, weights);
            if (!(distance > longestDistance)) continue;
            longestDistance = distance;
        }
        return longestDistance;
    }

    public static double findAndReplaceLongestDistance(double[][] points, double[] nearestDistances, double[] newPoint, double newPointDistance) {
        double longestDistance = 0.0;
        double newLongestDistance = 0.0;
        int longestIndex = 0;
        for (int x = 0; x < points.length; ++x) {
            double distance = nearestDistances[x];
            if (distance > longestDistance) {
                newLongestDistance = longestDistance;
                longestDistance = distance;
                longestIndex = x;
                continue;
            }
            if (!(distance > newLongestDistance)) continue;
            newLongestDistance = distance;
        }
        points[longestIndex] = newPoint;
        nearestDistances[longestIndex] = newPointDistance;
        return Math.max(newLongestDistance, newPointDistance);
    }

    public static double[][] nearestNeighbors(double[][] dataSet, double[] searchPoint, double[] weights, int numNeighbors, boolean manhattan) {
        if (dataSet.length <= numNeighbors) {
            return dataSet;
        }
        double[][] closestPoints = new double[numNeighbors][searchPoint.length];
        double[] nearestDistances = new double[numNeighbors];
        for (int y = 0; y < numNeighbors; ++y) {
            closestPoints[y] = dataSet[y];
            nearestDistances[y] = manhattan ? DiaUtils.manhattanDistance(closestPoints[y], searchPoint, weights) : DiaUtils.distanceSq(closestPoints[y], searchPoint, weights);
        }
        double closestDistanceThreshold = DiaUtils.findLongestDistance(closestPoints, searchPoint, weights, manhattan);
        for (int y = numNeighbors; y < dataSet.length; ++y) {
            double[] point = dataSet[y];
            double thisDistance = manhattan ? DiaUtils.manhattanDistance(searchPoint, point, weights) : DiaUtils.distanceSq(searchPoint, point, weights);
            if (!(thisDistance < closestDistanceThreshold)) continue;
            closestDistanceThreshold = DiaUtils.findAndReplaceLongestDistance(closestPoints, nearestDistances, point, thisDistance);
        }
        return closestPoints;
    }

    public static double[] weightedPoint(double[] p, double[] weights) {
        double[] wp = new double[p.length];
        for (int x = 0; x < wp.length; ++x) {
            wp[x] = p[x] * weights[x];
        }
        return wp;
    }

    public static String pointAsString(double[] point, int round) {
        String str = "";
        for (int x = 0; x < point.length; ++x) {
            if (x != 0) {
                str = str + ", ";
            }
            str = str + DiaUtils.round(point[x], round);
        }
        return str;
    }

    public static void log(String className, String methodName, String params, boolean entering) {
        if (traceEnabled) {
            _traceLogger.log(className, methodName, params, entering);
        }
    }

    public static void initTrace(String[] include, String[] exclude) {
        if (traceEnabled) {
            _traceLogger = new TraceLogger(include, exclude);
        }
    }

    static {
        traceEnabled = false;
        BOT_HALF_WIDTH_DIAGONAL = Math.sqrt(648.0);
    }
}

