/*
 * Decompiled with CFR 0.152.
 */
package labg;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.HashMap;
import labg.tactics.TacticalEngine;
import labg.util.EvolutionManager;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Cataclysm
extends AdvancedRobot {
    TacticalEngine tacEng;
    static EvolutionManager evoMan = new EvolutionManager();
    static HashMap enemies = new HashMap();
    private boolean enabled;
    private int howOften;
    private int howManyValues;
    private double x;
    private double y;
    public double currHeading = 0.0;
    public double prevHeading = 0.0;

    public void run() {
        Closeable fis;
        if (this.getRoundNum() == 0) {
            File enFile;
            File obFile = this.getDataFile("evoObject.dat");
            if (obFile.exists()) {
                try {
                    fis = new FileInputStream(obFile);
                    ObjectInputStream ois = new ObjectInputStream((InputStream)fis);
                    evoMan = (EvolutionManager)ois.readObject();
                    System.out.println("Read in evolution object file");
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            if ((enFile = this.getDataFile("enObject.dat")).exists()) {
                try {
                    FileInputStream fis2 = new FileInputStream(enFile);
                    ObjectInputStream ois = new ObjectInputStream(fis2);
                    enemies = (HashMap)ois.readObject();
                    System.out.println("Read in enemies object file");
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        try {
            File settingsFile = this.getDataFile("config.dat");
            fis = new FileReader(settingsFile);
            BufferedReader bis = new BufferedReader((Reader)fis);
            int tmp = Integer.parseInt(bis.readLine());
            this.enabled = tmp == 1;
            this.howOften = Integer.parseInt(bis.readLine());
            this.howManyValues = Integer.parseInt(bis.readLine());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        evoMan.setBot(this);
        evoMan.setValues(this.enabled, this.howOften, this.howManyValues);
        this.tacEng = new TacticalEngine(this, evoMan, enemies);
        this.setColors(Color.red, Color.gray, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.x = super.getX();
            this.y = super.getY();
            this.updateValues();
            this.tacEng.compute();
            this.move();
            this.target();
            this.shoot();
            this.execute();
        }
    }

    public void move() {
        this.tacEng.getMovementStrategy().move();
    }

    public void target() {
        this.tacEng.getTargetingStrategy().target();
    }

    public void shoot() {
        this.tacEng.getShootingStrategy().shoot();
    }

    private void updateValues() {
        this.prevHeading = this.currHeading;
        this.currHeading = this.getHeadingRadians();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.tacEng.onScannedRobot(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.tacEng.onHitByBullet(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.tacEng.onBulletHitBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.tacEng.onBulletHit(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.tacEng.onBulletMissed(e);
    }

    public void onDeath(DeathEvent e) {
        this.tacEng.onDeath(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.tacEng.onHitRobot(e);
    }

    public void onHitWall(HitWallEvent e) {
        this.tacEng.onHitWall(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.tacEng.onRobotDeath(e);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.tacEng.onSkippedTurn(e);
    }

    public void onWin(WinEvent e) {
        this.tacEng.onWin(e);
    }

    public Point2D.Double guessPosition(long when) {
        double diff = when - this.getTime();
        double newX = this.getX() + Math.cos(this.getHeadingRadians()) * this.getVelocity() * diff;
        double newY = this.getY() + Math.sin(this.getHeadingRadians()) * this.getVelocity() * diff;
        return new Point2D.Double(newX, newY);
    }

    public Point2D.Double guessCircularPosition(long when) {
        double diff = when - this.getTime();
        double radius = this.getVelocity() / (this.getHeadingRadians() - this.prevHeading);
        double tothead = diff * (this.getHeadingRadians() - this.prevHeading);
        double newY = this.getY() + Math.sin(this.getHeadingRadians() + tothead) * radius - Math.sin(this.getHeadingRadians()) * radius;
        double newX = this.getX() + Math.cos(this.getHeadingRadians()) * radius - Math.cos(this.getHeadingRadians() + tothead) * radius;
        return new Point2D.Double(newX, newY);
    }
}

