/*
 * Decompiled with CFR 0.152.
 */
package labg.movement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import labg.Cataclysm;
import labg.movement.GravPoint;
import labg.movement.MovementStrategy;
import labg.util.Enemy;
import labg.util.EnemyBullet;
import labg.util.EvolutionManager;
import labg.util.Geometry;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class QuietCornerMovementStrategy2
extends MovementStrategy {
    private static final String xDist1 = "xDist1";
    private static final String xDist2 = "xDist2";
    private static final String yDist1 = "yDist1";
    private static final String yDist2 = "yDist2";
    private static final String wallRepulse = "wallRepulse";
    private static final String gravPower1 = "gravPower1";
    private static final String gravPower2 = "gravPower2";
    private static final String gravPower3 = "gravPower3";
    private static final String gravPower4 = "gravPower4";
    private static final String gravPower5 = "gravPower5";
    private static final String gravPower6 = "gravPower6";
    private static final String centerPower = "centerPower";
    private static final String cornerAttractor = "cornerAttractor";
    Cataclysm myBot;
    HashMap enemies;
    EvolutionManager evoMan;
    Vector gravPoints;
    Vector antiGravPoints;
    Vector gotoPoints;
    Vector bullets;
    Random numGen;
    double rand = 0.0;
    boolean arrived = false;
    double counter = 0.0;
    double sign = 1.0;
    double previousX;
    double previousY;
    double previousRandX;
    double previousRandY;
    double prevRandAng;
    double randX = 0.0;
    double randY = 0.0;
    boolean randArrived = true;
    int currClosestWall = 0;
    double energy = 0.0;
    int prevBestPoint = 0;
    int bestPoint = 0;
    int count = 0;
    Vector drawPoints;

    public QuietCornerMovementStrategy2(Cataclysm myBot, HashMap enemies, EvolutionManager evoMan) {
        super(myBot);
        this.myBot = myBot;
        this.enemies = enemies;
        this.evoMan = evoMan;
        evoMan.addVariable(xDist1, 150.0, 10.0, 400.0);
        evoMan.addVariable(xDist2, -150.0, -400.0, -10.0);
        evoMan.addVariable(yDist1, 150.0, 10.0, 400.0);
        evoMan.addVariable(yDist2, -150.0, -400.0, -10.0);
        evoMan.addVariable(wallRepulse, 10000.0, 10.0, 100000.0);
        evoMan.addVariable(gravPower1, -2500.0, -10000.0, -100.0);
        evoMan.addVariable(gravPower2, -10000.0, -10000.0, -100.0);
        evoMan.addVariable(gravPower3, -1000.0, -5000.0, -100.0);
        evoMan.addVariable(gravPower4, -1000.0, -5000.0, -100.0);
        evoMan.addVariable(gravPower5, 500.0, 100.0, 1000.0);
        evoMan.addVariable(gravPower6, 500.0, 100.0, 1000.0);
        evoMan.addVariable(centerPower, -5000.0, -5000.0, -100.0);
        this.numGen = new Random();
        this.gravPoints = new Vector();
        this.gotoPoints = new Vector();
        this.antiGravPoints = new Vector();
        this.bullets = new Vector();
        int[] ap0 = new int[]{1, 3, 4, 7};
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 5;
        nArray[3] = 2;
        int[] ap1 = nArray;
        int[] ap2 = new int[]{1, 5, 6, 3};
        int[] nArray2 = new int[4];
        nArray2[1] = 7;
        nArray2[2] = 6;
        nArray2[3] = 2;
        int[] ap3 = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        int[] ap4 = nArray3;
        int[] ap5 = new int[]{1, 2};
        int[] ap6 = new int[]{2, 3};
        int[] nArray4 = new int[2];
        nArray4[1] = 3;
        int[] ap7 = nArray4;
        Point p0 = new Point(136.0, 136.0, 1.0, ap0);
        Point p1 = new Point(136.0, myBot.getBattleFieldHeight() - 136.0, 1.0, ap1);
        Point p2 = new Point(myBot.getBattleFieldWidth() - 136.0, myBot.getBattleFieldHeight() - 136.0, 1.0, ap2);
        Point p3 = new Point(myBot.getBattleFieldWidth() - 136.0, 136.0, 1.0, ap3);
        Point p4 = new Point(136.0, myBot.getBattleFieldHeight() / 2.0, 3.0, ap4);
        Point p5 = new Point(myBot.getBattleFieldWidth() / 2.0, myBot.getBattleFieldHeight() - 136.0, 3.0, ap5);
        Point p6 = new Point(myBot.getBattleFieldWidth() - 136.0, myBot.getBattleFieldHeight() / 2.0, 3.0, ap6);
        Point p7 = new Point(myBot.getBattleFieldWidth() / 2.0, 136.0, 3.0, ap7);
        this.gotoPoints.add(p0);
        this.gotoPoints.add(p1);
        this.gotoPoints.add(p2);
        this.gotoPoints.add(p3);
        this.gotoPoints.add(p4);
        this.gotoPoints.add(p5);
        this.gotoPoints.add(p6);
        this.gotoPoints.add(p7);
    }

    public void move() {
        this.calcBestPoint();
        this.antiGravMove();
    }

    private void antiGravMove() {
        this.antiGravPoints = this.generateAntiGravPoints();
        double xforce = 0.0;
        double yforce = 0.0;
        int i = 0;
        while (i < this.antiGravPoints.size()) {
            double range;
            GravPoint p = (GravPoint)this.antiGravPoints.elementAt(i);
            double force = !p.oneMinus ? p.power / Math.pow(Geometry.getRange(this.myBot.getX(), this.myBot.getY(), p.x, p.y), p.raiseTo) : ((range = Geometry.getRange(this.myBot.getX(), this.myBot.getY(), p.x, p.y)) > this.myBot.getBattleFieldWidth() / 10.0 ? 1.0 - p.power / Math.pow(range, p.raiseTo) : 0.0);
            double ang = Geometry.normaliseBearing(1.5707963267948966 - Math.atan2(this.myBot.getY() - p.y, this.myBot.getX() - p.x));
            double tmpXForce = Math.sin(ang) * force;
            double tmpYForce = Math.cos(ang) * force;
            boolean tag = false;
            if (this.myBot.getX() < 40.0 && tmpXForce > 0.0) {
                tmpXForce = 0.0;
            }
            if (this.myBot.getX() > this.myBot.getBattleFieldWidth() - 40.0 && tmpXForce < 0.0) {
                tmpXForce = 0.0;
            }
            if (this.myBot.getY() < 40.0 && tmpYForce > 0.0) {
                tmpYForce = 0.0;
            }
            if (this.myBot.getY() > this.myBot.getBattleFieldHeight() - 40.0 && tmpYForce < 0.0) {
                tmpYForce = 0.0;
            }
            xforce += tmpXForce;
            yforce += tmpYForce;
            ++i;
        }
        Geometry.goTo(this.myBot, this.myBot.getX() - xforce, this.myBot.getY() - yforce);
    }

    private Vector generateAntiGravPoints() {
        this.removeExpiredAntiGravPointsAndBullets();
        Collection e2 = this.enemies.values();
        Iterator it2 = e2.iterator();
        long sinceLastSeen = 99999999L;
        while (it2.hasNext()) {
            Enemy tmp = (Enemy)it2.next();
            if (!tmp.isAlive || tmp.timeLastSeen >= sinceLastSeen || tmp.timeLastSeen <= 0L) continue;
            sinceLastSeen = tmp.timeLastSeen;
        }
        GravPoint bl = new GravPoint(0.0, 0.0, -500000 * this.myBot.getOthers(), 1L, 3.0);
        this.antiGravPoints.add(bl);
        GravPoint br = new GravPoint(this.myBot.getBattleFieldWidth(), 0.0, -500000 * this.myBot.getOthers(), 1L, 3.0);
        this.antiGravPoints.add(br);
        GravPoint tl = new GravPoint(0.0, this.myBot.getBattleFieldHeight(), -500000 * this.myBot.getOthers(), 1L, 3.0);
        this.antiGravPoints.add(tl);
        GravPoint tr = new GravPoint(this.myBot.getBattleFieldWidth(), this.myBot.getBattleFieldHeight(), -500000 * this.myBot.getOthers(), 1L, 3.0);
        this.antiGravPoints.add(tr);
        if (this.enemies.size() > 0) {
            Collection e = this.enemies.values();
            Iterator it = e.iterator();
            GravPoint corner = new GravPoint(((Point)this.gotoPoints.get((int)this.bestPoint)).x, ((Point)this.gotoPoints.get((int)this.bestPoint)).y, -5000 * this.myBot.getOthers(), 1L, 3.0, true);
            this.antiGravPoints.add(corner);
            boolean index = false;
            while (it.hasNext()) {
                Enemy en = (Enemy)it.next();
                if (!en.isAlive) continue;
                if (en.distance < this.myBot.getBattleFieldWidth() / 3.0) {
                    GravPoint p = new GravPoint(en.xPos, en.yPos, this.evoMan.getVariable(gravPower1) * (double)this.myBot.getOthers(), 1L, 2.0);
                    this.antiGravPoints.add(p);
                }
                if (!en.energyChanged()) continue;
                double timeDiff = en.timeLastSeen - en.prevTimeLastSeen;
                double vel = 20.0 - 3.0 * en.energyChangedAmount;
                double heading = Geometry.normaliseHeading(this.myBot.getHeadingRadians() + en.currBearing);
                EnemyBullet newBull = new EnemyBullet(this.myBot, this.evoMan, heading, this.myBot.getHeadingRadians(), vel, en.xPosAdjust, en.yPosAdjust, this.myBot.getX(), this.myBot.getY(), (en.timeLastSeen + en.prevTimeLastSeen) / 2L);
                this.bullets.add(newBull);
            }
        }
        int j = 0;
        while (j < this.bullets.size()) {
            EnemyBullet temp = (EnemyBullet)this.bullets.get(j);
            GravPoint[] gpa = temp.getGravPoints();
            int k = 0;
            while (k < gpa.length) {
                if (gpa[k] != null) {
                    this.antiGravPoints.add(gpa[k]);
                }
                ++k;
            }
            ++j;
        }
        return this.antiGravPoints;
    }

    private Vector generateGravPoints() {
        if (this.enemies.size() > 0) {
            Collection e = this.enemies.values();
            Iterator it = e.iterator();
            while (it.hasNext()) {
                Enemy en = (Enemy)it.next();
                if (!en.isAlive) continue;
                GravPoint p = new GravPoint(en.xPos, en.yPos, 1000.0, 1L, 2.0);
                this.gravPoints.add(p);
            }
        }
        return this.gravPoints;
    }

    private void calcBestPoint() {
        GravPoint p;
        this.removeExpiredGravPoints();
        this.gravPoints = this.generateGravPoints();
        double xforce = 0.0;
        double yforce = 0.0;
        double totalForce = 0.0;
        double bestPointForce = 0.0;
        double force = 0.0;
        double ang = 0.0;
        double currentMin = 9999999.0;
        int pointIndex = 0;
        xforce = 0.0;
        yforce = 0.0;
        totalForce = 0.0;
        int i = 0;
        while (i < this.gravPoints.size()) {
            p = (GravPoint)this.gravPoints.elementAt(i);
            ((Point)this.gotoPoints.get((int)this.bestPoint)).force = bestPointForce += p.power / Math.pow(Geometry.getRange(((Point)this.gotoPoints.get((int)this.bestPoint)).x, ((Point)this.gotoPoints.get((int)this.bestPoint)).y, p.x, p.y), p.raiseTo) * ((Point)this.gotoPoints.get((int)this.bestPoint)).scaleFactor;
            ++i;
        }
        int j = 0;
        while (j < ((Point)this.gotoPoints.get((int)this.bestPoint)).neighbours.length) {
            xforce = 0.0;
            yforce = 0.0;
            totalForce = 0.0;
            int neighbourIndex = ((Point)this.gotoPoints.get((int)this.bestPoint)).neighbours[j];
            int i2 = 0;
            while (i2 < this.gravPoints.size()) {
                p = (GravPoint)this.gravPoints.elementAt(i2);
                ((Point)this.gotoPoints.get((int)neighbourIndex)).force = totalForce += p.power / Math.pow(Geometry.getRange(((Point)this.gotoPoints.get((int)neighbourIndex)).x, ((Point)this.gotoPoints.get((int)neighbourIndex)).y, p.x, p.y), p.raiseTo) * ((Point)this.gotoPoints.get((int)neighbourIndex)).scaleFactor;
                ++i2;
            }
            if (totalForce < currentMin) {
                currentMin = totalForce;
                pointIndex = neighbourIndex;
            }
            ++j;
        }
        if (!(((Point)this.gotoPoints.get((int)this.bestPoint)).force / ((Point)this.gotoPoints.get((int)pointIndex)).force <= 1.5)) {
            this.bestPoint = pointIndex;
        }
    }

    private void removeExpiredGravPoints() {
        int i = 0;
        while (i < this.gravPoints.size()) {
            ((GravPoint)this.gravPoints.get(i)).decTimeLeft();
            if (((GravPoint)this.gravPoints.get((int)i)).timeLeft == 0L) {
                this.gravPoints.removeElementAt(i);
            }
            ++i;
        }
    }

    private void removeExpiredAntiGravPointsAndBullets() {
        int i = 0;
        while (i < this.antiGravPoints.size()) {
            ((GravPoint)this.antiGravPoints.get(i)).decTimeLeft();
            if (((GravPoint)this.antiGravPoints.get((int)i)).timeLeft == 0L) {
                this.antiGravPoints.removeElementAt(i);
            }
            ++i;
        }
        int j = 0;
        while (j < this.bullets.size()) {
            int expired = ((EnemyBullet)this.bullets.get(j)).updatePosition();
            if (expired == -1) {
                this.bullets.removeElementAt(j);
            }
            ++j;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }

    private class Point {
        public double x;
        public double y;
        public double force = 0.0;
        public double scaleFactor;
        public int[] neighbours;

        public Point(double x, double y, double scaleFactor, int[] neighbours) {
            this.x = x;
            this.y = y;
            this.scaleFactor = scaleFactor;
            this.neighbours = neighbours;
        }
    }
}

