/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import pedersen.physics.DynamicHeading;
import pedersen.physics.DynamicHeadingImpl;
import pedersen.systems.ScanningMethod;

public abstract class ScanningMethodBase
implements ScanningMethod {
    private DynamicHeading scanner = null;
    protected long scanIndex = 0L;

    protected void initializeScanner(double newHeading) {
        this.scanner = new DynamicHeadingImpl(newHeading);
        ++this.scanIndex;
    }

    protected double getRelativeRotation(double bearingToTarget, double scanAzimuth) {
        double sweepAngle = this.scanner.getHeading() > bearingToTarget ? -scanAzimuth : scanAzimuth;
        this.scanner.setAbsoluteTargetHeading(bearingToTarget + sweepAngle);
        double projectedHeading = this.scanner.projectHeading(0.7853981633974483);
        return this.scanner.getRelativeAngle(projectedHeading);
    }

    public void resetScanCycle() {
        this.scanIndex = 0L;
    }
}

