/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.IDrawable;
import execution.Message;
import execution.MessageRouter;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import robocode.robotinterfaces.IPaintEvents;
import sim.Data;

public final class Painter
implements IPaintEvents {
    private ArrayList<IDrawable> _drawable = new ArrayList();
    private ArrayList<Shape> _shape = new ArrayList();
    private Graphics2D _graphics;
    private Graphics2D _graphicsPrevious;
    private MessageRouter _router;

    public Painter(MessageRouter router) {
        this._router = router;
    }

    public final void Register(IDrawable shape) {
        if (!this._drawable.contains(shape)) {
            this._drawable.add(shape);
        }
    }

    public final void Register(Shape shape) {
        if (!this._shape.contains(shape)) {
            this._shape.add(shape);
        }
    }

    public final void UnRegister(IDrawable shape) {
        this._drawable.remove(shape);
    }

    public final void UnRegister(Shape shape) {
        this._shape.remove(shape);
    }

    public final void Draw() {
        if (this._graphics != null) {
            for (IDrawable iDrawable : this._drawable) {
                iDrawable.Draw(this._graphics);
            }
            for (Shape shape : this._shape) {
                this._graphics.draw(shape);
            }
        } else if (Data.Battle.Time > 0L) {
            this._router.prepare(Message.Kind.PaintDisabled).send();
        }
        this._graphicsPrevious = this._graphics;
        this._graphics = null;
    }

    public void onPaint(Graphics2D e) {
        this._graphics = e;
        if (this._graphicsPrevious == null) {
            this._router.prepare(Message.Kind.PaintEnabled).send();
        }
        this._router.prepare(Message.Kind.OnPaint).send();
    }
}

