/*
 * Decompiled with CFR 0.152.
 */
package grav;

import grav.GravPoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import math.Vect2d;
import sim.Bot;
import sim.Data;

public class GravLine
extends GravPoint {
    public Line2D.Double Line;

    public GravLine(Line2D.Double line, double strength, double dropoffFactor) {
        super(strength, dropoffFactor, new Point2D.Double());
        this.Line = line;
    }

    public static void NearestPointOnLine(Line2D.Double line, long time, Point2D.Double destination) {
        GravLine.NearestPointOnLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), time, destination);
    }

    public static void NearestPointOnLine(double ax, double ay, double bx, double by, long time, Point2D.Double destination) {
        double ab2;
        double aby;
        double py;
        double apy;
        double abx;
        Bot robot = Data.Robots.Self;
        double px = robot.Position.getX();
        double apx = px - ax;
        double ap_ab = apx * (abx = bx - ax) + (apy = (py = robot.Position.getY()) - ay) * (aby = by - ay);
        double t = ap_ab / (ab2 = abx * abx + aby * aby);
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        destination.setLocation(ax + abx * t, ay + aby * t);
    }

    @Override
    public Vect2d GetEffectiveGravity(long time) {
        GravLine.NearestPointOnLine(this.Line, time, this.Location);
        return super.GetEffectiveGravity(time);
    }

    @Override
    public void Draw(Graphics2D e) {
        super.Draw(e);
        e.setColor(Color.PINK);
    }
}

