/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.EFDUtils;
import java.awt.geom.Point2D;
import robocode.ScannedRobotEvent;

public class LogEntry {
    Point2D.Double position;
    double heading;
    double energy;
    double velocity;
    Point2D.Double enemyPosition;
    double enemyHeading;
    double enemyEnergy;
    double enemyVelocity;
    long time;

    public LogEntry(ScannedRobotEvent e, AdvancedEFD r) {
        this.position = new Point2D.Double(r.getX(), r.getY());
        this.heading = r.getHeadingRadians();
        this.energy = r.getEnergy();
        this.velocity = r.getVelocity();
        this.enemyPosition = EFDUtils.projectPoint(this.position, r.absBearing, e.getDistance());
        this.enemyHeading = e.getHeadingRadians();
        this.enemyEnergy = e.getEnergy();
        this.enemyVelocity = e.getVelocity();
        this.time = r.getTime();
    }

    public double getEnemyDistance() {
        return this.position.distance(this.enemyPosition);
    }

    public double getEnemyLateralVelocity() {
        return -1.0 * this.enemyVelocity * Math.sin(this.enemyHeading - EFDUtils.absoluteAngle(this.position, this.enemyPosition));
    }

    public double getEnemyAdvancingVelocity() {
        return -1.0 * this.enemyVelocity * Math.cos(this.enemyHeading - EFDUtils.absoluteAngle(this.position, this.enemyPosition));
    }

    public double getEnemyDirection() {
        return Math.signum(this.getEnemyLateralVelocity());
    }

    public double getAdvancingVelocity() {
        return -1.0 * this.velocity * Math.cos(this.heading - EFDUtils.absoluteAngle(this.enemyPosition, this.position));
    }

    public double getLateralVelocity() {
        return -1.0 * this.velocity * Math.sin(this.heading - EFDUtils.absoluteAngle(this.enemyPosition, this.position));
    }

    public double getDirection() {
        return Math.signum(this.getLateralVelocity());
    }

    public double getAbsBearing() {
        return EFDUtils.absoluteAngle(this.position, this.enemyPosition);
    }
}

