/*
 * Decompiled with CFR 0.152.
 */
package demetrix;

import demetrix.info.EnemyInfo;
import demetrix.info.HitStats;
import demetrix.info.SelfInfo;
import demetrix.info.Wave;
import demetrix.misc.Const;
import demetrix.misc.Physics;
import demetrix.movement.RM;
import demetrix.movement.RTM;
import demetrix.movement.Ram;
import demetrix.movement.SemiRam;
import demetrix.movement.SnG;
import demetrix.movement.Step;
import demetrix.targeting.LCT;
import demetrix.targeting.PMT;
import demetrix.targeting.Shoot;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ForceMajeure
extends AdvancedRobot {
    private static final double PI = Math.PI;
    private static final double OVERLAP_COEF = 1.8;
    private static final long LOCK_TIMEOUT = 1L;
    private static Const constants;
    private static final int SnG = 0;
    private static final int RTM = 1;
    private static final int RM = 2;
    private static final int SEMIRAM = 3;
    private static final int RAM = 4;
    private static final int LASTMOVE_STATS = 2;
    private static int currentMovement;
    private static HitStats hitStats;
    private SelfInfo self;
    private long currentTime;
    private Point2D Pos;
    private double energy;
    private Shoot shoot;
    private LCT LCTgun;
    private PMT PMTgun;
    private Wave selfWaves;
    private SnG SnGbhv;
    private RTM RTMbhv;
    private RM RMbhv;
    private SemiRam SemiRamBhv;
    private Ram RamBhv;
    private EnemyInfo enemy;
    private Wave enemyWaves;

    public void run() {
        constants = new Const(this);
        this.setColors(Const.ROBOT_COLOR, Const.GUN_COLOR, Const.RADAR_COLOR);
        if (this.getOthers() > 1) {
            this.out.println("This bot participates one-on-one battles only!!!");
            return;
        }
        this.setEventPriority("BulletHitEvent", 90);
        this.setEventPriority("HitByBulletEvent", 90);
        this.setEventPriority("HitRobotEvent", 90);
        this.setEventPriority("ScannedRobotEvent", 85);
        this.setEventPriority("BulletHitBulletEvent", 60);
        this.setEventPriority("BulletMissedEvent", 60);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.enemy.resetScanTime();
        this.SnGbhv.initiate();
        this.RTMbhv.initiate();
        this.RMbhv.initiate();
        while (true) {
            this.self.setInfo(this);
            this.currentTime = this.self.getTime();
            this.energy = this.self.getEnergy();
            this.Pos.setLocation(this.self.getPosition());
            if (this.enemy.isEnemyShoots()) {
                this.enemyWaves.addWave(this.enemy.getPreviousPosition(), this.enemy.getLastShootTime(), this.enemy.getShootBulletPower());
            }
            if (this.selfWaves.removeWaveForDistance(this.enemy.getPosition(), this.currentTime) > 0.0) {
                this.self.bulletHitsOneByOne = 0;
            }
            hitStats.onShoot(currentMovement, this.enemyWaves.removeWaveForDistance(this.Pos, this.currentTime));
            this.doMovement();
            this.doScanner();
            this.doFire();
            this.doTargeting();
            this.execute();
        }
    }

    private final void doMovement() {
        Step step = null;
        currentMovement = this.manageMovementType();
        switch (currentMovement) {
            case 0: {
                step = this.SnGbhv.execute(this.self, this.enemy);
                break;
            }
            case 1: {
                step = this.RTMbhv.execute(this.self, this.enemy);
                break;
            }
            case 2: {
                step = this.RMbhv.execute(this.self, this.enemy);
                break;
            }
            case 3: {
                step = this.SemiRamBhv.execute(this.self, this.enemy);
                break;
            }
            case 4: {
                step = this.RamBhv.execute(this.self, this.enemy);
                break;
            }
        }
        this.setMove(step);
    }

    private final int manageMovementType() {
        int bestMove = hitStats.getReasonableSegment();
        if (this.enemy.getEnergy() < 0.4 && this.enemyWaves.getWavesNumber() == 0) {
            return 4;
        }
        if (this.enemy.getDistance() < 100.0 && this.self.getEnergy() - this.enemy.getEnergy() > 30.0) {
            return 4;
        }
        if (this.self.getTime() - this.enemy.getLastShootTime() > (long)((int)Math.ceil((double)3 * Physics.getGunHeat(3) / Const.GUN_COOLING_RATE)) && this.self.getEnergy() > this.enemy.getEnergy() / (double)3 && this.enemy.getDistance() > 350.0) {
            return 3;
        }
        if (this.self.getEnergy() - this.enemy.getEnergy() > 40.0 && this.enemy.getDistance() > 300.0 && hitStats.getRatio(bestMove) > ForceMajeure.hitStats.PERFECTSTATS) {
            return 3;
        }
        return bestMove;
    }

    private final void setMove(Step step) {
        double distance = this.Pos.distance(step.getPoint());
        if (distance < 0.1) {
            return;
        }
        double dx = step.getPoint().getX() - this.Pos.getX();
        double dy = step.getPoint().getY() - this.Pos.getY();
        double pointBearing = Math.atan2(dx, dy);
        if (step.getDirection() == -1) {
            pointBearing += Math.PI;
        }
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(pointBearing - this.getHeadingRadians())));
        this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 40.0 ? 0.0 : step.getVelocity());
        this.setAhead((double)step.getDirection() * distance);
    }

    private final void doScanner() {
        double angle = this.currentTime - this.enemy.getScanTime() >= 1L ? Math.PI * 2 : 1.8 * Utils.normalRelativeAngle((double)(this.enemy.getNextAbsoluteBearing() - this.getRadarHeadingRadians()));
        this.setTurnRadarRightRadians(angle);
    }

    private final void doFire() {
        if (this.energy < 0.11 || this.enemy.getEnergy() < 0.4 && this.energy > (double)2 || this.enemy.getEnergy() == 0.0) {
            return;
        }
        if (this.setFireBullet(this.shoot.getBulletPower()) != null) {
            this.selfWaves.addWave(this.Pos, this.currentTime, this.shoot.getBulletPower());
        }
    }

    private final void doTargeting() {
        if (this.PMTgun.getPatternMatching()) {
            this.shoot.setData(this.PMTgun.execute(this.self, this.enemy, this.manageBulletPower()));
        } else {
            this.shoot.setData(this.LCTgun.execute(this.self, this.enemy, this.manageBulletPower()));
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.shoot.getAbsoluteBearing() - this.getGunHeadingRadians())));
    }

    private final double manageBulletPower() {
        double fatalityPower;
        double enemyDistance = this.enemy.getNextDistance();
        double damage = this.enemy.getEnergy();
        if (damage > 16.0) {
            fatalityPower = Double.POSITIVE_INFINITY;
        } else {
            double d = fatalityPower = damage > (double)4 ? (damage + (double)2) / 6.0 : damage / (double)4;
        }
        if (this.energy < (double)4) {
            return 0.1;
        }
        if (this.energy < 12.0) {
            return Math.min(0.8, fatalityPower);
        }
        if (enemyDistance < 140.0) {
            return Math.min((double)3, fatalityPower);
        }
        if (this.self.bulletHitsOneByOne > 1 && this.energy > 30.0) {
            return Math.min((double)3, fatalityPower);
        }
        return Math.min((double)2, fatalityPower);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.self.setInfo(this);
        this.enemy.setInfo(this.self, event);
        this.PMTgun.setData(this.enemy.getVelocity(), this.enemy.getHeadingChange());
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.self.bulletHitsOneByOne;
        Bullet bl = event.getBullet();
        this.enemy.changeEnergy(-Physics.getDamageOnBulletHit(bl.getPower()));
        this.selfWaves.removeWaveForBulletHit(new Point2D.Double(bl.getX(), bl.getY()), this.getTime());
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        Bullet bl = event.getBullet();
        this.selfWaves.removeWaveForBulletHit(new Point2D.Double(bl.getX(), bl.getY()), this.getTime());
        this.enemyWaves.removeWaveForBulletHit(new Point2D.Double(bl.getX(), bl.getY()), this.getTime());
    }

    public void onHitByBullet(HitByBulletEvent event) {
        Bullet bl = event.getBullet();
        this.enemy.changeEnergy(Physics.getEnergyBackOnBulletHit(bl.getPower()));
        this.enemyWaves.removeWaveForBulletHit(new Point2D.Double(bl.getX(), bl.getY()), this.getTime());
        hitStats.onHit(currentMovement, bl.getPower());
    }

    public void onHitRobot(HitRobotEvent event) {
        this.enemy.changeEnergy(-Physics.getDamageOnRobotHit());
    }

    public void onWin(WinEvent event) {
        this.stop();
        int i = 0;
        while (i < 10) {
            this.turnLeft((i % 2 * 2 - 1) * 360);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.self = new SelfInfo();
        this.Pos = new Point2D.Double();
        this.shoot = new Shoot();
        this.LCTgun = new LCT();
        this.PMTgun = new PMT();
        this.selfWaves = new Wave();
        this.SnGbhv = new SnG();
        this.RTMbhv = new RTM();
        this.RMbhv = new RM();
        this.SemiRamBhv = new SemiRam();
        this.RamBhv = new Ram();
        this.enemy = new EnemyInfo();
        this.enemyWaves = new Wave();
    }

    public ForceMajeure() {
        this.this();
    }

    static {
        hitStats = new HitStats(3);
    }
}

