/*
 * Decompiled with CFR 0.152.
 */
package eem.motion;

import eem.EvBot;
import eem.bullets.bulletsManager;
import eem.bullets.firedBullet;
import eem.bullets.wave;
import eem.misc.logger;
import eem.misc.math;
import eem.motion.basicMotion;
import eem.motion.dangerPoint;
import eem.target.InfoBot;
import eem.target.botsManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;

public class dangerMapMotion
extends basicMotion {
    Point2D.Double DestinationPoint = new Point2D.Double(0.0, 0.0);
    int nPointsToCheckForNewDestination = 50;
    double distToProbeDefault = 100.0;
    double distToProbe1on1 = 200.0;
    double distToProbeWhenRamming = 50.0;
    double distToProbeWhenAtReducedDistance = 50.0;
    double distToProbe = this.distToProbeDefault;
    int dMapSizeX = 20;
    int dMapSizeY = 20;
    Point2D.Double dMapCellSize;
    double[][] dMap;
    double kT;
    double safe_distance_from_bot;
    double distFromWaveToFarToWorry = 400.0;
    double dangerLevelEnemyBot = 100.0;
    boolean rammingCondition = false;
    private static double reducedBotDistanceCoef = 1.0;
    public LinkedList<dangerPoint> dangerPoints;

    @Override
    public void initTic() {
        if (this.myBot.numEnemyBotsAlive == 1) {
            this.distToProbe = this.distToProbe1on1;
            if (this.myBot._trgt.haveTarget) {
                // empty if block
            }
        } else {
            this.distToProbe = this.distToProbeDefault;
        }
        if (reducedBotDistanceCoef < 1.0) {
            this.distToProbe = this.distToProbeWhenAtReducedDistance;
        }
        this.setRammingCondition();
        if (this.rammingCondition) {
            this.distToProbe = this.distToProbeWhenRamming;
        }
        this.setOptimalDistanceFromBot();
    }

    public void setRammingCondition() {
        this.rammingCondition = this.calcRammingCondition();
        if (this.rammingCondition) {
            logger.dbg("Ramming!");
        }
    }

    public boolean calcRammingCondition() {
        return this.myBot._trgt.haveTarget && this.myBot.numEnemyBotsAlive == 1 && this.myBot._trgt.getEnergy() < 0.1;
    }

    public dangerMapMotion(EvBot evBot) {
        super(evBot);
        this.DestinationPoint = (Point2D.Double)this.myBot.myCoord.clone();
        this.dMapCellSize = new Point2D.Double(this.myBot.BattleField.x / (double)this.dMapSizeX, this.myBot.BattleField.y / (double)this.dMapSizeY);
        this.dMap = new double[this.dMapSizeX][this.dMapSizeY];
        this.safe_distance_from_bot = 12 * this.myBot.robotHalfSize + 2;
        this.kT = 0.1;
        this.rammingCondition = false;
    }

    void setOptimalDistanceFromBot() {
        double d = 0.3;
        double d2 = this.myBot._gmanager.overallGunsHitRate() - this.myBot._trgt.getGunHitRate();
        if (this.myBot.numEnemyBotsAlive > 1) {
            reducedBotDistanceCoef = 1.0;
            return;
        }
        if (this.rammingCondition || !this.myBot._trgt.haveTarget || this.myBot.numEnemyBotsAlive == 1) {
            // empty if block
        }
    }

    public void resetDangerMap() {
        this.dMap = new double[this.dMapSizeX][this.dMapSizeY];
    }

    public int[] point2grid(Point2D.Double double_) {
        int[] nArray = new int[]{(int)Math.floor(double_.x / this.dMapCellSize.x), (int)Math.floor(double_.y / this.dMapCellSize.y)};
        return nArray;
    }

    public double grid2dangerLevel(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        return this.dMap[n][n2];
    }

    public double pointDangerFromAllBots(Point2D.Double double_) {
        double d = 0.0;
        d += this.pointDangerFromNonTargetBots(double_);
        return d += this.pointDangerFromTargetBot(double_);
    }

    public double pointDangerFromNonTargetBots(Point2D.Double double_) {
        double d = 0.0;
        double d2 = 1.0;
        long l = this.myBot.ticTime;
        botsManager cfr_ignored_0 = this.myBot._botsmanager;
        for (InfoBot infoBot : botsManager.bots.values()) {
            if (infoBot.getLastSeenTime() > l) continue;
            Point2D.Double double_2 = infoBot.getPosition();
            double d3 = double_.distance(double_2);
            d += math.gaussian(d3, d2 * this.dangerLevelEnemyBot, this.safe_distance_from_bot);
        }
        return d;
    }

    public double pointDangerFromTargetBot(Point2D.Double double_) {
        double d = 0.0;
        double d2 = 1.0;
        if (this.myBot._trgt.haveTarget) {
            Point2D.Double double_2 = this.myBot._trgt.getPosition();
            double d3 = double_.distance(double_2);
            if (this.rammingCondition) {
                d2 = -10.0;
                d += math.gaussian(d3, -2.0 * this.dangerLevelEnemyBot, 2 * this.myBot.robotHalfSize);
            }
            if (reducedBotDistanceCoef < 1.0 && d3 > reducedBotDistanceCoef * this.safe_distance_from_bot) {
                d += math.gaussian(d3, -2.0 * this.dangerLevelEnemyBot, this.safe_distance_from_bot);
            }
            d += math.gaussian(d3, d2 * this.dangerLevelEnemyBot, this.safe_distance_from_bot);
        }
        return d;
    }

    public double pointDangerFromEnemyWavesAndItsPrecursor(Point2D.Double double_) {
        double d = 0.0;
        bulletsManager bulletsManager2 = this.myBot._bmanager;
        if (bulletsManager2 == null) {
            return 0.0;
        }
        LinkedList<wave> linkedList = bulletsManager2.getAllEnemyWaves();
        for (wave wave2 : linkedList) {
            double d2 = wave2.distance(double_);
            if (d2 < 0.0 || d2 > this.distFromWaveToFarToWorry && linkedList.size() > 6) continue;
            for (firedBullet firedBullet2 : wave2.getBullets()) {
                d += firedBullet2.pointDangerFromBulletPrecursor(double_, this.myBot.ticTime);
            }
        }
        return d;
    }

    public double pointDanger(Point2D.Double double_) {
        double d = 0.0;
        d += this.pointDangerFromWalls(double_, EvBot._tracker.getLast().getSpeed());
        if (this.myBot.fightType().equals("1on1") || this.myBot.fightType().equals("melee1on1")) {
            d += this.pointDangerFromCorners(double_, EvBot._tracker.getLast().getSpeed());
        }
        d += this.pointDangerFromAllBots(double_);
        return d += this.pointDangerFromEnemyWavesAndItsPrecursor(double_);
    }

    public double cellDanger(int[] nArray) {
        Point2D.Double double_ = this.cellCenter(nArray[0], nArray[1]);
        return this.pointDanger(double_);
    }

    public void rebuildDangerMap() {
        int[] nArray = new int[2];
        for (int i = 0; i < this.dMapSizeX; ++i) {
            for (int j = 0; j < this.dMapSizeY; ++j) {
                nArray[0] = i;
                nArray[1] = j;
                this.dMap[i][j] = this.cellDanger(nArray);
            }
        }
    }

    private void buildListOfDestinationsToTest() {
        this.dangerPoints = new LinkedList();
        Point2D.Double double_ = (Point2D.Double)this.myBot.myCoord.clone();
        Point2D.Double double_2 = this.myBot._trgt.getPosition();
        double d = this.myBot.myCoord.distance(double_2);
        int n = 0;
        double d2 = Math.random();
        while (n < this.nPointsToCheckForNewDestination) {
            Point2D.Double double_3;
            double d3 = Math.random();
            if (d2 < 0.01) {
                d3 += 1.0;
            }
            double d4 = Math.PI * 2 * Math.random();
            if (this.myBot.fightType().equals("1on1") && this.myBot._trgt.haveTarget) {
                double d5;
                double d6;
                double d7 = d - (double)(this.myBot.robotHalfSize * 2);
                double d8 = Math.abs(this.myBot._bmanager.getClosestToMeWaveTimeArrival()) * 8.0;
                if (d8 < (double)this.myBot.robotHalfSize) {
                    d8 = this.distToProbe;
                }
                double d9 = Math.min(d7, d8);
                d9 = Math.min(d9, this.distToProbe);
                double d10 = Math.min(d8, this.distToProbe);
                double d11 = this.distToProbe;
                double d12 = d10;
                if (d4 < Math.PI) {
                    d6 = d9 * Math.sin(d4);
                    d5 = d10 * Math.cos(d4);
                } else {
                    d6 = d11 * Math.sin(d4);
                    d5 = d12 * Math.cos(d4);
                }
                d5 = d3 * d5;
                d6 = d3 * d6;
                double d13 = Math.toRadians(math.angle2pt(this.myBot.myCoord, double_2));
                double d14 = d5 * Math.cos(d13) + d6 * Math.sin(d13);
                double d15 = -d5 * Math.sin(d13) + d6 * Math.cos(d13);
                double_3 = new Point2D.Double(double_.x + d14, double_.y + d15);
            } else {
                double d16 = d3 * this.distToProbe;
                double_3 = new Point2D.Double(double_.x + d16 * Math.sin(d4), double_.y + d16 * Math.cos(d4));
            }
            double d17 = this.pointDanger(double_3);
            if (!(this.shortestDist2wall(double_3) > (double)(this.myBot.robotHalfSize + 1))) continue;
            this.dangerPoints.add(new dangerPoint(double_3, d17));
            ++n;
        }
    }

    private void sortDangerPoints() {
        Collections.sort(this.dangerPoints);
    }

    private dangerPoint pickDestinationCandidate() {
        this.sortDangerPoints();
        ListIterator listIterator = this.dangerPoints.listIterator();
        dangerPoint dangerPoint2 = this.dangerPoints.getFirst();
        double d = dangerPoint2.dangerLevel;
        while (listIterator.hasNext()) {
            dangerPoint dangerPoint3 = (dangerPoint)listIterator.next();
            double d2 = dangerPoint3.dangerLevel - d;
            if (d2 < 0.0) {
                dangerPoint2 = dangerPoint3;
                continue;
            }
            double d3 = Math.random();
            if (!(d3 < Math.exp(-d2 / this.kT))) continue;
            dangerPoint2 = dangerPoint3;
        }
        return dangerPoint2;
    }

    public void choseNewDestinationPoint() {
        this.buildListOfDestinationsToTest();
        this.sortDangerPoints();
        dangerPoint dangerPoint2 = new dangerPoint(this.DestinationPoint, this.pointDanger(this.DestinationPoint));
        double d = 20.0;
        if (this.myBot.myCoord.distance(this.DestinationPoint) < 5.0 * d) {
            dangerPoint2.dangerLevel += 1000.0;
        }
        dangerPoint dangerPoint3 = this.pickDestinationCandidate();
        double d2 = 10.0;
        if (dangerPoint2.dangerLevel > dangerPoint3.dangerLevel + d2) {
            this.DestinationPoint = dangerPoint3.position;
        }
    }

    @Override
    public void makeMove() {
        this.choseNewDestinationPoint();
        this.moveToPoint(this.DestinationPoint);
    }

    Color dangerLevel2mapColor(double d) {
        int n;
        int n2 = (int)Math.abs(d / 3.0);
        if (n2 > (n = 100)) {
            n2 = n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        Color color = d >= 0.0 ? new Color(255, 0, 0, n2) : new Color(0, 255, 0, n2);
        return color;
    }

    public Point2D.Double cellCenter(int n, int n2) {
        return new Point2D.Double(this.dMapCellSize.x * ((double)n + 0.5), this.dMapCellSize.y * ((double)n2 + 0.5));
    }

    public void drawDangerMapCell(Graphics2D graphics2D, int n, int n2) {
        Point2D.Double double_ = this.cellCenter(n, n2);
        graphics2D.setColor(this.dangerLevel2mapColor(this.dMap[n][n2]));
        graphics2D.fillRect((int)(double_.x - this.dMapCellSize.x / 2.0), (int)(double_.y - this.dMapCellSize.y / 2.0), (int)this.dMapCellSize.x, (int)this.dMapCellSize.y);
    }

    public void drawDangerMap(Graphics2D graphics2D) {
        this.rebuildDangerMap();
        for (int i = 0; i < this.dMapSizeX; ++i) {
            for (int j = 0; j < this.dMapSizeY; ++j) {
                this.drawDangerMapCell(graphics2D, i, j);
            }
        }
    }

    public void drawMotionDestination(Graphics2D graphics2D) {
        graphics2D.setColor(Color.green);
        graphics2D.drawLine((int)this.DestinationPoint.x, (int)this.DestinationPoint.y, (int)this.myBot.myCoord.x, (int)this.myBot.myCoord.y);
        graphics2D.drawOval((int)this.DestinationPoint.x - 5, (int)this.DestinationPoint.y - 5, 10, 10);
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        this.drawMotionDestination(graphics2D);
        this.drawDangerPoints(graphics2D);
    }

    public void drawDangerPoints(Graphics2D graphics2D) {
        ListIterator listIterator = this.dangerPoints.listIterator();
        while (listIterator.hasNext()) {
            dangerPoint dangerPoint2 = (dangerPoint)listIterator.next();
            dangerPoint2.onPaint(graphics2D);
        }
    }

    public void printDangerPoints() {
        ListIterator listIterator = this.dangerPoints.listIterator();
        while (listIterator.hasNext()) {
            ((dangerPoint)listIterator.next()).print();
        }
    }
}

