/*
 * Decompiled with CFR 0.152.
 */
package rjw.radar;

import java.awt.Color;
import rjw.RabidWombat;
import rjw.pluggablerobot.Canvas;
import rjw.pluggablerobot.Math2;
import rjw.radar.EnemyScan;
import rjw.util.Wave;

public class EnemyWave
extends Wave
implements Comparable<EnemyWave> {
    private double _targetBearing;

    public EnemyWave(EnemyScan prevScan, double energyDrop, RabidWombat bot) {
        this._origin = prevScan.p();
        this._fireTime = prevScan.getTick();
        this._energy = energyDrop;
        this._targetBearing = Math2.getAbsoluteTargetBearing(this._origin, bot.getPosition());
    }

    public double getTargetBearing() {
        return this._targetBearing;
    }

    @Override
    public int compareTo(EnemyWave o) {
        return this._fireTime == o.getFireTime() ? 0 : (this._fireTime < o.getFireTime() ? -1 : 1);
    }

    public void draw(Canvas canvas, long tick) {
        double radius = this.radius(tick);
        canvas.setPaint(Color.RED);
        canvas.drawLine(this._origin.x - 4.0, this._origin.y - 4.0, this._origin.x + 4.0, this._origin.y + 4.0);
        canvas.drawLine(this._origin.x - 4.0, this._origin.y + 4.0, this._origin.x + 4.0, this._origin.y - 4.0);
        canvas.drawCircle(this._origin.x, this._origin.y, radius);
    }
}

