/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.predict.Trackable;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.EnemyStats;
import agd.util.IterativeAimStrategy;
import agd.util.PredictedBullet;
import agd.util.RobotInformation;
import agd.util.RobotSighting;
import agd.util.Stats;
import agd.util.World;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class Enemy
implements Trackable {
    String name = null;
    EnemyStats stats = null;
    private double lastAcceleration = 0.0;
    private int totalSightings = 0;
    private List lastSightings = new LinkedList();
    private static final int REMEMBER_COUNT = 200;
    private List bulletPredictions = new LinkedList();
    SortedMap hits = new TreeMap();
    SortedMap theirHits = new TreeMap();
    long lastTurnAt = 0L;
    TargetPrediction[] predictionAlgorithms;
    Set bulletsAimedAt = new HashSet();
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;
    long minXtime = 0L;
    long minYtime = 0L;
    long maxXtime = 0L;
    long maxYtime = 0L;
    private Trackable closestRobotCached = null;
    private long closestRobotCached_time = 0L;

    public Enemy(String name) {
        this.name = name;
        this.stats = Stats.STATS.getEnemyStats(name);
        this.predictionAlgorithms = TargetPrediction.getAlgorithms();
    }

    public String getName() {
        return this.name;
    }

    public EnemyStats getStats() {
        return this.stats;
    }

    public Coord getPosition() {
        return this.getLastSighting().getPosition();
    }

    public double getEnergy() {
        return this.getLastSighting().getScannedRobotEvent().getEnergy();
    }

    public boolean isDisabled() {
        return this.getEnergy() == 0.0;
    }

    private void addSighting(RobotSighting e) {
        this.stats.measurePredictions(e, this);
        this.lastSightings.add(e);
        if (this.lastSightings.size() > 1) {
            this.estimateAcceleration();
        }
        if (this.lastSightings.size() > 200) {
            ListIterator lit = this.lastSightings.listIterator(0);
            lit.next();
            lit.remove();
        }
        ++this.totalSightings;
        this.calcBulletFired();
        this.maintainClipbox(e);
        this.logRobotSighting(e);
    }

    void logRobotSighting(RobotSighting e) {
        double power = 0.0;
        ScannedRobotEvent sre = e.getScannedRobotEvent();
        Coord pos = e.getTheirPosition();
        Compass heading = e.getHeading();
        double velocity = e.getVelocity();
        if (World.logRobotSightings()) {
            System.out.println("ROBOT_LOG," + this.name + "," + sre.getTime() + "," + pos.getX() + "," + pos.getY() + "," + heading.getDegrees() + "," + velocity + "," + power);
        }
    }

    public TargetPrediction getBestPrediction(int flightTime) {
        return this.stats.getBestPrediction(flightTime);
    }

    public void onBulletFired(Bullet b) {
        this.bulletsAimedAt.add(b);
    }

    public void onBulletOutOfPlay(Bullet b) {
        this.bulletsAimedAt.remove(b);
    }

    public Set getBulletsInFlight() {
        return this.bulletsAimedAt;
    }

    public void onBulletHit(BulletHitEvent bhe) {
        this.hits.put(new Long(bhe.getTime()), bhe);
    }

    public void onHitByBullet(HitByBulletEvent hbb) {
        this.theirHits.put(new Long(hbb.getTime()), hbb);
    }

    public void onScannedRobot(ScannedRobotEvent sre) {
        RobotSighting spotted = new RobotSighting(sre, (Robot)World.getAdvancedRobot(), this);
        this.addSighting(spotted);
    }

    public List getBulletPredictions() {
        return this.bulletPredictions;
    }

    public double getLastAcceleration() {
        return this.lastAcceleration;
    }

    public RobotSighting getLastSighting() {
        if (this.lastSightings.size() > 0) {
            ListIterator lit = this.lastSightings.listIterator(this.lastSightings.size());
            return (RobotSighting)lit.previous();
        }
        return null;
    }

    private void estimateAcceleration() {
        ListIterator lit = this.lastSightings.listIterator(this.lastSightings.size());
        RobotSighting lastsighting = (RobotSighting)lit.previous();
        RobotSighting prevsighting = (RobotSighting)lit.previous();
        double deltaVelocity = lastsighting.getScannedRobotEvent().getVelocity() - prevsighting.getScannedRobotEvent().getVelocity();
        long deltaTime = lastsighting.getScannedRobotEvent().getTime() - prevsighting.getScannedRobotEvent().getTime();
        this.lastAcceleration = deltaVelocity / (double)deltaTime;
    }

    private double calcHeadingChange(long overSightings) {
        double avHeadingChange = 0.0;
        long timediff = 0L;
        if (overSightings < 2L) {
            overSightings = 2L;
        }
        if (this.lastSightings.size() >= 2) {
            ListIterator lit = this.lastSightings.listIterator(this.lastSightings.size());
            RobotSighting veryLastSighting = (RobotSighting)lit.previous();
            RobotSighting earlierSighting = null;
            while (overSightings > 1L && lit.hasPrevious()) {
                earlierSighting = (RobotSighting)lit.previous();
                --overSightings;
            }
            timediff = veryLastSighting.getScannedRobotEvent().getTime() - earlierSighting.getScannedRobotEvent().getTime();
            double headingDiff = veryLastSighting.getScannedRobotEvent().getHeading() - earlierSighting.getScannedRobotEvent().getHeading();
            avHeadingChange = headingDiff / (double)timediff;
        }
        return avHeadingChange;
    }

    void calcBulletFired() {
        if (this.lastSightings.size() >= 2) {
            ListIterator lit = this.lastSightings.listIterator(this.lastSightings.size());
            RobotSighting vlastSighting = (RobotSighting)lit.previous();
            ScannedRobotEvent vlast = vlastSighting.getScannedRobotEvent();
            RobotSighting lastbut1Sighting = (RobotSighting)lit.previous();
            ScannedRobotEvent lastbut1 = lastbut1Sighting.getScannedRobotEvent();
            double energyLossDueToHits = this.calcHitDamageBetween(lastbut1.getTime(), vlast.getTime());
            double energyGainDueToHits = this.calcHitGainBetween(lastbut1.getTime(), vlast.getTime());
            if (vlast.getTime() - lastbut1.getTime() < 50L && vlast.getEnergy() < lastbut1.getEnergy()) {
                double power = lastbut1.getEnergy() - vlast.getEnergy();
                power -= energyLossDueToHits;
                if ((power += energyGainDueToHits) >= 0.09 && power <= 3.0) {
                    this.shotDetected(power, vlastSighting, lastbut1Sighting);
                }
            }
        }
    }

    private void shotDetected(double power, RobotSighting vlast, RobotSighting lastbut1) {
        if (World.isDebug()) {
            System.out.println(" =====> Shot detected, power " + World.twodp.format(power));
        }
        double prob = 1.0;
        prob = vlast.getTime() - lastbut1.getTime() > 5L ? 0.125 : 0.25;
        Trackable closestRobot = this.getClosestRobot();
        this.predictBullet(power, vlast.getTime(), vlast.getPosition(), closestRobot, TargetPrediction.STATIONARY, prob);
        this.predictBullet(power, vlast.getTime(), vlast.getPosition(), closestRobot, TargetPrediction.LINEAR, prob);
        this.predictBullet(power, vlast.getTime(), vlast.getPosition(), closestRobot, TargetPrediction.CIRCULAR, prob);
        this.predictBullet(power, vlast.getTime(), vlast.getPosition(), closestRobot, TargetPrediction.AV_POS50, prob);
        if (vlast.getTime() - lastbut1.getTime() > 5L) {
            this.predictBullet(power, lastbut1.getTime(), lastbut1.getPosition(), closestRobot, TargetPrediction.STATIONARY, prob);
            this.predictBullet(power, lastbut1.getTime(), lastbut1.getPosition(), closestRobot, TargetPrediction.LINEAR, prob);
            this.predictBullet(power, lastbut1.getTime(), lastbut1.getPosition(), closestRobot, TargetPrediction.CIRCULAR, prob);
            this.predictBullet(power, lastbut1.getTime(), lastbut1.getPosition(), closestRobot, TargetPrediction.AV_POS50, prob);
        }
    }

    Trackable getClosestRobot() {
        if (World.getTime() != this.closestRobotCached_time) {
            this.closestRobotCached = this.getClosestRobot_Cached();
            this.closestRobotCached_time = World.getTime();
        }
        return this.closestRobotCached;
    }

    private Trackable getClosestRobot_Cached() {
        Collection enemies = ((RobotInformation)World.getAdvancedRobot()).getEnemies().values();
        Iterator i = enemies.iterator();
        Trackable closest = null;
        double closestDistance = 0.0;
        while (i.hasNext()) {
            Trackable robot = (Trackable)i.next();
            if (robot == this) continue;
            List fps = robot.getRecentFootprints();
            Footprint fp = (Footprint)fps.get(fps.size() - 1);
            double thisDistance = fp.getPosition().distanceTo(this.getPosition());
            if (closest != null && !(thisDistance < closestDistance)) continue;
            closest = robot;
            closestDistance = thisDistance;
        }
        Trackable us = (Trackable)World.getAdvancedRobot();
        double distanceToUs = this.getPosition().distanceTo(((RobotInformation)((Object)us)).getPosition());
        if (closest == null || distanceToUs < closestDistance) {
            closest = us;
            closestDistance = distanceToUs;
        }
        return closest;
    }

    private void predictBullet(double power, long timeFired, Coord theirPos, Trackable target, TargetPrediction predictionAlg, double probability) {
        Coord theirPrediction = IterativeAimStrategy.iterate(power, this.getLastSighting().getTheirPosition(), target, timeFired, predictionAlg);
        Compass lpHeading = theirPos.headingTo(theirPrediction);
        PredictedBullet pbullet = new PredictedBullet(this, timeFired, power, lpHeading, probability);
        this.bulletPredictions.add(pbullet);
    }

    double calcHitDamageBetween(long from, long to) {
        double totalDamage = 0.0;
        SortedMap timeperiod = this.hits.subMap(new Long(from), new Long(to + 1L));
        Iterator i = timeperiod.values().iterator();
        int bulletHits = 0;
        while (i.hasNext()) {
            BulletHitEvent bhe = (BulletHitEvent)i.next();
            double bulletPower = bhe.getBullet().getPower();
            ++bulletHits;
            double bulletDamage = 4.0 * bulletPower;
            if (bulletPower > 1.0) {
                bulletDamage += 2.0 * (bulletPower - 1.0);
            }
            totalDamage += bulletDamage;
        }
        return totalDamage;
    }

    double calcHitGainBetween(long from, long to) {
        double totalGain = 0.0;
        SortedMap timeperiod = this.theirHits.subMap(new Long(from), new Long(to + 1L));
        Iterator i = timeperiod.values().iterator();
        int bulletHits = 0;
        while (i.hasNext()) {
            HitByBulletEvent hbb = (HitByBulletEvent)i.next();
            double bulletPower = hbb.getPower();
            ++bulletHits;
            double powerGain = 3.0 * bulletPower;
            totalGain += powerGain;
        }
        return totalGain;
    }

    public String toString() {
        return this.getName();
    }

    public String checkLeaks() {
        StringBuffer info = new StringBuffer(80);
        return this.toString() + " remembers " + this.lastSightings.size() + " sightings";
    }

    public Coord estimateLinearPos(long time) {
        RobotSighting lastSighting = this.getLastSighting();
        ScannedRobotEvent srevent = lastSighting.getScannedRobotEvent();
        Compass lastHeading = new Compass(srevent.getHeading());
        long timediff = time - srevent.getTime();
        double distance = (double)timediff * srevent.getVelocity();
        return lastSighting.getTheirPosition().applyVector(lastHeading, distance);
    }

    public Coord estimateClippedLinearPos(long time) {
        RobotSighting earliestSighting = (RobotSighting)this.lastSightings.get(0);
        Coord clipMin = earliestSighting.getClipMin();
        Coord clipMax = earliestSighting.getClipMax();
        Coord unclipped = this.estimateLinearPos(time);
        double x = Math.min(unclipped.getX(), clipMax.getX());
        x = Math.max(x, clipMin.getX());
        double y = Math.min(unclipped.getY(), clipMax.getY());
        y = Math.max(y, clipMin.getY());
        return new Coord(x, y);
    }

    void maintainClipbox(RobotSighting sighting) {
        Coord min = null;
        Coord max = null;
        ListIterator lit = this.lastSightings.listIterator(this.lastSightings.size());
        while (lit.hasPrevious()) {
            RobotSighting sight = (RobotSighting)lit.previous();
            if (min == null && max == null) {
                min = sight.getClipMin();
                max = sight.getClipMax();
                continue;
            }
            min = new Coord(Math.min(min.getX(), sight.getTheirPosition().getX()), Math.min(min.getY(), sight.getTheirPosition().getY()));
            max = new Coord(Math.max(max.getX(), sight.getTheirPosition().getX()), Math.max(max.getY(), sight.getTheirPosition().getY()));
            sight.setClipMin(min);
            sight.setClipMax(max);
        }
    }

    public List getRecentFootprints() {
        return this.lastSightings;
    }

    static {
        REMEMBER_COUNT = 200;
    }

    static class EnergyComparator
    implements Comparator {
        EnergyComparator() {
        }

        public int compare(Object o1, Object o2) {
            Enemy e1 = (Enemy)o1;
            Enemy e2 = (Enemy)o2;
            if (e1.getEnergy() == e2.getEnergy()) {
                return 0;
            }
            return e1.getEnergy() < e2.getEnergy() ? -1 : 1;
        }
    }
}

