/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.TargetPrediction;
import agd.predict.Trackable;
import agd.util.Aim;
import agd.util.AimStrategy;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import agd.util.World;
import robocode.AdvancedRobot;

public class IterativeAimStrategy
implements AimStrategy {
    RobotInformation ri = null;
    AdvancedRobot ar = null;

    public IterativeAimStrategy(RobotInformation ri) {
        this.ri = ri;
        this.ar = ri.getAdvancedRobot();
    }

    public static Coord iterate(double power, Coord shooterpos, Trackable target, long shotTime, TargetPrediction alg) {
        double bvel = 20.0 - 3.0 * power;
        double distance = 0.0;
        long timeToTarget = 0L;
        Coord estimatedPosition = null;
        Coord previousEstimate = null;
        int i = 0;
        while (i < 10) {
            previousEstimate = estimatedPosition;
            estimatedPosition = alg.predictTarget(target, shotTime + timeToTarget);
            distance = shooterpos.distanceTo(estimatedPosition);
            timeToTarget = (long)(distance / bvel);
            if (previousEstimate != null && estimatedPosition.distanceTo(previousEstimate) < 1.0) break;
            ++i;
        }
        return estimatedPosition;
    }

    public Aim aimAtTarget(Enemy e) {
        if (e == null) {
            return new Aim(new Double(0.0), 0.0);
        }
        if (e.getLastSighting() == null) {
            return new Aim(new Double(0.0), 0.0);
        }
        TargetPrediction prediction = TargetPrediction.CIRCULAR;
        Coord ourpos = this.ri.getPosition();
        long timeToTarget = 0L;
        Coord estPos = prediction.predictTarget(e, World.getTime() + 1L);
        double distance = ourpos.distanceTo(estPos);
        double power = this.firePower(distance, e);
        int roughFlightTime = (int)(distance / World.calcBulletVelocity(power));
        prediction = e.isDisabled() ? TargetPrediction.STATIONARY : e.getBestPrediction(roughFlightTime);
        estPos = IterativeAimStrategy.iterate(power, ourpos, e, World.getTime() + 1L, prediction);
        double bfWidth = World.getBattleFieldSize().getX();
        double bfHeight = World.getBattleFieldSize().getY();
        estPos = new Coord(Math.max(estPos.getX(), 0.0), Math.max(estPos.getY(), 0.0));
        estPos = new Coord(Math.min(estPos.getX(), bfWidth), Math.min(estPos.getY(), bfHeight));
        Compass shotHeading = ourpos.headingTo(estPos);
        Compass gunHeading = new Compass(this.ar.getGunHeading());
        double gunBearing = gunHeading.bearingTo(shotHeading);
        if (!this.decideToShoot(this.ar.getGunHeat(), gunBearing, power, distance)) {
            power = 0.0;
        } else if (World.isDebug()) {
            System.out.println("Shooting at " + e + " power " + World.twodp.format(power) + " using " + prediction);
        }
        return new Aim(new Double(gunBearing), power);
    }

    boolean decideToShoot(double gunHeat, double gunBearing, double power, double distance) {
        double allowedGunDrift = Math.toDegrees(Math.atan(20.0 / distance) / 2.0);
        boolean shoot = true;
        if (gunHeat > 0.0 || Math.abs(gunBearing) > allowedGunDrift || power < 0.1 || power > 4.0) {
            shoot = false;
        }
        return shoot;
    }

    double firePower(double distance, Enemy e) {
        double power = 0.0;
        AdvancedRobot ar = World.getAdvancedRobot();
        double targetEnergy = e.getEnergy();
        power = ar.getEnergy() < (double)ar.getOthers() ? (e.isDisabled() ? 0.1 : 0.0) : (targetEnergy < 1.0 ? Math.max(0.1, targetEnergy / 4.0) : (ar.getEnergy() < 20.0 ? 0.1 : (e.getStats().getOurAccuracy().getAverage() > 0.33 ? 3.0 : (distance < 150.0 ? 3.0 : (distance < 300.0 ? 3.0 : (distance < 600.0 ? 2.8 : (distance < 750.0 ? 2.5 : 2.5)))))));
        if (e.isDisabled() && ar.getGunHeat() == 0.0) {
            System.out.println("Shooting with power " + World.twodp.format(power) + " at disabled robot " + e);
        }
        return power;
    }
}

