/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class YellowBird
extends AdvancedRobot {
    static int ahead = 20;
    static double shootingTarget;
    static int repeater;
    static double targetBearing;
    static int aimingFactor;

    public void onScannedRobot(ScannedRobotEvent event) {
        double firePower = Math.min(this.getEnergy(), event.getEnergy()) / 5.0;
        this.setFire(firePower);
        targetBearing = Utils.normalAbsoluteAngleDegrees((double)(this.getHeading() + event.getBearing()));
        this.setTurnRadarRight(Math.signum(this.getRadarTurnRemaining()) * -999.0);
        repeater = event.getDistance() < 250.0 ? 15 : 40;
        shootingTarget = Utils.normalAbsoluteAngleDegrees((double)(targetBearing + (double)aimingFactor / Rules.getBulletSpeed((double)firePower) * event.getVelocity() * Math.sin(Math.toRadians(Utils.normalRelativeAngleDegrees((double)(event.getHeading() - targetBearing))))));
    }

    public void onDeath(DeathEvent event) {
        aimingFactor = 60 - aimingFactor;
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAllColors(Color.YELLOW);
        this.setTurnRadarRight(999.0);
        while (true) {
            this.setTurnRight(Utils.normalRelativeAngleDegrees((double)(targetBearing - 100.0 - this.getHeading())));
            this.setTurnGunRight(Utils.normalRelativeAngleDegrees((double)(shootingTarget - this.getGunHeading())));
            if (this.getTime() > (long)repeater) {
                this.setAhead(ahead);
            }
            this.execute();
            if (this.getTime() % (long)repeater != 0L) continue;
            ahead = -ahead;
        }
    }

    static {
        repeater = 1;
        aimingFactor = 50;
    }
}

