/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicMinimumRiscMovement;
import Krabb.sliNk.Bot;
import Krabb.sliNk.Data;
import Krabb.sliNk.Garm;
import Krabb.sliNk.Movement;
import Krabb.sliNk.MyWave;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSMeleeMovement
extends BasicMinimumRiscMovement {
    WSMeleeMovement() {
        this.way_n = 4;
        this.surf_waves = false;
        this.surf_time = true;
    }

    @Override
    public void newRound(Movement robot) {
    }

    @Override
    protected double getRisc(MyWave wave, Point2D.Double location, long time, double[][] gf_hit, boolean debug) {
        double risc = 0.1 + Garm.getEnemy(wave.source_stats_segmentation.name).getRisc(wave, location, time, gf_hit, debug);
        double distance_max = Math.sqrt(Garm.field_rect_inner.width * Garm.field_rect_inner.width + Garm.field_rect_inner.height * Garm.field_rect_inner.height);
        double distance = wave.source_stats_segmentation.location.distance(wave.victim_stats_segmentation[0].location);
        double base = 0.3;
        double factor = (1.0 - base) * (1.0 - distance / distance_max);
        return risc * (base + factor);
    }

    @Override
    protected double getDistancePoints(Point2D.Double location_me) {
        double risc_new;
        double distance_my;
        double risc = 0.0;
        for (Bot enemy : Data._enemies_array) {
            if (enemy.getNewestStats() == null || enemy.death) continue;
            distance_my = enemy.getNewestStats().location.distance(location_me);
            risc_new = 0.0;
            if (distance_my < 100.0) {
                risc_new = 0.2;
            } else if (distance_my < 200.0) {
                risc_new = 0.1;
            } else if (distance_my < 300.0) {
                risc_new = 0.05;
            }
            risc += risc_new;
            if (Garm.teamgame) continue;
            double enemy_closest = Data.getNearestEnemyDistance(enemy.getNewestStats().location);
            risc_new = 0.0;
            if (distance_my < enemy_closest - 100.0) {
                risc_new = 0.3;
            } else if (distance_my < enemy_closest) {
                risc_new = 0.2;
            } else if (distance_my < enemy_closest + 100.0) {
                risc_new = 0.1;
            }
            if (distance_my > 700.0) {
                risc_new /= 2.0;
            } else if (distance_my > 500.0) {
                risc_new /= 1.5;
            }
            risc += risc_new / 3.0;
        }
        for (Bot mate : Data._mates_array) {
            if (mate.getNewestStats() == null || mate.name.equals(Garm.mythis.getName()) || mate.death) continue;
            distance_my = mate.getNewestStats().location.distance(location_me);
            risc_new = 0.0;
            if (distance_my < 75.0) {
                risc_new = 30.0;
            } else if (distance_my < 150.0) {
                risc_new = 20.0;
            } else if (distance_my < 300.0) {
                risc_new = 10.0;
            }
            risc += risc_new;
        }
        return risc;
    }

    @Override
    protected double[][] setNextDirection(long time, boolean[] direction_difference, Point2D.Double location, double velocity_current, double heading_current, ArrayList<MyWave> waves, int w, Graphics2D g) {
        double[][] directions = new double[this.way_n][3];
        double heading_desired = 0.0;
        int i = 0;
        while (i < this.way_n) {
            directions[i][2] = 0.0;
            double[] directions_new = this.goToAngle(velocity_current, heading_current, heading_desired);
            directions[i][1] = directions_new[1];
            directions[i][0] = directions_new[0];
            heading_desired += 1.5707963267948966;
            ++i;
        }
        return directions;
    }

    @Override
    public void onPaint(Graphics2D g, Movement robot) {
        super.onPaint(g, robot);
    }
}

